#!/bin/sh

FW_DOWNLOAD_PIPE=/tmp/fw_down
LOCKFILE="/tmp/.provision.lock"

lockup_provision() {
    TEMPFILE="/tmp/.provision.$$"
    echo $$ > $TEMPFILE 2> /dev/null || (
        echo "Do not have permission to access `dirname $TEMPFILE`"
        return 1
    )
    ln $TEMPFILE $LOCKFILE 2> /dev/null && {
        rm -f $TEMPFILE
        return 0
    }
    kill -0 `cat $LOCKFILE` 2> /dev/null && {
        rm -f $TEMPFILE
        return 1
    }
    # Removing stale lock file
    rm -f $LOCKFILE
    ln $TEMPFILE $LOCKFILE 2> /dev/null && {
        rm -f $TEMPFILE
        return 0
    }
    rm -f $TEMPFILE
    return 1
}

remove_lockfile(){
    rm -f $LOCKFILE
    return 0
}

#TODO: dd can not save block offset info required for squashfs bad block remapping,
# need switch to modified scratch_load
#
# $1: image to write
# $2: dev name of cooresponding partition, such as /dev/mmcblk0p1
# $3: full proc name  of image header
prog_mtd_part() {

	# clear proc header
	echo "0" > $3
    #load image
	echo "writing $1 partition"
	dd if=$1 of=$2 bs=512 skip=256 2>/dev/null
	if [ $? -eq 0 ];then
	#	echo "Write $1 Partition Successfully"
		prov_update_proc $1 $3
		if [ $? -eq 0 ]; then
			echo "Upgrade $1 Partition Successfully"
			return 0
		else
			echo "Write $1 header Failed"
			return 240
		fi
		
	else
		echo "Write $1 Partition Failed!!!" 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE}
		return 240
	fi
}


syslog() {
    if [ "`nvram get 208`" != "0" ]; then
        logger -p kern.info -t "`nvram get syslog_id`" "[`cat /proc/gxvboard/dev_info/dev_mac`]" $*
    else
        echo $* > ${DBG_LOG_DEVICE}
    fi
}

save_msg() {
	#echo $1 > ${DBG_LOG_DEVICE}
    syslog $*
}

do_tftp() {
    tftp -g -b 1024 -l $2 -r `tftp_url_process $3/$1` 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE} || {
        case  $? in
        1)
            save_msg "TFTP read file $3/$1 failed"
            echo "TFTP read file $3/$1 failed"
            return 255
            ;;
        2)
            save_msg "TFTP read file $3/$1 terminated"
            echo "TFTP read file $3/$1 terminated"
            return 255
            ;;
        esac
    }
    save_msg "TFTP read file $3/$1 succeeded"
    echo "TFTP read file $3/$1 succeeded"
    return 0
}

do_http() {
#    local lcl_WAN="`nvram get :wan_device`"
     local lcl_WAN="eth0"
    local lcl_IP="`ifconfig $lcl_WAN|grep \"inet addr\"|cut -d \" \" -f12|cut -d \":\" -f2`"
    local lcl_MAC="`cat /proc/gxvboard/dev_info/dev_mac 2> ${DBG_LOG_DEVICE}|tr '[A-Z]' '[a-z]' |tr -d ':'`"
    local lcl_PN="`cat /proc/gxvboard/dev_info/PN`"
#    local lcl_MAC="00:0B:82:31:F4:2F"
#    local lcl_PN="9630001523A"
    local lcl_URL=`echo $3/$1 | sed -e 's/$MAC/'"$lcl_MAC"'/' -e 's/$SN/'"$lcl_PN"'/' -e 's/$IP/'"$lcl_IP"'/'`

	HTTP_U_P=""
	if [ "$4" = "0" ]; then
		lcl_URL=`echo http://$3/$1 | sed -e 's/$MAC/'"$lcl_MAC"'/' -e 's/$SN/'"$lcl_PN"'/' -e 's/$IP/'"$lcl_IP"'/'`
    	if [ ! -z "`nvram get 1360`" -a ! -z "`nvram get 1361`" ]; then
        	HTTP_U_P="--http-user=`nvram get 1360` --http-password=`nvram get 1361`"
	    fi
    	if [ "http://$3/$1" != "$lcl_URL" ]; then
        	save_msg "HTTP URL expanded to $lcl_URL"
	    fi
	else	
    	if [ "$3/$1" != "$lcl_URL" ]; then
        	save_msg "HTTP URL expanded to $lcl_URL"
	    fi
	fi	

    wget $_global_http_range -q -4 -t 3 -T 20 -U "`nvram get user_agent`" $HTTP_U_P "$lcl_URL" -O $2 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE} || {
        return 255
    }
    return 0
}

do_https() {
    local lcl_WAN="`nvram get :wan_device`"
    local lcl_IP="`ifconfig $lcl_WAN|grep \"inet addr\"|cut -d \" \" -f12|cut -d \":\" -f2`"
    local lcl_MAC="`cat /proc/gxvboard/dev_info/dev_mac 2> ${DBG_LOG_DEVICE}|tr '[A-Z]' '[a-z]' |tr -d ':'`"
    local lcl_PN="`cat /proc/gxvboard/dev_info/PN`"
    local lcl_URL=`echo $3/$1 | sed -e 's/$MAC/'"$lcl_MAC"'/' -e 's/$SN/'"$lcl_PN"'/' -e 's/$IP/'"$lcl_IP"'/'`
	
	HTTP_U_P=""
	if [ "$4" = "0" ]; then
		lcl_URL=`echo https://$3/$1 | sed -e 's/$MAC/'"$lcl_MAC"'/' -e 's/$SN/'"$lcl_PN"'/' -e 's/$IP/'"$lcl_IP"'/'`
    	if [ ! -z "`nvram get 1360`" -a ! -z "`nvram get 1361`" ]; then
        	HTTP_U_P="--http-user=`nvram get 1360` --http-password=`nvram get 1361`"
	    fi
    	if [ "https://$3/$1" != "$lcl_URL" ]; then
        	save_msg "HTTPS URL expanded to $lcl_URL"
	    fi
	else	
    	if [ "$3/$1" != "$lcl_URL" ]; then
        	save_msg "HTTPS URL expanded to $lcl_URL"
	    fi
	fi	

    wget $_global_http_range -q -4 -t 3 -T 20 --no-check-certificate --certificate=/etc/gxe50xx.pem --private-key=/etc/gxe50xx.pem -U "`nvram get user_agent`" $HTTP_U_P "$lcl_URL" -O $2 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE} || {
        return 255
    }
    return 0
}

fetch_image() {
	PROVISION_URL="$3"
	#get the image
    if [ -n "${OVERRIDE_TFTP_SERVER}" -a "`nvram get 145`" = "1" ]; then
		PROVISION_URL="${OVERRIDE_TFTP_SERVER}"
		if [ "https:" = "`echo $PROVISION_URL | cut -b1-6 | tr [A-Z] [a-z]`" ]; then
    	    do_https $1 $2 ${PROVISION_URL} 1
		elif [ "http:" = "`echo $PROVISION_URL | cut -b1-5 | tr [A-Z] [a-z]`" ]; then
    	    do_http $1 $2 ${PROVISION_URL} 1
		else
			if [ "tftp:" = "`echo $PROVISION_URL | cut -b1-5 | tr [A-Z] [a-z]`" ]; then
				PROVISION_URL="`echo $PROVISION_URL | cut -b6- | tr [A-Z] [a-z]`"
			fi	
        	tftp_url_process $PROVISION_URL/$1 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE} ||
	        {
    	        save_msg "Failed to parse TFTP url ${PROVISION_URL}/$1"
        	    echo "Failed to parse TFTP url ${PROVISION_URL}/$1"
            	return 255
	        }
    	    do_tftp $1 $2 ${PROVISION_URL}
		fi
	else	
        if [ -z "$3" ]; then
            save_msg "Empty server url"
            echo "Empty server url"
            return 255
        fi
    	if [ "${upgrade_use_tftp}" = "0" ]; then
        	tftp_url_process $PROVISION_URL/$1 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE} ||
	        {
    	        save_msg "Failed to parse TFTP url ${PROVISION_URL}/$1"
        	    echo "Failed to parse TFTP url ${PROVISION_URL}/$1"
            	return 255
	        }
    	    do_tftp $1 $2 ${PROVISION_URL}
	    else
    	    if [ "${upgrade_use_tftp}" = "1" ]; then
        	    do_http $1 $2 ${PROVISION_URL} 0
	        else
    	        do_https $1 $2 ${PROVISION_URL} 0
        	fi
	    fi
	fi	
	return $?
}

fetch_image_pipe() {
	PROVISION_URL="$3"
	#get the image
    if [ -n "${OVERRIDE_TFTP_SERVER}" -a "`nvram get 145`" = "1" ]; then
		PROVISION_URL="${OVERRIDE_TFTP_SERVER}"
		if [ "https:" = "`echo $PROVISION_URL | cut -b1-6 | tr [A-Z] [a-z]`" ]; then
    	    do_https $1 $2 ${PROVISION_URL} 1 &
		elif [ "http:" = "`echo $PROVISION_URL | cut -b1-5 | tr [A-Z] [a-z]`" ]; then
    	    do_http $1 $2 ${PROVISION_URL} 1 &
		else
			if [ "tftp:" = "`echo $PROVISION_URL | cut -b1-5 | tr [A-Z] [a-z]`" ]; then
				PROVISION_URL="`echo $PROVISION_URL | cut -b6- | tr [A-Z] [a-z]`"
			fi	
        	tftp_url_process $PROVISION_URL/$1 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE} ||
	        {
    	        save_msg "Failed to parse TFTP url ${PROVISION_URL}/$1"
        	    echo "Failed to parse TFTP url ${PROVISION_URL}/$1"
            	return 255
	        }
    	    do_tftp $1 $2 ${PROVISION_URL} &
		fi
	else	
        if [ -z "$3" ]; then
            save_msg "Empty server url"
            echo "Empty server url"
            return 255
        fi
    	if [ "${upgrade_use_tftp}" = "0" ]; then
	        tftp_url_process ${PROVISION_URL}/$1 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE} ||
        	{
    	        save_msg "Failed to parse TFTP url ${PROVISION_URL}/$1"
	            echo "Failed to parse TFTP url ${PROVISION_URL}/$1"
            	return 255
        	}
    	    do_tftp $1 $2 ${PROVISION_URL} &
	    else
        	if [ "${upgrade_use_tftp}" = "1" ]; then
    	        do_http $1 $2 ${PROVISION_URL} 0 &
	        else
            	do_https $1 $2 ${PROVISION_URL} 0 &
        	fi
    	fi
	fi
    sleep 1
	return 0
}

#single file with fw images
validate_fwfile() {
    rm -f $FW_DOWNLOAD_PIPE 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE}
    mknod $FW_DOWNLOAD_PIPE p 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE}
    fetch_image_pipe $1 $FW_DOWNLOAD_PIPE $2 && {
        if [ "`nvram get :ignore_fw_ver`" = "1" ]; then
            prov_pipedec_fw $firmware_key $FW_DOWNLOAD_PIPE $IGNORE_FWMASK ignore_fw_ver 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE}
        else
            prov_pipedec_fw $firmware_key $FW_DOWNLOAD_PIPE $IGNORE_FWMASK check_fw_ver 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE}
        fi
        case  $? in
		240)
			save_msg "$1, Flash emmc Failed"
			return 255
			;;
        241)
            #get header tag failed, file does not exist
            save_msg "$1 is skipped due to header tag not found"
            return 255
            ;;
        245)
            save_msg "$1 is skipped due to version compatibility requirement not met"
            return 0
            ;;
        246)
            save_msg "$1 is same version"
			if [ "$UPGRADE_INFO" != "0" ];then
				UPGRADE_INFO="1"
			fi
            return 0
            ;;
        0)
			UPGRADE_INFO="0"	
            return 0
            ;;
        *)
            save_msg "$1 is not valid for upgrade"
            return 0
            ;;
        esac
    }
    return 255
}

#single fw image
validate_fwimage() {
    rm -f $FW_DOWNLOAD_PIPE 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE}
    mknod $FW_DOWNLOAD_PIPE p 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE}
    fetch_image_pipe $1 $FW_DOWNLOAD_PIPE $2 && {
        if [ "`nvram get :ignore_fw_ver`" = "1" ]; then
            prov_pipedec $firmware_key $FW_DOWNLOAD_PIPE $IGNORE_FWMASK ignore_fw_ver 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE}
        else
            prov_pipedec $firmware_key $FW_DOWNLOAD_PIPE $IGNORE_FWMASK check_fw_ver 2> ${DBG_LOG_DEVICE} > ${DBG_LOG_DEVICE}
        fi
        case  $? in
		240)
			save_msg "$3, Flash emmc failed"
			return 255
			;;
        245)
            save_msg "$3 is skipped due to version compatibility requirement not met"
        #    echo "$2 is skipped due to version compatibility requirement not met"
            return 255
            ;;
        246)
            save_msg "$3 is same version"
            if [ "$UPGRADE_INFO" != "0" ]; then
				UPGRADE_INFO="1"
			fi
			return 255
            ;;
        0)
			UPGRADE_INFO="0"
            return 0
            ;;
        *)
            save_msg "$3 is not valid for upgrade"
        #    echo "$2 is not valid for upgrade"
            FW_DOWNLOAD_OK=false
            return 255
            ;;
        esac
    }
    return 255
}


