#!/bin/sh

RESOLV_CONF="/etc/resolv.conf"

start() {
	nvdefault /etc/default_values
	nvparse /etc/network/network.conf > /etc/network.conf.sh
	if [ -r /etc/network.conf.sh ]; then
		. /etc/network.conf.sh
	fi

	/sbin/ifconfig lo 127.0.0.1 netmask 255.0.0.0
	ifconfig eth0 up
	ifconfig eth1 up
	echo -n > ${RESOLV_CONF}

	#set hostname
	hostname="`cat /proc/gxvboard/dev_info/dev_alias`"
	echo "Setting Hostname: ${hostname}"
	echo "127.0.0.1     localhost.localdomain   localhost ${hostname}" > /etc/hosts	
	/bin/hostname ${hostname}

	case ${route_switch_mode} in
		0|1)
			/etc/network/network.nondual
			;;
		2)
			/etc/network/network.dual
			;;
	esac
}

stop() {
	/etc/network/rc.ifplugd stop
	/etc/network/rc.udhcpc stop
	ifconfig eth0 0.0.0.0
	ifconfig eth1 0.0.0.0
	nvram unset :lan1_iface
	nvram unset :lan2_iface
	nvram unset :lan1_device
	nvram unset :lan2_device
	nvram unset :default_iface
	nvram unset :wan_iface
	nvram unset :lan_iface
	nvram unset :wan_device
	nvram unset :lan_device
}

restart() {
	stop
	start
}

case $1 in
start|stop|restart)
	$1
	;;
*)
	echo "Usage: $0 {start|stop|restart}"
	;;
esac

