#!/bin/sh

#USBDISK_DIR="/usbdisk"
#SDMMC_DIR="/sdcard"
FS_TYPE="vfat"
VFAT_OPT="-o noexec,nodev,utf8"
NTFS_OPT="-o noexec,nodev"
FW_DIR="gs43a78f39"
#FW_PATH is the full path of the firmware
FW_PATH=""
DEVICE_ID="`cat /proc/gxvboard/dev_info/dev_id|tr '[A-Z]' '[a-z]' |tr -d '-'|tr -d ' '`"
FW_NAME="${DEVICE_ID}fw.bin"
PID_FILE="/tmp/.provision.lock"
LOG_FILE="/dev/console"
DEV_NODE_PREFIX="/dev"
MKDIR="mkdir -p"

#$1: the full path of firmware
start_provision () {
	if [ -z $1 -o ! -f $1 ]; then
		echo "No Firmware in $1" > $LOG_FILE
	fi
	
#	if [ -f $PID_FILE ]; then
#		LAST_PID="`cat /tmp/.provision.lock`"
#		if [ ! -z "`ps -w | awk '{print $1}' | grep $LAST_PID`" ]; then
#			kill -9 $LAST_PID
#			sleep 1
#		fi
#	fi
	provision_loadfirmware $1
	return $?
}

#$1: filesystem type, $2: full path of dev node  
#$3: mount dir        $4: mount options          $5: loop time
# sleep 1s every loop
mount_loop () {
	local loop_time=$5
	i=1
	while [ $i -le $loop_time ]
	do
		if [ ! -z "`mount | grep $3`" ]; then
			echo "$2 has been mounted" > $LOG_FILE
			return 0
		fi

		mount -t $1 $2 $3 $4
		if [ $? -eq 0 ];then
			echo "Mount sdcard successfully" > $LOG_FILE
			return 0
		fi
		sleep 1
		i=$(($i+1))
	done
	return 1
}

#echo "ACTION = $ACTION" > $LOG_FILE
#echo "MDEV = $MDEV" > $LOG_FILE

#when bootup, the value of ACTION is NULL, so set ACTION to "add"
if [ -z $ACTION ]; then
	ACTION="add"
fi

if [ -z $MDEV ]; then
	exit 1
fi

if [ "`echo $MDEV | cut -c -3`" = "mmc" ]; then
	DEV_TYPE="sdmmc"
elif [ "`echo $MDEV | cut -c -2`" = "sd" ]; then
	DEV_TYPE="usb"
	if [ -z "`echo $MDEV | cut -c 4`" ]; then
		exit 1
	fi
fi

if [ $DEV_TYPE = "sdmmc" -o $DEV_TYPE = "usb" ]; then
	MOUNT_DIR="/media/$MDEV"
else
	MOUNT_DIR=""
fi

case $ACTION in
add )

	if [ ! -z $MOUNT_DIR ]; then
		$MKDIR $MOUNT_DIR
		mount_loop vfat "$DEV_NODE_PREFIX/$MDEV" "$MOUNT_DIR" "$VFAT_OPT" 3
		if [ $? -ne 0 ]; then
			echo "Trying ntfs filesystem" > $LOG_FILE
			mount_loop ntfs  "$DEV_NODE_PREFIX/$MDEV" "$MOUNT_DIR" "$NTFS_OPT" 3
			if [ $? -ne 0 ]; then
				echo "Failed to mount sdcard" > $LOG_FILE
				exit 1
			fi
		fi
	else
		echo "Upgrade is not available" > $LOG_FILE
		exit 1
	fi
	start_provision "$MOUNT_DIR/$FW_DIR/$FW_NAME" && {
		sync
		sleep 1
		reboot
	}
	;;
remove )
	umount -l $MOUNT_DIR 2> /dev/null
	rm -r $MOUNT_DIR
	;;
* )
	echo "Unknown action" >$LOG_FILE
	;;
esac
