/*
 * dspg-wm897X.h -- basic ASoC machine-driver inteface, for dmw-96 based, 
 * DSPG-Audio-HW-style boards, with Wolfson WM8976 or WM8978
 *
 *  Copyright (C) 2011 DSPG
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __DSPG_BRD_WM897X_H
#define __DSPG_BRD_WM897X_H

#include "../codecs/wm897X_mod.h"
#include <sound/dmw-boards.h>


typedef enum{
	WM987X_DAI,
		
#ifdef CONFIG_SND_DMW_SOC_BOARD_CSR8811
	CSR8811_DAI,
#endif

#ifdef CONFIG_SND_DMW_SOC_EVB96_SI3050
	SI3050_DAI,
#endif	
	NUM_OF_DAIs
}dmw96_dai_t;



/* Exported to board-specific asoc machine-driver code: */
/* ---------------------------------------------------  */

static int brd_get_pwramp_shutdn( struct snd_kcontrol *kcontrol,
			   struct snd_ctl_elem_value *ucontrol );
static int brd_set_pwramp_shutdn( struct snd_kcontrol *kcontrol,
			   struct snd_ctl_elem_value *ucontrol );

static int brd_get_pwramp_gain( struct snd_kcontrol *kcontrol,
			 struct snd_ctl_elem_value *ucontrol );
static int brd_set_pwramp_gain( struct snd_kcontrol *kcontrol,
			 struct snd_ctl_elem_value *ucontrol );

static int brd_get_mic_sel( struct snd_kcontrol *kcontrol,
		     struct snd_ctl_elem_value *ucontrol );
static int brd_set_mic_sel( struct snd_kcontrol *kcontrol,
		     struct snd_ctl_elem_value *ucontrol );

static int brd_get_output_sel( struct snd_kcontrol *kcontrol,
		        struct snd_ctl_elem_value *ucontrol );
static int brd_set_output_sel( struct snd_kcontrol *kcontrol,
		        struct snd_ctl_elem_value *ucontrol );


/* Imported from board-specific asoc machine-driver code: */
/* -----------------------------------------------------  */

/* Sound-devices GPIOs: */

/* Output Power-Amp Shutdown */
static const char *pwramp_shutdn_st[];
static const struct soc_enum pwramp_shutdn_enum;

/* Output Power-Amp Gain */
static const char *pwramp_gain_st[];
static const struct soc_enum pwramp_gain_enum;

/* Input Analog Switch */
static const char *micr_sel_st[];
static const struct soc_enum micr_sel_enum;

/* Output Anlog Switch */
static const char *outdev_sel_st[];
static const struct soc_enum outdev_sel_enum;


/* ASoC DAPM Controls, Widgets and Routes: */
static const struct snd_kcontrol_new brd_audio_controls[];
static const size_t len_of_control_array;

static const struct snd_soc_dapm_widget brd_dapm_widgets[];
static const size_t len_of_widget_array;

static const struct snd_soc_dapm_route brd_audio_route[];
static const size_t len_of_route_array;

static const struct wm897X_setup_data hw_data_for_codec;

/* Board-specific functions: */
static int check_valid_board( void );
	
#endif /* __DSPG_BRD_WM897X_H */

