/*
 * dmw-tdm-mstr.h -- P/O DMW ASoC platform driver
 *
 *  Copyright (C) 2011 DSPG Ltd
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __DMW_TDM_MASTER_H
#define __DMW_TDM_MASTER_H

/* Note:
 * Definitions in this file are used Only when the dmw-96 is the TDM Master!
 * -------------------------------------------------------------------------
 */

struct tdm_master_coeff {
	uint fs;	    /* Sample-Rate of ALSA pcm stream, in Hz */
	uint N_bits_in_ts;  /* Number of bits (or SCLKs) in a TDM time-slot */
	uint sclk_divider;  /* dmw-96 sclk divider value */
	uint lrc_fs_x100;   /* 100 * SCLK freq (equals Actual "Sample-rate" on the TDM bus), in Hz */
};

struct tdm_master_coeff * dmw_as_master(uint fs);

#endif /* __DMW_TDM_MASTER_H */

