/*
 * wm897X_mod.h -- WM8976 / WM8978 ALSA SoC
 * Audio Codec driver interface (modified).
 *
 * Copyright (C) 2011 DSPG (DSP Group).
 *
 * Based on wm8968.h:
 *  Copyright 2009 Guennadi Liakhovetski <g.liakhovetski@gmx.de>
 *
 * Modified by Avi Miller <Avi.Miller@dspg.com>
 *
 * 16 October, 2011: 
 * Adapted to kernel 2.6.39 by Avi Miller <Avi.Miller@dspg.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __SND_ASoC_WM897X_H__
#define __SND_ASoC_WM897X_H__

/* Clock divider Id's: 
 * only for divideres which produce clocks that are
 * sourced-out by the chip (not for Internal-clocks dividers) 
 */
enum wm897X_clk_id {
	WM897X_OPCLKDIV,
	WM897X_BCLKDIV,
};

enum wm897X_sysclk_src {
	WM897X_PLL,	/* Use PLL */
	WM897X_MCLK	/* Bypass PLL - use MCLK directly */
};

/* Board HW issues, related to codec operation.
 * Add data items as needed.
 *
 *  - use_tie_off: 'true' if your product has AC-coupling caps on any output.
 *
 */
struct wm897X_setup_data {
	/* Tie-Off usage: enabled if DC-Blocking capacitors,
	 * for Speakers, Headsets, or Earpiece, exist on the board
	 */
	bool use_tie_off;

	/* FSync/LRC frequrncy on the TDM bus, when generated by
	 * the dmw-96, i.e. Wolfson is TDM Slave. In this case,
	 * this is the Actual(!) Sample-Rate.
	 */
	uint lrc_fs_x100;
};

#endif	/* __SND_ASoC_WM897X_H__ */

