/*
 * csr8811.h -- CSR8811 BlueCore: Bluetooth ALSA SoC Audio Codec driver interface
 *
 * Copyright (C) 2011 DSPG (DSP Group).
 *
 * Avi Miller <Avi.Miller@dspg.com>
 *
 * 16 October, 2011: 
 * Adapted to kernel 2.6.39 by Avi Miller <Avi.Miller@dspg.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __SND_ASoC_CSR8811_H__
#define __SND_ASoC_CSR8811_H__

/* Dummy external-Clock-divider Id's */ 
enum csr8811_clk_id {
	CSR8811_BCLKDIV,
};

/* Dummy internal Clock-source Id's */ 
enum csr8811_sysclk_src {
	CSR8811_PLL,
};

struct csr8811_setup_data {
	/* Tie-Off usage: enabled if DC-Blocking capacitors,
	 * for peakers, headsets, or earpiece, exist on the board
	 */
	bool use_tie_off;

	/* FSync/LRC frequrncy on the TDM bus, when generated by
	 * the dmw-96, i.e. CSR is TDM Slave. In this case,
	 * this is the Actual(!) Sample-Rate.
	 */
	uint lrc_fs_x100;
};

#endif	/* __SND_ASoC_CSR8811_H__ */

