#!/bin/sh
# Usage:
#  .GXE_BUILD_CVSCONTROL: file to override the gxe-build.cvscontrol directory
#  build uImage modules: ./make.sh
#  build uImage modules and copy to gxe-build.cvscontrol directory: ./make.sh yes
#

echo -n "" > .scmversion
if [ ! -f .config ]; then
	cp Config_gxe5124 .config
fi

make uImage modules CROSS_COMPILE=arm-none-linux-gnueabi-

GXE_BUILD_CVSCONTROL="/home/zh/IPPBX/image_build/gxe-build.cvscontrol"
if [ -f ".GXE_BUILD_CVSCONTROL" ]; then
	GXE_BUILD_CVSCONTROL="`cat .GXE_BUILD_CVSCONTROL`"
fi

COPY="$1"
SFILE="arch/arm/boot/uImage"
DFILE="${GXE_BUILD_CVSCONTROL}/gxe_image_build/bin/core.img"

SRCSUM="`md5sum ${SFILE}|awk '{print $1}'`"
DSTSUM="`md5sum ${DFILE}|awk '{print $1}'`"
if [ "${SRCSUM}" != "${DSTSUM}" ]; then
	echo "[DIFF] ${SRCSUM} - ${DSTSUM} ${SFILE} - ${DFILE}"
	if [ "${COPY}" = "yes" ]; then
		cp -vf ${SFILE} ${DFILE}
	fi
else
	echo "[SAME] ${SRCSUM} - ${DSTSUM} ${SFILE} - ${DFILE}"
fi

if [ "${COPY}" = "yes" ]; then
	echo "install modules to ${INSTALL_MOD_PATH}"
	export INSTALL_MOD_PATH="${GXE_BUILD_CVSCONTROL}/gxe_image_build/base"
	export INSTALL_MOD_STRIP=1
	make modules_install CROSS_COMPILE=arm-none-linux-gnueabi-
	rm -f ${INSTALL_MOD_PATH}/lib/modules/*/build ${INSTALL_MOD_PATH}/lib/modules/*/source
fi

