#ifndef __DWFB_COMMON
#define __DWFB_COMMON

#include "dwfb_utils_common.h"

struct dwfb_location
{
   unsigned int x_start; /* The start position of the display plane on the X axis */
   unsigned int x_end; /* The end position of the display plane on the X axis */
   unsigned int y_start; /* The start position of the display plane on the Y axis */
   unsigned int y_end; /* The end position of the display plane on the Y axis */
};


//#ifdef CONFIG_FB_DMW96_CURSOR
/*
 
 This struct set up the cursor object
 
 size - the size of the cursor (32x32 or 64x64) 2bit per pixel
 
 cursor_palette - the color palette of the cursor.
 Each pixel within the image bitmap is represented as 2 bit which is the index entry of the palette
 in case of the bitmap value of a given cursor pixel is 0 it will represent transparency to display lower plane. 
 in other cases (i.e when the bitmap value of a given cursor pixel is 1,2 or 3) each 3 entry of the cursor_palette
 is represented as:
 0:4 Blue Color for the index (1,2 or 3) 
 10:5 Green Color for index (1,2 or 3) 
 15:11 Red Color for index (1,2 or 3) 
 TODO: What dose it mean in the SPEC in 8-bit expansion by zero padding
 
 cursor_image - the image of the cursor is 256 * 32 bit
 In case of 64x64 cursor image the memory layout is:
 ---------------------------------------------------
 0x000 p[7,0]  p[6,0]  .. .. .. .. p[0,0]
 0x001 p[15,0] p[14,0] .. .. .. .. p[8,0]
 ..
 ..
 ..
 0x007 p[63,0] .. .. .. .. .. .. ..p[56,0]
 ..
 ..
 ..
 0x1ff p[63,63] .. .. .. .. .. .. p[56,63]
 
 In case of 32x32 cursor image the memory layout is:
 ---------------------------------------------------
 0x000 p[7,0]  p[6,0]  .. .. .. .. p[0,0]
 0x001 p[15,0] p[14,0] .. .. .. .. p[8,0]
 0x003 p[31,0] .. .. .. .. .. ..   p[24,0]
 ..
 ..
 0x07f p[31,31] .. .. .. .. .. ..  p[24,31]
 ..
 ..
 ..
 0x1ff p[63,63] .. .. .. .. .. .. p[56,63]
 image_size - the size of the cursor can be 32x32 or 64x64 that size is important since
 
 Limitations:

 cursor position:
 1) There is a limitation of vertical position. The start position in vertical direction must be even value.
 2) If cursor plane position is outside of display plane, then data located inside display plane will be displayed.
 Cursor image outside of display plane doesn't show in display plane.
 3)Cursor image is clipped automatically at the display plane boundary when it is placed across the right or bottom boundary.
 It can't be located on top or left boundary of display plane. This means that starting position must be within display plane
 
*/

#define LCDC_CURSOR_32x32 0
#define	LCDC_CURSOR_64x64 1

#define CURSOR_PALETTE_SIZE 3
#define LCDC_CURSOR_64 64
#define LCDC_CURSOR_32 32
#define LCDC_CURSOR_BITMAP_ARRAY_SIZE 512

enum {
	DWFB_MODE_INVALID,
	DWFB_MODE_LCD,
	DWFB_MODE_VIDEO_PAL,
	DWFB_MODE_VIDEO_NTSC,
	DWFB_MODE_480P60A,
	DWFB_MODE_720P50A,
	DWFB_MODE_720P60A,
	DWFB_MODE_480P60,
	DWFB_MODE_720P50,
	DWFB_MODE_720P60,
	DWFB_MODE_1080P24,
	DWFB_MODE_1080P25,
	DWFB_MODE_1080P30,
};

struct cursor_bitmap
{
	unsigned short bitmap_array[LCDC_CURSOR_BITMAP_ARRAY_SIZE];
    unsigned short bitmap_size;
};

#define FBIOSET_LCDC_CURSOR_BITMAP			_IOW('W',1, struct cursor_bitmap)
#define FBIOGET_LCDC_CURSOR_BITMAP			_IOR('R',2, struct cursor_bitmap)

#define FBIOSET_LCDC_CURSOR_CMAP		_IOW('W',3,struct fb_cmap)
#define FBIOGET_LCDC_CURSOR_CMAP		_IOR('R',4,struct fb_cmap)

#define FBIOSET_LCDC_CURSOR_LOCATION		_IOW('W',5,struct dwfb_location)
#define FBIOGET_LCDC_CURSOR_LOCATION		_IOR('R',6,struct dwfb_location)

//#endif /*CONFIG_FB_DMW96_CURSOR*/

#define FBIOSET_BACKGROUND _IOW('W',7, unsigned int)
#define FBIOSET_DISPLAY_LOCATION _IOW('W',8, struct dwfb_location)

#define FBIOSET_DISPLAY_CLOCK_RATE  _IOW('W',9, unsigned int)

#define FBIOSET_DISPLAY_MODE  _IOW('W',10, unsigned int)

#endif /*__DWFB_COMMON */
