/*
 * include/media/ov3640.h
 *
 * Shared settings for the OV3640 CameraChip.
 *
 * Contributors:
 *   Pallavi Kulkarni <p-kulkarni@ti.com>
 *   Sergio Aguirre <saaguirre@ti.com>
 *
 * Copyright (C) 2009 Texas Instruments.
 *
 * This file is licensed under the terms of the GNU General Public License
 * version 2. This program is licensed "as is" without any warranty of any
 * kind, whether express or implied.
 */

#ifndef OV3640_H
#define OV3640_H

#include <linux/videodev2.h>

#define OV3640_I2C_ADDR                0x78

struct ov3640_platform_data {
       /* Set power state, zero is off, non-zero is on. */
       int (*power_set)(enum v4l2_power power);
       u32 (*set_xclk)(u32 xclkfreq);
       int (*priv_data_set)(void *);
};

#define vidioc_int_s_reg_num (vidioc_int_priv_start_num + 1)
V4L2_INT_WRAPPER_1(s_reg, const struct v4l2_dbg_register, *);

#define vidioc_int_g_reg_num (vidioc_int_priv_start_num + 2)
V4L2_INT_WRAPPER_1(g_reg, const struct v4l2_dbg_register, *);

#endif /* ifndef OV3640_H */


