#ifndef __CIU_DMW96_H
#define __CIU_DMW96_H

#include <linux/videodev2.h>
#include <media/videobuf-core.h>

#define _IOW32( p, d )				( *((volatile unsigned int*)(p))	= (d) ) 
#define _IOR32( p )					( *((volatile unsigned int*)(p)) )

/* Please remove after develop */
#ifndef __KERNEL__
	#define CONFIG_DMW96_CIU_DEBUG
#endif

#ifdef __KERNEL__

    #define IOW32_CIU( off, val )		writel(  (val) , dmw96ciu_regs + (off)  )
	#define IOR32_CIU( off )			readl(dmw96ciu_regs + (off))

#endif 

#define DUDEBUG(fmt, args...) printk( KERN_ERR "DW_CIU: %s(%d) " fmt, __func__, __LINE__,  ## args)

#ifdef CONFIG_DMW96_CIU_DEBUG
#	ifdef __KERNEL__
#		define PDEBUG(fmt, args...) printk( KERN_ERR "DW_CIU: %s(%d)" fmt, __func__, __LINE__, ## args)
#		define CIU_START() printk(">>>>>>>>>>>>>>>>>>>>>> START(%s) >>>>>>>>>>>>>>>>>>>>>>\n",__func__);
#		define CIU_END() printk("<<<<<<<<<<<<<<<<<<<<<< END(%s) <<<<<<<<<<<<<<<<<<<<<<<<\n",__func__);
#	else
#		define PDEBUG(fmt, args...) printf( "DW_CIU: %s(%d) " fmt, __func__, __LINE__,  ## args)
#	endif
#else
#		define PDEBUG(fmt, args...) do {} while (0)
#		define CIU_START() do {} while (0)
#		define CIU_END() do {} while (0)
#endif

#define SUCCEEDED(res) (((res) == SUCCESS) ? 1: 0) 
#define FAILED(res) (((res) != SUCCESS) ? 1: 0) 

#define SUCCESS 0
#define FAIL -1

#define NUM_CIU_CAPTURE_FORMATS 	(sizeof(ciu_formats) / sizeof(ciu_formats[0]))
#define CIU_SZ_MIN_H_OUTPUT		64
#define CIU_SZ_MIN_W_OUTPUT		64
#define CIU_SZ_MAN_H_OUTPUT		4064
#define CIU_SZ_MAX_W_OUTPUT		5632
#define CIU_SZ_STEP				8

#define NUM_HW_BUFS		CONFIG_DMW96_CIU_NUM_HW_BUF
#define NUM_SW_BUFS		CONFIG_DMW96_CIU_NUM_SW_BUF

#define CIU_BUFFER_HEADER 64

#define CIU_NAME "dmw96ciu"

enum { CIU_FULL = 0 , CIU_HALF , CIU_QUARTER};

struct ciu_pdata {
	void (*ciu_reset)(int enable);
};

struct ciu_device {
	struct device *dev;

	/*** platform HW resources ***/
	unsigned int irq;

};


unsigned int bytes_per_line(unsigned int width, unsigned int pixelformat );
unsigned int image_size(unsigned int width, unsigned int height, unsigned int pixelformat );

void dmw96ciu_enb_set(const unsigned int enb);
void dmw96ciu_oneshot_set(const unsigned int enb);

int ciu_try_fmt_cap(struct v4l2_pix_format *pix_output);
int ciu_enum_framesize(struct v4l2_frmsizeenum *frms);
int ciu_s_fmt_cap(struct v4l2_pix_format *pix,unsigned int scaler_mode, struct v4l2_rect* crect);
int ciu_g_cropcap(struct v4l2_cropcap *a);
int ciu_g_crop(struct v4l2_crop *a);
int ciu_s_crop(struct v4l2_crop *a, struct v4l2_pix_format *pix);
int ciu_enum_fmt_cap(struct v4l2_fmtdesc *f);

int ciu_disable_block(void);
int ciu_enable_block(void);

int ciu_buf_queue(struct videobuf_buffer *vb,
				  void (*complete)(struct videobuf_buffer *vb, void *priv),
				  void *priv);


int ciu_configure_intreface(void);

void ciu_vbq_release(struct videobuf_queue *vbq, struct videobuf_buffer *vb);

void ciu_buf_init(void);


#endif // __CIU_DIRVER__
