/* linux/arch/arm/mach-dmw/include/mach/spi.h
 *
 * Copyright (c) 2010 DSPG Technologies GmbH
 *
 * The file is based on s3c2410 spi.h
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __SPI_DMW96_H
#define __SPI_DMW96_H

#include <linux/spi/spi_bitbang.h>

struct spi_board_info;

struct dmw96_spi_info {
	int bus_num;
	void (*set_cs)(struct dmw96_spi_info *spi, unsigned int chip_select,
	               int val, int pol);
    char (*get_cs_bank)(unsigned int chip_select);
    uint32_t (*get_cs_mask)(unsigned int chip_select);
};

struct dmw96_spi {
    /* bitbang has to be first */
    struct spi_bitbang   bitbang;
    struct completion    done;

    void __iomem        *regs;
    int          irq;
    int          remaining_bytes;

    /* data buffers */
    const unsigned char *tx_ptr;
    unsigned char       *rx_ptr;

    int          chip_select;

    struct clk      *clk;
    struct resource     *ioarea;
    struct spi_master   *master;

    struct device       *dev;
    
    struct dmw96_spi_info   *pdata;

#ifdef CONFIG_DMW96_GDMAC
    /* DMA */
    struct dmw96dma_list    *dma_rx_list;
    struct dmw96dma_list    *dma_tx_list;
    unsigned int             dma_rx_channel;
    unsigned int             dma_tx_channel;
#endif
    struct timer_list timer;
};


#endif
