/*
 * Copyright (C) 2005 Grandstream Networks, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __LINUX_SPI_MINI_H
#define __LINUX_SPI_MINI_H

//================
// Defines
//================

/* Configuration */
#define MINI_SPI_BATCH_REGS
#define MINI_SPI_USE_MUTEX

/* Registers */
#define SPI2_BASE 0x05E00000
#define GPIO_BASE 0x05000000

//================
// Typedefs
//================

struct mini_spi_dat {
    unsigned char* iomem;
    struct {
        volatile uint32_t* spi_cfg_reg;
        volatile uint32_t* spi_rate_cntl;
        volatile uint32_t* spi_int_en;
        volatile uint32_t* spi_int_st;
        volatile uint32_t* spi_int_clr;
        volatile uint32_t* spi_cause_reg;
        volatile uint32_t* spi_tx_dat;
        volatile uint32_t* spi_rx_dat;
        volatile uint32_t* spi_del_val;
        volatile uint32_t* spi_rx_buff;
    } regs;
    unsigned char* gpio_iomem;
    struct {
        volatile uint32_t* port_a_set;
        volatile uint32_t* port_a_clr;
        volatile uint32_t* port_f_set;
        volatile uint32_t* port_f_clr;
        volatile uint32_t* port_g_set;
        volatile uint32_t* port_g_clr;
    } gpio;
    struct {
        volatile uint32_t* cs_set[5];
        volatile uint32_t* cs_clr[5];
        uint32_t mask[5];
    } chip_select;
    spinlock_t lock;
};

//=================
// Data
//=================
/*
 * Public Data
 */
extern struct mutex mini_spi_mutex;
extern struct mini_spi_dat mini_spi_dat;

//=================
// Functions
//=================
/*
 * Public Functions
 */
void mini_spi_setup( struct spi_device* spi );
static inline void mini_spi_cs_delay(void)
{   
    int i;
    volatile int j;

    /* Si3050 specifies Tcs = 220ns */
    /* Si3226 specifies Tcs = 220ns (same) */
    /* This loop is 300-400ns. */
    for ( i = 0; i < 50; i++ )
        j++;
}


#endif /* __LINUX_SPI_MINI_H */
