#ifndef __GS_MISC_H_
#define __GS_MISC_H_

#define GS_STORAGE_EMMC        0x20120329
#define GS_STORAGE_FLASH       0x20111214
int gs_get_storage(void);

struct gsboard_gpio
{
    char *gpio_name;
    int gpio_pin;
    int gpio_dir;   /* 0 for in, 1 for out */
    int skip_init;
    int init_val;
    int pwm_value;
};

struct gs_lcd_platform_data {
	unsigned int reset;
	unsigned int lcd_cd;
};

#define PNSTR_MASK                  "###00###"
#define PNSTR_LEN                   8
#define IHWI_REV(a,b,c)		((a)|((b)<<8)|(c<<16))

static inline int compare_pn_str(char *pn_cfg, char *pn_def)
{
    int ii;
    char pnstr_mask[PNSTR_LEN + 1] = PNSTR_MASK;

    for (ii = 0; ii < PNSTR_LEN; ii ++)
    {
        if (pnstr_mask[ii] == '#' && pn_cfg[ii] != pn_def[ii])
            return 1;
    }
    return 0;
}

#ifdef CONFIG_DMW_BOARD_GXE51XX
#define IHWI_REV_V10A	IHWI_REV('1', '0', 'A')
#define IHWI_REV_V11A	IHWI_REV('1', '1', 'A')
#define IHWI_REV_V12A   IHWI_REV('1', '2', 'A')

/* 
 * @2012-12-29 19:26 EP3
 * GXE5124 rename to GXE5116, GXE5121 rename to GXE5104
 * add GXE5108 GXE5102
 * @2012-12-30 09:52 all hardware version restart from V1.4A
 * @2013-03-14 rename again, FACTORYPARA's hw_model is used for identity,
 * previous PartNumber is used. 
 */
#define IHWI_REV_V14A     IHWI_REV('1', '4', 'A')

#define HW_GXE5102_PNSTR	"96600013"
#define HW_GXE5104_PNSTR        "96600019"
#define HW_GXE5108_PNSTR        "96600018"
#define HW_GXE5116_PNSTR        "96600012"

#define IHWI_MODEL_GXE5102		0x5102
#define IHWI_MODEL_GXE5104		0x5104
#define IHWI_MODEL_GXE5108		0x5108
#define IHWI_MODEL_GXE5116		0x5116
#endif

#ifdef CONFIG_DMW_BOARD_UCM62XX
#define HW_UCM6202_PNSTR	"96600023"
#define IHWI_MODEL_UCM6202		0x6202
#define HW_UCM6201_PNSTR	"96600026"
#define IHWI_MODEL_UCM6201		0x6201

struct xhfc_platform_data {
	unsigned int reset;
	unsigned int card0;
	unsigned int card1;
	unsigned int card2;
	unsigned int cs_gpio;
	unsigned int int_gpio;
	unsigned int chips;
	unsigned int led_count;
	unsigned int *led_gpio;
	unsigned int *isdn_gpio;
	unsigned int irqno;
};

#endif

typedef enum
{
        LEDID_SD,
        LEDID_USB,
        LEDID_MAX,
}LED_ID;

struct blkdev_led
{
	LED_ID id;
	int gpio;
};

struct blkdev_led_platform_data {
        unsigned int count;
        struct blkdev_led *blkdev_leds;
};

#ifdef CONFIG_DMW_BOARD_GXE51XX
void *__init gxe5116_get_board_gpio(unsigned int hwrev, int *count);
void *__init gxe5108_get_board_gpio(unsigned int hwrev, int *count);
void *__init gxe5104_get_board_gpio(unsigned int hwrev, int *count);
void *__init gxe5102_get_board_gpio(unsigned int hwrev, int *count);
int __init board_gxe5116_init(unsigned int hwrev);
int __init board_gxe5108_init(unsigned int hwrev);
int __init board_gxe5104_init(unsigned int hwrev);
int __init board_gxe5102_init(unsigned int hwrev);
#endif

#ifdef CONFIG_DMW_BOARD_UCM62XX
void *__init ucm6102_get_board_gpio(unsigned int hwrev, int *count);
int __init board_ucm6102_init(unsigned int hwrev);
#endif

#endif

