#ifndef __GS_DEFINITION__
#define __GS_DEFINITION__

#define GS_PROD_SIGNATURE       0x47453531
#define GS_FACTORY_CFG_OFFSET   0x00300000      
#define GS_FACTORY_CFG_SIZE     0x200000          /* 2MB */
#define MAX_PIC_SIZE		0x10000

typedef struct
{
    unsigned  short int length[2];       //the length of factorypara.confg file,Length[1]<<16| Length[0]
    unsigned  short int checksum;        //This filler ensures that all fields add up to 0x0000
    unsigned  short int mac[3];          //Ethernet MAC address
    unsigned  short int hw_model;        
    unsigned  short int RevID[4][2];     //RevID[0][0]main PCB, major component change,(V2.0 = 0x0200),(V2.1 = 0x0201).
										//RevID[0][1] main PCB, minor component change(RevB = 0x0001),(RevA = 0x0000)
    unsigned  short int version;
	unsigned  short int PartNumber[6];
	unsigned  short int reserved[21];
    unsigned  short int hw_feature_table_word[];
} GS_FACTORYPARA;

typedef enum
{
    HW_FEATURE_LOWEST_FIRMWARE_VERSION = 2,   
    HW_FEATURE_VENDOR = 3,                    

    HW_FEATURE_HEADSET_TYPE = 600,
    HW_FEATURE_ETH_DEV = 601,
    HW_FEATURE_FXO_CS = 602,
    HW_FEATURE_FXS_CS = 603,
    HW_FEATURE_FLASH_TYPE = 604,

    HW_FEATURE_MODELSTR = 605,                 
    HW_FEATURE_MODELALIAS = 606,               
    HW_FEATURE_MODELBASE  = 650,

    HW_FEATURE_FWKEY = 607,                    
    HW_FEATURE_LOGODEF = 608,                  
    HW_FEATURE_LOGODATA = 609,                 
    HW_FEATURE_OEM_ID = 610,                   
    HW_FEATURE_VENDOR_FULLNAME = 611,          

    HW_FEATURE_CAMERA_SENSOR_TYPE = 612,
    HW_FEATURE_CDC_DEV = 613,
    HW_FEATURE_PA_SHUTDOWN_TYPE = 614,
    HW_FEATURE_CAMERA_STANDBY_CTRL = 615,
    HW_FEATURE_CPU_TYPE = 616,

    HW_FEATURE_HF_PA_GAIN = 617,                  
    HW_FEATURE_HF_SPEAKER_TYPE = 618,             
    HW_FEATURE_HF_MIC_TYPE = 619,                 
    HW_FEATURE_HANDSET_TYPE = 620,            
    HW_FEATURE_AUDIO_CDC_MCLK_RATE = 621,
    HW_FEATURE_HAS_WAN = 622,

    HW_FEATURE_TOUCH_SCREEN_TYPE = 700,
    HW_FEATURE_USB_GPIO_SET = 701,
    HW_FEATURE_USB_HUB_CLK_SRC = 702,
    HW_FEATURE_CAM_BITS = 945,

	HW_FEATURE_NUM_FXO = 1314,
	HW_FEATURE_NUM_FXS = 1315,
	HW_FEATURE_NUM_ETH = 1316,
	HW_FEATURE_ALLOW_NAT = 1317,
	HW_FEATURE_SVIP_TYPE = 1318,
	HW_FEATURE_NUM_BRI = 1319,

	HW_SECURITY_TABLE_MAGIC = 1410,

    HW_FEATURE_NOT_RELATED = 0xFFFF,
	HW_FEATURE_START_SCREEN = 0
}hw_feature_type_t;


#endif
