/****************************************************************************
 *
 * FILENAME:        $RCSfile: kgui.c,v $
 *
 * LAST REVISION:   $Revision: 1.1 $
 * LAST MODIFIED:   $Date: 2012/07/23 05:47:40 $
 *
 * DESCRIPTION:
 *
 * vi: set ts=4:
 *
 * Copyright (c) 2005 by Grandstream Networks, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 ***************************************************************************/
#define CONFIG_HW_MODEL_GXP1400
//#define CONFIG_FB_UC1701

//=======================
//  Includes
//=======================
#include <linux/module.h>
#include <linux/fb.h>
#include <linux/kthread.h>
#include <linux/delay.h>
#include "kgui.h"
#include "font.h"
#if defined( CONFIG_FB_LOGO )
#include "ct_logo.h"
#endif

//=======================
//  Defines
//=======================
#define KERNING 1
#define SPACING 6

#define BLACK 0xF0
#if defined( CONFIG_FB_GREYSCALE )
#define GREY  0x80
#else
#define GREY 0xF0
#endif

#if defined( CONFIG_HW_MODEL_GXP1450 ) || defined( CONFIG_HW_MODEL_GXP1400 ) || defined(CONFIG_HW_MODEL_GXP1150)
#define SMALL_LCD 1
#endif

//=======================
//  Globals
//=======================
void fb_sync_region( int x, int y, int width, int height );

//=======================
//  Typedefs
//=======================

//=======================
//  Locals
//=======================
    /*
     * Private Data
     */
static int throbber_location = -1;
static struct task_struct * throbber_thread = NULL;
static int progress_location = -1;
static int progress_enabled = 0;
static int progress_max;
static int progress_now;

static character_t fallback_glyph =
    {
        0,
        {
            0xFFFF, /* **************** */
            0x8001, /* *              * */
            0x8001, /* *              * */
            0x8001, /* *              * */
            0x8001, /* *              * */
            0x8001, /* *              * */
            0x8281, /* *     * *      * */
            0x8101, /* *      *       * */
            0x8281, /* *     * *      * */
            0x8001, /* *              * */
            0x8001, /* *              * */
            0x8001, /* *              * */
            0x8001, /* *              * */
            0x8001, /* *              * */
            0xFFFF  /* **************** */
        },
        16
    };
static unsigned char * framebuffer_data;
static unsigned int screen_size_x;
static unsigned int screen_size_y;
static unsigned int viewable_x;
static unsigned int viewable_y;
static unsigned int start_x;
static unsigned int shift_bpp;

    /*
     * Private Functions
     */
/* Utility Functions */
static character_t * find_glyph( unsigned int utf8 );
static unsigned int decode_utf8( unsigned char * buf, int bytes );
static unsigned int getchar_utf8( unsigned char * str, int * offset );
static void draw_glyphs( character_t ** glyphs, int len, int x, int y );
static void draw_glyph( character_t * glyph, int x, int y );
static void put_pixel( unsigned char color, int x, int y );
static void clear_block( int x, int y, int width, int height );
static int throbber_task( void * data );
static int y_location( int location );

//=======================
//  Functions
//=======================

//=============================================================================
void
kgui_init(
    unsigned char * fb,
    unsigned int lcd_width,
    unsigned int lcd_height,
    unsigned int width,
    unsigned int height,
    unsigned int start,
    unsigned int depth
)
//=============================================================================
{
    //printk("!!!! KGUI INIT\n");
    framebuffer_data = fb;
    screen_size_x = lcd_width;
    screen_size_y = lcd_height;
    viewable_x = width;
    viewable_y = height;
    start_x = start;
    if ( depth == 4 )
        shift_bpp = 1;
    if ( depth == 8 )
        shift_bpp = 0;
}

//=============================================================================
void
kgui_logo(
    void
)
//=============================================================================
{
#if defined( CONFIG_FB_LOGO )
    int i;
    int j;

    for ( i = 0; i < logo_height; i++ ) {
        for ( j = 0; j < logo_width; j++ ) {
#if defined( CONFIG_FB_UC1701 )
            if ( logo_data[ i * logo_width + j ] ) {
                put_pixel( BLACK, j, i );
            }
#else
        put_pixel( logo_data[ i * logo_width + j ] << 4, j + start_x, i );
#endif
        }
    }
#endif
}

//=============================================================================
void
kgui_progress(
    int increment
)
//=============================================================================
{
    int x, y;
    int i, j;

    if ( progress_enabled == 0 || progress_max == 0 )
    {
        return;
    }

    progress_now += increment;
    if ( progress_now > progress_max )
        progress_now = progress_max;

    y = y_location( progress_location );
#if defined( CONFIG_HW_MODEL_GXP1400 ) || defined(CONFIG_HW_MODEL_GXP1150)
    y += 3;
#endif
    x = viewable_x / 2 - 52 + start_x;

    clear_block( x - 1, y, 106, 10 );

    for ( i = 0; i < 102; i++ )
    {
        put_pixel( BLACK, x + i, y );
    }
    put_pixel( BLACK, x - 1, y + 1 );
    put_pixel( BLACK, x + 102, y + 1 );
    for ( i = 0; i < 6; i++ )
    {
        put_pixel( BLACK, x - 1, y + 2 + i );
        put_pixel( BLACK, x + 102, y + 2 + i );
        for ( j = 0; j < ( 100 * progress_now / progress_max ); j++ )
        {
            put_pixel( GREY, x + 1 + j, y + 2 + i );
        }
    }
    put_pixel( BLACK, x - 1, y + 8 );
    put_pixel( BLACK, x + 102, y + 8 );
    for ( i = 0; i < 102; i++ )
    {
        put_pixel( BLACK, x + i, y + 9 );
    }

    fb_sync_region( 0, 0, screen_size_x, screen_size_y );
}

//=============================================================================
void
kgui_enable_progress(
    int location,
    int max
)
//=============================================================================
{
    progress_enabled = 1;
    progress_max = max;
    progress_now = 0;
    progress_location = location;
    kgui_progress(0);
}

//=============================================================================
void
kgui_cancel_progress(
    void
)
//=============================================================================
{
    int x, y;

    progress_enabled = 0;

    if ( progress_location < 0 )
        return;

    y = y_location( progress_location );
#if defined( CONFIG_HW_MODEL_GXP1400 ) || defined(CONFIG_HW_MODEL_GXP1150)
    y += 3;
#endif
    x = viewable_x / 2 - 52 + start_x;

    clear_block( x - 1, y, 106, 10 );
}

//=============================================================================
void
kgui_throbber(
    int location
)
//=============================================================================
{
    throbber_location = location;

    if ( throbber_thread == NULL )
        throbber_thread = kthread_run( throbber_task, 0, "throbber" );
}

//=============================================================================
void
kgui_cancel_throbber(
    void
)
//=============================================================================
{
    if ( throbber_thread )
        kthread_stop( throbber_thread );
    throbber_thread = 0;
}

//=============================================================================
int
throbber_task(
    void * data
)
//=============================================================================
{
    int x, y;
    int i, j;
    int throbber = 0;

	y = y_location( throbber_location );
#if defined( CONFIG_HW_MODEL_GXP1400 ) || defined(CONFIG_HW_MODEL_GXP1150)
    y += 3;
#endif
    x = viewable_x / 2 - 52 + start_x;

    while ( !kthread_should_stop() )
    {
        clear_block( x - 1, y, 106, 10 );

        for ( i = 0; i < 102; i++ )
        {
            put_pixel( BLACK, x + i, y );
        }
        put_pixel( BLACK, x - 1, y + 1 );
        put_pixel( BLACK, x + 102, y + 1 );
        for ( i = 0; i < 6; i++ )
        {
            put_pixel( BLACK, x - 1, y + 2 + i );
            put_pixel( BLACK, x + 102, y + 2 + i );
            if ( throbber < 32 )
            {
                for ( j = 0; j < throbber; j++ )
                {
                    put_pixel( GREY, x + 1 + j, y + 2 + i );
                }
            }
            else
            {
                for ( j = 0; j < 32; j++ )
                {
                    if ( 1 + ( throbber - 32 ) + j <= 100 )
                        put_pixel( GREY, x + 1 + ( throbber - 32 ) + j, y + 2 + i );
                    else
                        break;
                }
            }
        }
        put_pixel( BLACK, x - 1, y + 8 );
        put_pixel( BLACK, x + 102, y + 8 );
        for ( i = 0; i < 102; i++ )
        {
            put_pixel( BLACK, x + i, y + 9 );
        }

		fb_sync_region( 0, 0, screen_size_x, screen_size_y );

        if ( throbber > 132 )
            throbber = 0;
        else
            throbber += 1;

		msleep_interruptible( 25 );
    }

    return 0;
}

//=============================================================================
void
kgui_string(
    char * str,
    int location
)
//=============================================================================
{
    int x, y;
    int printable_width;
    int str_bytes;
    int i, j;
    character_t * utf8_char[256];
    int utf8_index;
    int utf8_len;
    //int split_points[16];
    int offset;

    y = y_location( location );

    str_bytes = strlen( str );
    utf8_index = 0;
    offset = 0;
    for ( offset = 0; offset < str_bytes; )
    {
        unsigned int utf8;
        utf8 = getchar_utf8( str, &offset );
        if ( utf8 == 0 )
        {
            printk("Invalid UTF8\n");
            return;
        }
        utf8_char[ utf8_index ] = find_glyph( utf8 );
        if ( utf8_char[ utf8_index ] == NULL )
        {
            utf8_char[ utf8_index ] = &fallback_glyph;
        }

        utf8_index++;
    }
    utf8_char[ utf8_index ] = 0;
    utf8_len = utf8_index;

    printable_width = 0;
    for ( i = 0; i < utf8_len; i++ )
    {
        printable_width += utf8_char[i]->width + KERNING;
    }

    if ( printable_width > viewable_x )
    {
        struct {
            int start;
            int width;
            int chars;
        } fragments[128];
        int fi = 0;
        int last_char = 0x20;
        int line_width;
        int line_start;

        memset( fragments, 0, sizeof ( fragments ) );

#if defined( CONFIG_HW_MODEL_GXP2100 ) || defined( CONFIG_HW_MODEL_GXP2100V2 )
        if ( location == LOCATION_TOP )
        {
            y = 4;
        }
#endif

        for ( i = 0; i < utf8_len; i++ )
        {
            if ( last_char == 0x20 && utf8_char[i]->utf8 != 0x20 )
            {
                fragments[fi].start = i;
                for ( j = i; j < utf8_len; j++ )
                {
                    if ( utf8_char[j]->utf8 == 0x20 )
                        break;
                    fragments[fi].width += utf8_char[j]->width + KERNING;
                    fragments[fi].chars++;
                }
                fi++;
                i = j;
                last_char = 0x20;
                continue;
            }
            last_char = utf8_char[i]->utf8;
        }

        line_width = 0;
        line_start = 0;
        for ( i = 0; i < fi; i++ )
        {
            if ( fragments[i].width > viewable_x )
            {
                continue;
            }
            else if ( line_width + fragments[i].width + SPACING > viewable_x )
            {
                int next_line = 0;

                clear_block( start_x, y, viewable_x, 16 );

                x = ( viewable_x - line_width ) / 2;
                x += start_x;
                for ( j = line_start; j < i; j++ )
                {
                    draw_glyphs( &utf8_char[fragments[j].start], fragments[j].chars, x, y  );
                    x += fragments[j].width + SPACING;
                }
                y += 16;

                line_start = -1;
                for ( j = i; j < fi; j++ )
                {
                    if ( fragments[j].width <= viewable_x )
                    {
                        line_start = j;
                        line_width = fragments[j].width + SPACING;
                        i = j;
                        break;
                    }
                }
                if ( line_start < 0 )
                {
                    break;
                }
                for ( j = line_start; j < fi; j++ )
                {
                    next_line += fragments[j].width + SPACING;
                }
                if ( next_line < viewable_x )
                {
                    clear_block( start_x, y, viewable_x, 16 );

                    x = ( viewable_x - next_line ) / 2;
                    x += start_x;
                    for ( j = line_start; j < fi; j++ )
                    {
                        draw_glyphs( &utf8_char[fragments[j].start], fragments[j].chars, x, y  );
                        x += fragments[j].width + SPACING;
                    }
                    break;
                }
                continue;
            }
            else
            {
                line_width += ( fragments[i].width + SPACING );
            }
        }

    }
    else
    {
        clear_block( start_x, y, viewable_x, 16 );

        x = ( viewable_x - printable_width ) / 2;
        x += start_x;
        draw_glyphs( utf8_char, utf8_len, x, y  );
    }
}

//=============================================================================
static void
draw_glyphs(
    character_t ** glyphs,
    int len,
    int x,
    int y
)
//=============================================================================
{
    int i;

    for ( i = 0; i < len; i++ )
    {
        draw_glyph( glyphs[i], x, y );
        x += glyphs[i]->width + KERNING;
    }
}

//=============================================================================
static void
draw_glyph(
    character_t * glyph,
    int x,
    int y
)
//=============================================================================
{
    int i, j;
    int tx, ty;

    if ( !glyph )
    {
        glyph = &fallback_glyph;
    }

    tx = x;
    ty = y;
    for ( i = 0; i < 15; i++ )
    {
        for ( j = 15; j >= (signed)( 16 - glyph->width ); j-- )
        {
            if ( glyph->glyph[i] & ( 1 << j ) )
            {
                put_pixel( BLACK, tx, ty );
            }
            tx++;
        }
        tx = x;
        ty++;
    }
}

//=============================================================================
static character_t *
find_glyph(
    unsigned int utf8
)
//=============================================================================
{
    int i;

    for ( i = 0; i < unifont.num_chars; i++ )
    {
        if ( unifont.characters[i].utf8 == utf8 )
        {
            return &unifont.characters[i];
        }
    }

    return NULL;
}

//=============================================================================
static void
put_pixel(
    unsigned char color,
    int x,
    int y
)
//=============================================================================
{
    unsigned char * p_fb;

#if defined( CONFIG_FB_UC1701 )
    p_fb = framebuffer_data + ( screen_size_x * ( y / 8 ) + x );
    *p_fb |= ( ( color != 0 ) << ( y % 8 ) );
#elif defined( CONFIG_FB_UC1698 )
    p_fb = framebuffer_data + ( ( ( y * screen_size_x ) + x ) >> shift_bpp );
    *p_fb |= ( color >> ( 4 * ( x & 1 ) ) );
#elif defined( CONFIG_FB_ST7586 )
    p_fb = framebuffer_data + ( ( ( y * screen_size_x ) + x ) >> shift_bpp );
    *p_fb |= ( color >> ( 4 * ( x & 1 ) ) );
#else
    #error Controller not supported
#endif
}

//=============================================================================
static void
clear_block(
    int x,
    int y,
    int width,
    int height
)
//=============================================================================
{
    unsigned char * p_fb;
    int i;

#if defined( CONFIG_FB_UC1701 )
    int j;

    for ( i = x; i < ( x + width ); i++ )
    {
        for ( j = y; j < ( y + height ); j++ )
        {
            p_fb = framebuffer_data + ( screen_size_x * ( j / 8 ) + i );
            *p_fb &= ~( 1 << ( j % 8 ) );
        }
    }
#elif defined( CONFIG_FB_UC1698 ) || defined( CONFIG_FB_ST7586 )
    for ( i = 0; i < height; i++ )
    {
        p_fb = framebuffer_data + ( ( ( ( y + i ) * screen_size_x ) + x ) >> shift_bpp );
        memset( p_fb, 0, width / 2 );
    }
#else
    #error Controller not supported
#endif
}

//=============================================================================
static int
y_location(
    int location
)
//=============================================================================
{
    int y;

    switch ( location )
    {
        case LOCATION_TOP:
#if defined( CONFIG_HW_MODEL_GXP1400 ) || defined( CONFIG_HW_MODEL_GXP1450 ) || defined(CONFIG_HW_MODEL_GXP1150)
            y = 0;
#else
            y = viewable_y / 4 - 8; /* top third */
#endif
            break;
        case LOCATION_MID:
            y = viewable_y / 2 - 8;
#if defined( CONFIG_HW_MODEL_GXP1450 )
            y -= 8;
#elif defined( CONFIG_HW_MODEL_GXP1400 ) || defined(CONFIG_HW_MODEL_GXP1150)
            y -= 0;
#endif
            break;
        case LOCATION_BOT:
            y = 3 * ( viewable_y / 4 ) - 8; /* bottom third */
#if defined( CONFIG_HW_MODEL_GXP1450 )
            y -= 8;
#elif defined( CONFIG_HW_MODEL_GXP1400 ) || defined(CONFIG_HW_MODEL_GXP1150)
            y = viewable_y - 16;
#endif
            break;
        case LOCATION_TRAIL:
#if defined( CONFIG_HW_MODEL_GXP1400 ) || defined(CONFIG_HW_MODEL_GXP1150)
            y = viewable_y - 12;
#else
            y = viewable_y - 16;
#endif
            break;
        default:
            y = 0;
            break;
    }

    return y;
}

//=============================================================================
static unsigned int
decode_utf8(
    unsigned char * buf,
    int bytes
)
//=============================================================================
{
    switch ( bytes )
    {
        case 1:
            return (unsigned int)( buf[0] & ~0x80 );
        case 2:
            return (unsigned int)( ( ( buf[0] & ~0xE0 ) << 6 ) | ( buf[1] & ~0xC0 ) );
        case 3:
            return (unsigned int)( ( ( buf[0] & ~0xF0 ) << 12 ) | ( ( buf[1] & ~0xC0 ) << 6 ) | ( buf[2] & ~0xC0 ) );
        case 4:
            return (unsigned int)( ( ( buf[0] & ~0xF1 ) << 18 ) | ( ( buf[1] & ~0xC0 ) << 12 ) | ( ( buf[2] & ~0xC0 ) <<6 ) | ( buf[3] & ~0xC0 ) );
    }
    return 0;
}

//=============================================================================
static unsigned int
getchar_utf8(
    unsigned char * str,
    int * off
)
//=============================================================================
{
    unsigned char buf[4];

    buf[0] = str[*off]; *off = *off + 1;

    if ( ( buf[0] & 0x80 ) == 0 )
    {   /* 8-bit char */
        return decode_utf8( buf, 1 );
    }
    else if ( ( buf[0] & 0xE0 ) == 0xC0 )
    {   /* 16-bit char */
        buf[1] = str[*off]; *off = *off + 1;
        if ( ( buf[1] & 0xC0 ) != 0x80 )
        {
            goto parse_error;
        }
        return decode_utf8( buf, 2 );
    }
    else if ( ( buf[0] & 0xF0 ) == 0xE0 )
    {   /* 24-bit char */
        buf[1] = str[*off]; *off = *off + 1;
        buf[2] = str[*off]; *off = *off + 1;
        if ( ( ( buf[1] & 0xC0 ) != 0x80 ) || ( ( buf[2] & 0xC0 ) != 0x80 ) )
        {
            goto parse_error;
        }
        return decode_utf8( buf, 3 );
    }
    else if ( ( buf[0] & 0xF8 ) == 0xF0 )
    {   /* 32-bit char */
        buf[1] = str[*off]; *off = *off + 1;
        buf[2] = str[*off]; *off = *off + 1;
        buf[3] = str[*off]; *off = *off + 1;
        if ( ( ( buf[1] & 0xC0 ) != 0x80 ) || ( ( buf[2] & 0xC0 ) != 0x80 ) || ( ( buf[3] & 0xC0 ) != 0x80 ) )
        {
            goto parse_error;
        }
        return decode_utf8( buf, 4 );
    }

parse_error:
    printk("Parse Error\n");
    return 0;
}
EXPORT_SYMBOL(kgui_progress);
EXPORT_SYMBOL(kgui_cancel_progress);
EXPORT_SYMBOL(kgui_init);
EXPORT_SYMBOL(kgui_string);
EXPORT_SYMBOL(kgui_throbber);
EXPORT_SYMBOL(kgui_cancel_throbber);
EXPORT_SYMBOL(kgui_logo);
EXPORT_SYMBOL(kgui_enable_progress);



