#ifndef __OSDM_DMW96_H
#define __OSDM_DMW96_H


#include <linux/fb.h>

#include <video/dmw96osdm_common.h>
#include "dmw96osdm_regs.h"

#define OSDM_BASE 0x06a00000
#define THE_APB_FPGA_BASE			0x80000000
#define VBUS_OSDM_BASE           ((THE_APB_FPGA_BASE) + OSDM_BASE) //OSDM address

#define _IOW32( p, d )				( *((volatile unsigned int*)(p))	= (d) ) 
#define _IOR32( p )					( *((volatile unsigned int*)(p)) )

/* Please remove after develop */
#ifndef __KERNEL__
	#define CONFIG_FB_DMW96_OSDM_DEBUG
#endif

#ifdef __KERNEL__
    #define IOW32_OSDM( off, val )		writel(  (val) , osdm_regs + (off)  )
	#define IOR32_OSDM( off )			readl(osdm_regs + (off))

	//#define IOW32_OSDM( off, val )		printk(KERN_ERR "IOW32_OSDM(%d) off=0x%x val=0x%x\n",__LINE__,(OSDM_BASE+(off)),(val))
	//#define IOR32_OSDM( off )			printk(KERN_ERR "IOR32_OSDM(%d) off=0x%x\n",__LINE__,(OSDM_BASE+(off)))
	
#endif 
#ifdef __C_MODEL__
	#define IOW32_OSDM( off, val )			apb_write( (off) , (val) )
	#define IOR32_OSDM( off )				apb_read( (off) )
#endif


#ifdef CONFIG_FB_DMW96_OSDM_DEBUG
#	ifdef __KERNEL__
#		define PDEBUG(fmt, args...) printk( KERN_ERR "DW_OSDM: %s(%d) " fmt, __func__, __LINE__,  ## args)
#	else
#		define PDEBUG(fmt, args...) printf( "DW_OSDM: %s(%d) " fmt, __func__, __LINE__,  ## args)
#	endif
#	define PDEBUG_START PDEBUG(">>>>>>>>>>>>>>>>>>>> Start >>>>>>>>>>>>>>>>>>>>>>\n");
#	define PDEBUG_END   PDEBUG("<<<<<<<<<<<<<<<<<<<< End   <<<<<<<<<<<<<<<<<<<<<<\n");
#else
#		define PDEBUG(fmt, args...) do {} while (0)
#		define PDEBUG_START  do {} while (0);
#		define PDEBUG_END  do {} while (0);
#endif

#define SUCCEEDED(res) (((res) == SUCCESS) ? 1: 0) 
#define FAILED(res) (((res) != SUCCESS) ? 1: 0) 

/*************************************************************************
	Common Main / Sub Video
**************************************************************************/ 
#define PLANEn_CONFIG	0
#define PLANEn_POS		1
#define PLANEn_DIM		2

/*************************************************************************
	Main / Sub Video
**************************************************************************/ 
#define VIDEOn_BCSH		3
#define VIDEOn_TPOS		4
#define VIDEOn_TDIM		5
#define VIDEOn_TPIXEL	6
#define VIDEOn_ALCK		7
#define VIDEOn_YUVLIM	8

/*************************************************************************
	Main / Sub OSD
**************************************************************************/ 
#define	OSDn_TPOS    3
#define	OSDn_TDIM    4
#define	OSDn_TPIXEL  5
#define	OSDn_ALCK    6

/*************************************************************************
	DMA channels
**************************************************************************/ 
#define	DMAn_CONFIG		0
#define	DMAn_BADDR0		1
#define	DMAn_BADDR1		2
#define	DMAn_STRIDE		3
#define	DMAn_BSIZE 		4
#define	DMAn_BCOUNT		5
#define	DMAn_TPOS  		6
#define	DMAn_TDIM  	 	7

#define SUCCESS 0
#define FAIL -1

#define PLANE_ORG_SEMI_PLANAR 0
#define PLANE_ORG_PLANAR 1
#define PLANE_ORG_PACKED 2

#define OSD_LUT_SIZE 	256

/////////////////////////////////////////////////////////////////////////
// 
// 
// 						<--------xres ------->
// x_start / y_start-->	********************* 	^
// 						*********************	|
// 						*********************	|
// 						.....				   yres
// 						*********************	|
// 						*********************	|
// 			            *********************	^
// 	
/////////////////////////////////////////////////////////////////////////


	
/**************************************************************************************
Get OSDM plane format according to:

In case of quering of Video configuration
-----------------------------------------
	YUV420 (MPEG2) - 		0
	YUV420 (MPEG1/JPEG) -	1
	YUV422 -				2
	YUV444 - 				3
	16bpp 565 - 			4
	16bpp 4444 -			5
	32bpp 8888 -			6

In case of quering of OSD configuration
---------------------------------------
	1bpp (palette)-		0
	2bpp (palette) -	1
	4bpp (palette) -	2
	8bpp (palette) -	3
	16bpp 565 -			4
	16bpp 4444 - 		5
	32bpp 8888 - 		6

In case of display out
----------------------
	24bpp 888 -			0
	16bpp 565 - 		1
	YUV422 - 			3 		
****************************************************************************************/
#define OSDM_PLANE_FORMAT(x) (((unsigned int)(x) & 0x000000f0) >> 4)	


/**************************************************************************************
	Video plane organization as follow:

	Semi Planar -	0
	Planar -		1
	Packed -		2
**************************************************************************************/
#define OSDM_PLANE_ORG(x) (((unsigned int)(x) & 0x00000f00) >> 8)


/**************************************************************************************
 Video or OSDM packing mode as follow:

In case of video 422:
---------------------
	YUV422 Y1VY0U - 0
	YUV422 Y1UY0V - 1
	YUV422 VY1UY0 - 2 
	YUV422 UY1VY0 - 3
	YUV422 Y1Y0VU - 4
	YUV422 Y1Y0UV - 5
	YUV422 VUY1Y0 - 6
	YUV422 UVY1Y0 - 7

In case of video Semi planar:
-----------------------------
	YUV4xx_V1_U1_V0_U0 - 0
	YUV4xx_U1_V1_U0_V0 - 1

In case of OSD / Video RGBA16 or RGBA32:
----------------------------------------
	ARGB - 0
	ARBG - 1
	AGRB - 2
	AGBR - 3
	ABRG - 4
	ABGR - 5
	RGBA - 8
	RBGA - 9
	GRBA - a
	GBRA - b
	BRGA - c
	BGRA - d

In case of Display output
-------------------------
	RGB - 0
	BGR - 1

**************************************************************************************/
#define OSDM_PLANE_PKMODE(x) (((unsigned int)(x) & 0x0000f000) >> 12)


#define IS_VALID_PALETTE_FORMAT(x) (( ( (x) == OSDM_1_BPP_PALETTE ) || ( (x) == OSDM_2_BPP_PALETTE ) || ((x) == OSDM_4_BPP_PALETTE ) || ((x) == OSDM_8_BPP_PALETTE ) ) ? 1 : 0 )

#define IS_VALID_RGB_FORMAT(x) (( \
((x) == OSDM_RGB32_8888_ARGB ) || ((x) == OSDM_RGB32_8888_ARBG ) || ((x) == OSDM_RGB32_8888_AGRB ) || ((x) == OSDM_RGB32_8888_AGBR ) || ((x) == OSDM_RGB32_8888_ABRG ) || ((x) == OSDM_RGB32_8888_ABGR ) ||	\
((x) == OSDM_RGB32_8888_RGBA ) || ((x) == OSDM_RGB32_8888_RBGA ) || ((x) == OSDM_RGB32_8888_GRBA ) || ((x) == OSDM_RGB32_8888_GBRA ) || ((x) == OSDM_RGB32_8888_BRGA ) || ((x) == OSDM_RGB32_8888_BGRA ) ||	\
((x) == OSDM_RGB16_4444_ARGB ) || ((x) == OSDM_RGB16_4444_ARBG ) || ((x) == OSDM_RGB16_4444_AGRB ) || ((x) == OSDM_RGB16_4444_AGBR ) || ((x) == OSDM_RGB16_4444_ABRG ) || ((x) == OSDM_RGB16_4444_ABGR ) ||	\
((x) == OSDM_RGB16_4444_RGBA ) || ((x) == OSDM_RGB16_4444_RBGA ) || ((x) == OSDM_RGB16_4444_GRBA ) || ((x) == OSDM_RGB16_4444_GBRA ) || ((x) == OSDM_RGB16_4444_BRGA ) || ((x) == OSDM_RGB16_4444_BGRA ) ||	\
((x) == OSDM_RGB16_565_RGB ) || ((x) == OSDM_RGB16_565_BGR ) ) ? 1 : 0 )



#define IS_OSD_VALID_CONFIG(x)  (( \
((x) == OSDM_1_BPP_PALETTE) || ((x) == OSDM_2_BPP_PALETTE) || ((x) == OSDM_4_BPP_PALETTE) || ((x) == OSDM_8_BPP_PALETTE) || IS_VALID_RGB_FORMAT(x) ) ? 1 : 0 )

#define IS_VIDEO_VALID_CONFIG(x) (( \
((x) == OSDM_YUV420_MPEG2_PLANAR) || ((x) == OSDM_YUV420_MPEG2_SEMI_PLANAR_U1_V1_U0_V0)  || ((x) == OSDM_YUV420_MPEG2_SEMI_PLANAR_U1_V1_U0_V0) || ((x) == OSDM_YUV420_MPEG1_JPEG_PLANAR) || ((x) == OSDM_YUV420_MPEG1_JPEG_SEMI_PLANAR_V1_U1_V0_U0)  || ((x) == OSDM_YUV420_MPEG1_JPEG_SEMI_PLANAR_U1_V1_U0_V0) || \
IS_VIDEO_422(x) || IS_VIDEO_420(x) || IS_VIDEO_444(x) || IS_VALID_RGB_FORMAT(x) ) ? 1 : 0)


#define IS_DISPLAY_VALID_CONFIG(x) ((  \
((x) == OSDM_DISPLAY_RGB24_888_RGB) || ((x) == OSDM_DISPLAY_RGB24_888_RBG) || ((x) == OSDM_DISPLAY_RGB24_888_GRB) || \
((x) == OSDM_DISPLAY_RGB24_888_GBR) || ((x) == OSDM_DISPLAY_RGB24_888_BRG) || ((x) == OSDM_DISPLAY_RGB24_888_BGR) || \
((x) == OSDM_DISPLAY_RGB16_565_RGB) || ((x) == OSDM_DISPLAY_RGB16_565_BGR) ||	\
((x) == OSDM_DISPLAY_YUV422_Y1_V_Y0_U) || ((x) == OSDM_DISPLAY_YUV422_Y1_U_Y0_V) || ((x) == OSDM_DISPLAY_YUV422_V_Y1_U_Y0) || \
((x) == OSDM_DISPLAY_YUV422_U_Y1_V_Y0) || ((x) == OSDM_DISPLAY_YUV422_Y1_Y0_V_U) || ((x) == OSDM_DISPLAY_YUV422_Y1_Y0_U_V) || \
((x) == OSDM_DISPLAY_YUV422_V_U_Y1_Y0) || ((x) == OSDM_DISPLAY_YUV422_U_V_Y1_Y0) ) ? 1 : 0 )


#define IS_PLANE_OSD(x) ((((x) == MAIN_OSD_PLANE) || ((x) == SUB_OSD_PLANE_1) || ((x) == SUB_OSD_PLANE_2)) ? 1 : 0)

#define IS_PLANE_VIDEO(x) ((((x) == MAIN_VIDEO_PLANE) || ((x) == SUB_VIDEO_PLANE)) ? 1 : 0)

#define IS_PLANE_TYPE_VALID(x) ((((x) == MAIN_OSD_PLANE) || ((x) == SUB_OSD_PLANE_1) || ((x) == SUB_OSD_PLANE_2) \
								 || ((x) == MAIN_VIDEO_PLANE) || ((x) == SUB_VIDEO_PLANE)) ? 1 : 0)

void check_rotate_and_swap(unsigned int xres , unsigned int yres , unsigned int* _xres , unsigned int* _yres , unsigned int degree);

int dmw96osdm_get_regs(struct osdm_regs* pregs);

unsigned int dmw96osdm_osdm_get_bpp(unsigned int config);

void dmw96osdm_display_dma_enb_set(const unsigned int enb);
int dmw96osdm_display_enb_set(unsigned int enb); 
int dmw96osdm_display_set(const struct fb_info* info , const unsigned int config);
int dmw96osdm_display_get(struct fb_info *display);
int dmw96osdm_display_background_set(const osdm_rgb888 background);
int dmw96osdm_display_background_get(osdm_rgb888* background);
int dmw96osdm_display_background_enable(unsigned int is_enb);
int dmw96osdm_display_dithering_set(unsigned int dithering);
unsigned int dmw96osdm_is_display_finished(void);
unsigned int dmw96osdm_is_mixer_finished(void);
void dmw96osdm_display_address_get(struct fb_info* info);
void dmw96osdm_display_dim_get(struct fb_info* info);
void dmw96osdm_display_address_set(const struct fb_info* info);
int dmw96osdm_plane_address_set(unsigned int xres, unsigned int yres, unsigned int address, const unsigned int config, const unsigned int osdm_type);

int dmw96osdm_pause_set(unsigned int enb);
int dmw96osdm_pause_get(unsigned int* enb);
int dmw96osdm_loop_set(unsigned int enb);
int dmw96osdm_loop_get(unsigned int* enb);

int dmw96osdm_interrupt_handle(void);
void dmw96osdm_interrupt_cause(unsigned int* cause);
void dmw96osdm_interrupt_clear(unsigned int cause);

int dmw96osdm_plane_dma_enb_set(const unsigned int enb, const unsigned int config, const unsigned int osdm_type);
int dmw96osdm_plane_dma_enb_reset(const unsigned int enb, const unsigned int osdm_type);
void dmw96osdm_plane_enb_set(unsigned int enb , const unsigned int osdm_type);
int dmw96osdm_plane_set(struct fb_info *info, struct osdm_position* pos ,const unsigned int config ,const unsigned int osdm_type);
int dmw96osdm_plane_dma_byteorder_set(const unsigned int byte_order, const unsigned int config, const unsigned int osdm_type);
int dmw96osdm_plane_dma_channel_byteorder_set(const unsigned int byte_order, unsigned int channel, const unsigned int osdm_type);
int dmw96osdm_osd_palette_set(const struct fb_cmap* osd_pal, unsigned int lut_base , unsigned int osdm_type);

int dmw96osdm_plane_chroma_enb(const int is_enb, const unsigned int osdm_type);
int dmw96osdm_plane_chromakey_set(const osdm_rgb888 chroma , unsigned int osdm_type);
int dmw96osdm_plane_alpha_set(const unsigned char alpha , unsigned int osdm_type);

int dmw96osdm_plane_per_pixel_alpha_enb(const int is_enb, const unsigned int osdm_type);
int dmw96osdm_plane_masking_set(const struct osdm_mask mask, const unsigned int osdm_type);

int  dmw96osdm_color_video_control_set(const struct osdm_video_color_control* video_color_ctl, unsigned int osdm_type);

int dmw96osdm_plane_transparent_block_pos_set(const unsigned int config, const struct osdm_position* pos, const struct fb_info *plane_info, unsigned int osdm_type);
int dmw96osdm_plane_transparent_block_dim_set(const unsigned int config, const struct fb_var_screeninfo *vinfo, const struct fb_info *plane_info, unsigned int osdm_type);
int dmw96osdm_plane_transparent_pixel_set(const osdm_abgr8888 abgr8888, unsigned int osdm_type);

int dmw96osdm_plane_transparent_block_pos_test(const unsigned int config, const struct osdm_position* pos, const struct fb_info *plane_info, unsigned int osdm_type);
int dmw96osdm_plane_transparent_block_dim_test(const unsigned int config, const struct fb_var_screeninfo *vinfo, const struct fb_info *plane_info, unsigned int osdm_type);	
int dmw96osdm_plane_chroma_enb_test(const int is_enb, const unsigned int osdm_type);	
int dmw96osdm_plane_masking_test(const struct osdm_mask mask, const unsigned int osdm_type);
int dmw96osdm_plane_test(struct fb_info *info, struct osdm_position* pos ,const unsigned int config ,const unsigned int osdm_type);
void dmw96osdm_reset_all_plane_settings(void);

#endif // __OSDM_DIRVER__
