/*
 * kernel mode mmc rw
 *
 * Copyright 2012, GrandStream Corporation
 * All Rights Reserved.
 * 
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
 *
 */

#ifndef	__PROVISION_H_
#define __PROVISION_H_

#include <linux/types.h>

typedef struct _image_header {
    unsigned int Signature;
    unsigned int Version;
    unsigned int Size;
    unsigned int SizeUsed;

    unsigned short Id;
    unsigned short Checksum;
    unsigned short Year;
    unsigned short MonthDay;
    unsigned short HourMinute;
    unsigned short ModelKey;

    unsigned short FwVerMask;
    unsigned short reserved[1];
} ImageHeader, *pImageHeader;

#define PROV_COUNT                10
typedef struct
{
	const  char *name;
	unsigned long start[4];
	unsigned int id;
	const char *devfname;
}prov_t;

extern prov_t provs[PROV_COUNT];

#define IMGHDR_BOOT_STR		"boot"
#define IMGHDR_RCVR_STR		"rcvr"
#define IMGHDR_CORE_STR		"core"
#define IMGHDR_CORE_STR2	"Core"
#define IMGHDR_BASE_STR		"base"
#define IMGHDR_BASE_STR2	"Base"
#define IMGHDR_PROG_STR		"prog"
#define IMGHDR_PROG_STR2	"Prog"
#define IMGHDR_LANG_STR		"lang"
#define IMGHDR_LANG_STR2	"Lang"

#define IMGHDR_BOOT_ID	25
#define IMGHDR_RCVR_ID	26
#define IMGHDR_CORE_ID	27
#define IMGHDR_BASE_ID	28
#define IMGHDR_PROG_ID	29
#define IMGHDR_LANG_ID	30

#endif

