/*
 * drivers/staging/gs/provision.c
 *
 * Driver for the provison.
 *
 * Copyright (C) 2012, 2013 GrandStream Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/delay.h>
#include <linux/rslib.h>
#include <linux/moduleparam.h>
#include <linux/platform_device.h>
#include <linux/dma-mapping.h>
#include <linux/types.h>
#include <linux/clk.h>
#include <linux/interrupt.h>
#include <linux/semaphore.h>
#include <linux/io.h>
#include <linux/slab.h>
#include <linux/ccu.h>
#include <linux/completion.h>
#include <linux/uaccess.h>
#include <linux/proc_fs.h>
#include <linux/vmalloc.h>
#include <mach/gpio.h>
#include "gs_misc.h"
#include <mach/gxp22xx.h>

extern void gpio_dump(void);
extern struct gsboard_gpio * __init gs_get_board_gpio(int *count);
extern void gsgpio_init_callback_for_stmmac ( struct gsboard_gpio *bd_gpio, int count );

struct gsboard_gpio *board_gpio_gs = NULL;
static int board_gpio_gs_count = 0;

static int
gxe_gpio_init( struct gsboard_gpio *p_gpio )
{
    unsigned int gpio_pin = (unsigned int)p_gpio->gpio_pin;

    if (gpio_request(gpio_pin, "gs_board_gpio") < 0) 
    {
        printk("gs_board_gpio_init, request gpio failed %d\n", gpio_pin);
        return -1;
    }

    /* set gpio direction */
    if (p_gpio->gpio_dir == 0) /* input */
        gpio_direction_input(gpio_pin);
    else
    {
        gpio_direction_output(gpio_pin, p_gpio->init_val);
    }

    return 0;
}

static int
gxe_board_gpio_proc_read (
    char            *page,
    char            **start,
    off_t           off,
    int             count,
    int             *eof,
    void            *data)
{
    char        *p = page;
    int         len = 0;
    int         index;
    int         pin_val = 0;

    index = (int)data;

    if (board_gpio_gs[index].gpio_pin == NULL )
    {
        gpio_dump();
        return len;
    }	

    if (board_gpio_gs[index].skip_init)
    {
	gxe_gpio_init(&board_gpio_gs[index]);
        board_gpio_gs[index].skip_init = 0;
    }

    pin_val = gpio_get_value(board_gpio_gs[index].gpio_pin);
    p += sprintf(p, "%x\n", pin_val? 1 : 0);

    len = (p - page);
    if (len <= off+count) *eof = 1;
    *start = page + off;
    len -= off;
    if (len>count) len = count;
    if (len<0) len = 0;

    return (len);
}

static int
gxe_board_gpio_proc_write (
        struct file     *file,
        const char      *buffer,
        unsigned long   count,
        void            *data)
{
    char        state_string[12] = {'\0'};
    int         index;
    unsigned long newValue = 0;
    //unsigned long newPWM = 0;

    if ((count > sizeof(state_string) - 1))
        return (-EINVAL);

    if (copy_from_user(state_string, buffer, count))
        return (-EFAULT);

    state_string[count] = '\0';

    index = (int)data;

    if (state_string[0] == '1')
    {
        newValue = 1;
        board_gpio_gs[index].pwm_value = 0;
    }
    else
    {
        newValue = 0;
        board_gpio_gs[index].pwm_value = 0;
    }

    if (board_gpio_gs[index].skip_init)
    {
	gxe_gpio_init(&board_gpio_gs[index]);
        board_gpio_gs[index].skip_init = 0;
    }


#if 0
    if (newValue && (state_string[1] == '.') && (strlen(state_string) > 2))
    {
        newPWM = simple_strtoul(&state_string[2], NULL, 16) & 0xffffffff;
        if (newPWM)
            board_gpio_gs[index].pwm_value = newPWM;
    }

    if (board_gpio_gs[index].pwm_value)
        control_soft_pwm(board_gpio_gs[index].gpio_pin, 1, board_gpio_gs[index].pwm_value);
    else
    {
        control_soft_pwm(board_gpio_gs[index].gpio_pin, 0, board_gpio_gs[index].pwm_value);
        gpio_set_value(board_gpio_gs[index].gpio_pin, newValue);
    }
#else
    gpio_set_value(board_gpio_gs[index].gpio_pin, newValue);
#endif

    return (count);
}


static int
gxe_board_gpio_init( struct gsboard_gpio *p_gpio )
{
    unsigned int gpio_pin = (unsigned int)p_gpio->gpio_pin;

    if (p_gpio->skip_init)
        return 0;

#if 1
    if (gpio_request(gpio_pin, "gs_board_gpio") < 0) 
    {
        printk("gs_board_gpio_init, request gpio failed %d\n", gpio_pin);
        return -1;
    }
#endif

    /* set pin mux */

    /* set gpio direction */
    if (p_gpio->gpio_dir == 0) /* input */
        gpio_direction_input(gpio_pin);
    else
    {
#if 0
        if (p_gpio->pwm_value)
        {
            control_soft_pwm(gpio_pin, p_gpio->init_val, p_gpio->pwm_value);
        }
        else
#endif
            gpio_direction_output(gpio_pin, p_gpio->init_val);
    }

    return 0;
}

static int gpio_controll_install_proc_entry (void)
{
	struct proc_dir_entry *gsboard_root_dir;
	struct proc_dir_entry   *ent;
	int ii;

	gsboard_root_dir = proc_mkdir( "gsboard", NULL);

	if (gsboard_root_dir != NULL)
	{
		printk("Initialize grandstream board gpios\n");
		for (ii = 0; ii < board_gpio_gs_count; ii ++)
		{
			if (gxe_board_gpio_init( &board_gpio_gs[ii] ) == 0)
			{
				ent = create_proc_entry(board_gpio_gs[ii].gpio_name, S_IFREG|S_IRUGO, gsboard_root_dir);
				if (!ent) {
					printk("create proc entry %s failed\n", board_gpio_gs[ii].gpio_name);
					continue;
				}
				ent->read_proc  = gxe_board_gpio_proc_read;
				if (board_gpio_gs[ii].gpio_pin != NULL )
					ent->write_proc = gxe_board_gpio_proc_write;
				ent->data       = (void*)ii;
			}
		}
	}
	return 0;
}


static int __init
gpio_control_init(void)
{
        board_gpio_gs = gs_get_board_gpio(&board_gpio_gs_count);

	gpio_controll_install_proc_entry();
    gsgpio_init_callback_for_stmmac(board_gpio_gs, board_gpio_gs_count);
	return 0;
}

static void __exit
gpio_control_cleanup(void)
{
	remove_proc_entry("gsboard", NULL);
	return;
}

module_init(gpio_control_init);
module_exit(gpio_control_cleanup);

MODULE_AUTHOR("pradev@grandstream.com");
MODULE_DESCRIPTION("GXE51XX GPIO proc fs control driver");
MODULE_LICENSE("GPL");
