#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/spi/spi.h>
#include <linux/spi/spi_dmw96.h>
#include <mach/gpio.h>
#include <sound/si3050.h>
#include <linux/gpio_keys.h>
#include <linux/input.h>
#include "gpio-setup.h"
#include "gs_misc.h"

static __initdata struct gpio_setup_t gpio_setup_default[] = {
	GPIO_SETUP(C, 0,  GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED0 */
	GPIO_SETUP(C, 1,  GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED1 */
	GPIO_SETUP(C, 2,  GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED2 */
	GPIO_SETUP(C, 3,  GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED3 */
	GPIO_SETUP(C, 4,  GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED4 */
	GPIO_SETUP(C, 5,  GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED5 */
	GPIO_SETUP(C, 6,  GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED6 */
	GPIO_SETUP(C, 7,  GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED7 */
	GPIO_SETUP(C, 8,  GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED8 */
	GPIO_SETUP(C, 9,  GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED9 */
	GPIO_SETUP(C, 10, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED10 */
	GPIO_SETUP(C, 11, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED11 */
	GPIO_SETUP(C, 12, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED12 */
	GPIO_SETUP(C, 13, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED13 */
	GPIO_SETUP(C, 14, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED14 */
	GPIO_SETUP(C, 15, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXO_LED15 */
	
	GPIO_SETUP(C, 17, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXS_LED1 */
	GPIO_SETUP(C, 18, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* FXS_LED0 */
	
	GPIO_SETUP(C, 20, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* READY_LEDR */
	GPIO_SETUP(C, 21, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* READY_LEDG */
#ifdef DEBUG_GPIOS
	GPIO_SETUP(F, 2,  GPIO_OUT_HIGH, GPIO_PULL_DISABLE ), /* CARD_RSV0 */
	GPIO_SETUP(F, 3,  GPIO_OUT_HIGH, GPIO_PULL_DISABLE ), /* CARD_RSV1 */
	GPIO_SETUP(F, 4,  GPIO_OUT_HIGH, GPIO_PULL_DISABLE ), /* CARD_RSV2 */
#else
	GPIO_SETUP(F, 2,  GPIO_IN,       GPIO_PULL_DOWN    ), /* CARD_RSV0 */
	GPIO_SETUP(F, 3,  GPIO_IN,       GPIO_PULL_DOWN    ), /* CARD_RSV1 */
	GPIO_SETUP(F, 4,  GPIO_IN,       GPIO_PULL_DOWN    ), /* CARD_RSV2 */
#endif
	GPIO_SETUP(F, 5,  GPIO_IN,       GPIO_PULL_DOWN    ), /* SD_WP */
	GPIO_SETUP(F, 6,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* /SD_CD */
	GPIO_SETUP(F, 7,  GPIO_IN,       GPIO_PULL_UP      ), /* /USB1_FAULT */
	GPIO_SETUP(G, 15, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* RL2_CTRL */
	GPIO_SETUP(G, 16, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* RL1_CTRL */
	GPIO_SETUP(G, 17, GPIO_OUT_LOW,  GPIO_PULL_DISABLE ), /* CD_LCD */
	GPIO_SETUP(G, 18, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* SPI2_/CS_FOX5-8 */
	GPIO_SETUP(G, 19, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* SPI2_/CS_FOX9-12 */
	GPIO_SETUP(G, 20, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* SPI2_/CS_FOX13-16 */
	GPIO_SETUP(G, 10, GPIO_OUT_LOW,  GPIO_PULL_DISABLE ), /* /USB1_EN */
	GPIO_SETUP(A, 30, GPIO_OUT_HIGH,  GPIO_PULL_DISABLE ), /* SPI2_/CS_FOX1-4 */
	
	GPIO_SETUP(F, 16, GPIO_OUT_HIGH, GPIO_PULL_DISABLE ), /* /RST_SVIPA */
	GPIO_SETUP(F, 17, GPIO_OUT_HIGH, GPIO_PULL_DISABLE ), /* /RST_SVIPB */
	GPIO_SETUP(F, 18, GPIO_OUT_HIGH, GPIO_PULL_DISABLE ), /* /RST_FXS */
	GPIO_SETUP(F, 19, GPIO_OUT_HIGH, GPIO_PULL_DISABLE ), /* /RST_LCD */
	GPIO_SETUP(F, 21, GPIO_OUT_HIGH, GPIO_PULL_DISABLE ), /* /RST_FXO */
	GPIO_SETUP(F, 22, GPIO_IN, GPIO_PULL_DISABLE ), /* /ETH_INT */
	GPIO_SETUP(F, 23, GPIO_IN, GPIO_PULL_DISABLE ), /* /FXS_INT */
	GPIO_SETUP(F, 24, GPIO_IN, GPIO_PULL_DISABLE ), /* /FXO1-4_INT */
	GPIO_SETUP(F, 25, GPIO_IN, GPIO_PULL_DISABLE ), /* /SVIPA_INT */
	GPIO_SETUP(F, 26, GPIO_IN, GPIO_PULL_DISABLE ), /* /SVIPB_INT */
	GPIO_SETUP(F, 27, GPIO_IN, GPIO_PULL_DISABLE ), /* /RTC_INT */
	GPIO_SETUP(F, 28, GPIO_IN, GPIO_PULL_DISABLE ), /* /FXO5-8_INT */
	GPIO_SETUP(F, 29, GPIO_IN, GPIO_PULL_DISABLE ), /* /FXO9-12_INT */
	GPIO_SETUP(F, 31, GPIO_IN, GPIO_PULL_DISABLE ), /* /FXO13-16_INT */
	GPIO_SETUP(A, 26, GPIO_OUT_HIGH, GPIO_PULL_DISABLE ), /* SPI2_/CS_FXS */
	GPIO_SETUP(A, 31, GPIO_OUT_LOW, GPIO_PULL_DISABLE ), /* LED_CTRL */
};

static struct gsboard_gpio board_gpio[] = {
    {
        .gpio_name = "watchdog",
        .gpio_pin  = GPIO_PORTF(1),
        .gpio_dir  = 1,
        .skip_init = 1,
        .init_val  = 1,
        .pwm_value = 0
    },
#if 1
    {
        .gpio_name = "card_rsv0",
        .gpio_pin  = GPIO_PORTF(2),
        .gpio_dir  = 0,
        .skip_init = 0,
        .init_val  = 1,
        .pwm_value = 0
    },
    {
        .gpio_name = "card_rsv1",
        .gpio_pin  = GPIO_PORTF(3),
        .gpio_dir  = 0,
        .skip_init = 0,
        .init_val  = 1,
        .pwm_value = 0
    },
    {
        .gpio_name = "card_rsv2",
        .gpio_pin  = GPIO_PORTF(4),
        .gpio_dir  = 0,
        .skip_init = 0,
        .init_val  = 1,
        .pwm_value = 0
    },
#endif
    {
        .gpio_name = "svipA_reset",
        .gpio_pin  = GPIO_PORTF(16),
        .gpio_dir  = 1,
        .skip_init = 0,
        .init_val  = 1,
        .pwm_value = 0
    },
    {
        .gpio_name = "svipB_reset",
        .gpio_pin  = GPIO_PORTF(17),
        .gpio_dir  = 1,
        .skip_init = 0,
        .init_val  = 1,
        .pwm_value = 0
    },

    {
        .gpio_name = "relay2",
        .gpio_pin  = GPIO_PORTG(15),
        .gpio_dir  = 1,
        .skip_init = 0,
        .init_val  = 1,
        .pwm_value = 0
    },
    {
        .gpio_name = "relay1",
        .gpio_pin  = GPIO_PORTG(16),
        .gpio_dir  = 1,
        .skip_init = 0,
        .init_val  = 1,
        .pwm_value = 0
    },
    {
        .gpio_name = "lcd_backlight",
        .gpio_pin  = GPIO_PORTA(31),
        .gpio_dir  = 1,
        .skip_init = 0,
        .init_val  = 1,
        .pwm_value = 0
    },
    {
        .gpio_name = "nUSB1_enable",
        .gpio_pin  = GPIO_PORTG(10),
        .gpio_dir  = 1,
        .skip_init = 0,
        .init_val  = 0,
        .pwm_value = 0
    },


    /* FXO LEDs */
    { "fxo_led0",  GPIO_PORTC(0), 1, 0, 1, 0 },
    { "fxo_led1",  GPIO_PORTC(1), 1, 0, 1, 0 },
    { "fxo_led2",  GPIO_PORTC(2), 1, 0, 1, 0 },
    { "fxo_led3",  GPIO_PORTC(3), 1, 0, 1, 0 },
    { "fxo_led4",  GPIO_PORTC(4), 1, 0, 1, 0 },
    { "fxo_led5",  GPIO_PORTC(5), 1, 0, 1, 0 },
    { "fxo_led6",  GPIO_PORTC(6), 1, 0, 1, 0 },
    { "fxo_led7",  GPIO_PORTC(7), 1, 0, 1, 0 },
    { "fxo_led8",  GPIO_PORTC(8), 1, 0, 1, 0 },
    { "fxo_led9",  GPIO_PORTC(9), 1, 0, 1, 0 },
    { "fxo_led10", GPIO_PORTC(10), 1, 0, 1, 0 },
    { "fxo_led11", GPIO_PORTC(11), 1, 0, 1, 0 },
    { "fxo_led12", GPIO_PORTC(12), 1, 0, 1, 0 },
    { "fxo_led13", GPIO_PORTC(13), 1, 0, 1, 0 },
    { "fxo_led14", GPIO_PORTC(14), 1, 0, 1, 0 },
    { "fxo_led15", GPIO_PORTC(15), 1, 0, 1, 0 },

    /* FXS LEDs*/
    { "fxs_led0", GPIO_PORTC(18), 1, 0, 1, 0 },
    { "fxs_led1", GPIO_PORTC(17), 1, 0, 1, 0 },

    /* Control LEDs */
    { "led_ready_r", GPIO_PORTC(21), 1, 0, 1, 0 },
    { "led_ready_g", GPIO_PORTC(20), 1, 0, 1, 0 },

    /* Dummy GPIO dump*/
    { "gpio_dump", 0, 1, 0, 1, 0 },
};

/*
********************************************************
* platform devices
********************************************************
*/

static int si3050_leds0[] = {
	GPIO_PORTC(0),
	GPIO_PORTC(1),
	GPIO_PORTC(2),
	GPIO_PORTC(3),
};

static int si3050_leds1[] = {
	GPIO_PORTC(4),
	GPIO_PORTC(5),
	GPIO_PORTC(6),
	GPIO_PORTC(7),
};

static int si3050_leds2[] = {
	GPIO_PORTC(8),
	GPIO_PORTC(9),
	GPIO_PORTC(10),
	GPIO_PORTC(11),
};

static int si3050_leds3[] = {
	GPIO_PORTC(12),
	GPIO_PORTC(13),
	GPIO_PORTC(14),
	GPIO_PORTC(15),
};

static int si32260_leds[] = {
	GPIO_PORTC(18),
	GPIO_PORTC(17),
};

static struct si3050_platform_data si3050_pdata0 = {
	.reset 	= GPIO_PORTF(21),
	.chips	= 4,
	.led_count	= 4,
	.led_gpio	= si3050_leds0,
	.irqno		= DMW_IID_EXTERNAL_REQUEST_8,
};

static struct si3050_platform_data si3050_pdata1 = {
	.reset 	= 0x20121022,
	.chips	= 4,
	.led_count	= 4,
	.led_gpio	= si3050_leds1,
	.irqno		= DMW_IID_EXTERNAL_REQUEST_12,
};

static struct si3050_platform_data si3050_pdata2 = {
	.reset 	= 0x20121022,
	.chips	= 4,
	.led_count	= 4,
	.led_gpio	= si3050_leds2,
	.irqno		= DMW_IID_EXTERNAL_REQUEST_13,
};

static struct si3050_platform_data si3050_pdata3 = {
	.reset 	= 0x20121022,
	.chips	= 4,
	.led_count	= 4,
	.led_gpio	= si3050_leds3,
	.irqno		= DMW_IID_EXTERNAL_REQUEST_15,
};

static struct si3050_platform_data si32260_pdata = {
        .reset 	= GPIO_PORTF(18),
	.chips	= 1,
	.led_count	= 2,
	.led_gpio	= si32260_leds,
	.irqno		= DMW_IID_EXTERNAL_REQUEST_7,
};

static struct gs_lcd_platform_data lcd209B_pdata = { 
    .reset = GPIO_PORTF(19),
    .lcd_cd = GPIO_PORTG(17),
};

#define SPI_SPEED	( 5 * 1000 * 1000 )
static struct spi_board_info spi_devs[] = {
	{
		.modalias	= "dmw96_si3050_spi",
		.chip_select	= 0,
		.max_speed_hz	= SPI_SPEED,
		.bus_num	= 1,
		.platform_data	= &si3050_pdata0,
	},
	{
		.modalias	= "dmw96_si3050_spi",
		.chip_select	= 1,
		.max_speed_hz	= SPI_SPEED,
		.bus_num	= 1,
		.platform_data	= &si3050_pdata1,
	},
	{
		.modalias	= "dmw96_si3050_spi",
		.chip_select	= 2,
		.max_speed_hz	= SPI_SPEED,
		.bus_num	= 1,
		.platform_data	= &si3050_pdata2,
	},
	{
		.modalias	= "dmw96_si3050_spi",
		.chip_select	= 3,
		.max_speed_hz	= SPI_SPEED,
		.bus_num	= 1,
		.platform_data	= &si3050_pdata3,
	},
	{
		.modalias	= "dmw96_si3226x_spi",
		.chip_select	= 4,
		.max_speed_hz	= SPI_SPEED,
		.bus_num	= 1,
		.platform_data	= &si32260_pdata,
	},
    {  
        .modalias   = "uc1701fb",
        .chip_select = 0, 
        .irq = -1,
        .max_speed_hz   = SPI_SPEED,
        .bus_num    = 0,
        .platform_data  = &lcd209B_pdata,
    }, 
};

static void
spi2_set_cs(struct dmw96_spi_info *ds_info, unsigned int chip_select, int val, int pol)
{
	int cs = 0;
//printk("SPI CS called -- chip_select=%d val=%d pol=%d\n", chip_select, val, pol);
	switch (chip_select)
	{
		default:
		case 0:
			cs = GPIO_PORTA(30);
			break;
		case 1:
			cs = GPIO_PORTG(18);
			break;
		case 2:
			cs = GPIO_PORTG(19);
			break;
		case 3:
			cs = GPIO_PORTG(20);
			break;
		case 4:
			cs = GPIO_PORTA(26);
			break;
	}

	gpio_set_value(cs , !val);

//	gpio_set_value(GPIO_PORTG(19), !val);
	return;
}

static uint32_t spi2_get_cs_mask( unsigned int chip_select )
{
    switch ( chip_select )
    {
        case 0:
        default:
            return ( 1 << 30 );
        case 1:
            return ( 1 << 18 );
        case 2:
            return ( 1 << 19 );
        case 3:
            return ( 1 << 20 );
        case 4:
            return ( 1 << 26 );
    }
}

static char spi2_get_cs_bank( unsigned int chip_select )
{
    switch ( chip_select )
    {
        case 0:
        case 4:
            return 'A';
        default:
            return 'G';
    }
}

static struct dmw96_spi_info dmw96_spi2_info = {
	.bus_num    = 1,
	.set_cs     = spi2_set_cs,
    .get_cs_bank = spi2_get_cs_bank,
    .get_cs_mask = spi2_get_cs_mask
};

static struct resource dmw96_spi2_resources[] = {
	{
		.start  = DMW_SPI2_BASE,
		.end    = DMW_SPI2_BASE + 0x200 - 1,
		.flags  = IORESOURCE_MEM,
	},
	{
		.start  = DMW_IID_SPI2,
		.end    = DMW_IID_SPI2,
		.flags  = IORESOURCE_IRQ,
	},
	{
		.start  = 16, /* SPI2 RX */
		.end    = 16,
		.flags  = IORESOURCE_DMA,
	},
	{
		.start  = 17, /* SPI2 TX */
		.end    = 17,
		.flags  = IORESOURCE_DMA,
	},
};

static struct platform_device spi2_device = {
	.name = "dmw96-spi",
	.id = 1,
	.num_resources = ARRAY_SIZE(dmw96_spi2_resources),
	.resource = dmw96_spi2_resources,
	.dev = {
		.platform_data = &dmw96_spi2_info
	},
};

static struct gpio_keys_button gpio_buttons[] = {
	{
		.code = KEY_F1,
		.gpio = GPIO_PORTF(0),
		.active_low = 1,
		.desc = "/MR",
		.type = EV_KEY,
		.debounce_interval = 100,
	},
};

static struct gpio_keys_platform_data gpio_keys_pdata = {
	.buttons = gpio_buttons,
	.nbuttons = ARRAY_SIZE(gpio_buttons),
	.poll_interval = 50,
};

static struct platform_device gpio_keys_device = {
	.name = "gpio-keys-polled",
	.id = 1,
	.dev = {
		.platform_data = &gpio_keys_pdata,
	},
};

static struct platform_device *platform_devs[] __initdata = {
	&spi2_device,
	&gpio_keys_device,
};

int __init board_gxe512xV10A_init(const char *pn, unsigned int hwrev)
{
	/* Setup GPIOs */
	dmw_gpio_setup(gpio_setup_default, ARRAY_SIZE(gpio_setup_default));
	spi_register_board_info(spi_devs, ARRAY_SIZE(spi_devs));
	return platform_add_devices(platform_devs, ARRAY_SIZE(platform_devs));
}

void *__init gxe512xV10A_get_board_gpio(const char *pn, unsigned int hwrev, int *count)
{
	if(count) *count = ARRAY_SIZE(board_gpio);
	return board_gpio;
}
