#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/string.h>
#include "gs_misc.h"

static char pnstr[PNSTR_LEN+1] = HW_GXE5116_PNSTR;
static unsigned int hwrev = HW_REV_V14A;

extern void *gxe512xV10A_get_board_gpio(const char *pn, unsigned int hwrev, int *count);
extern void *gxe512xV11A_get_board_gpio(const char *pn, unsigned int hwrev, int *count);
extern void *gxe5124V11A_get_board_gpio(const char *pn, unsigned int hwrev, int *count);
extern int __init board_gxe512xV10A_init(const char *pn, unsigned int hwrev);
extern int __init board_gxe512xV11A_init(const char *pn, unsigned int hwrev);
extern int __init board_gxe5124V11A_init(const char *pn, unsigned int hwrev);

/* 
 * @2012-12-29 19:26 EP3
 * GXE5124 rename to GXE5116, GXE5121 rename to GXE5104
 * add GXE5108 GXE5102
 * @2012-12-30 09:52 all hardware version restart from V1.4A
 */
extern void *__init gxe5108_get_board_gpio(const char *pn, unsigned int hwrev, int *count);
extern int __init board_gxe5108_init(const char *pn, unsigned int hwrev);
extern void *__init gxe5102_get_board_gpio(const char *pn, unsigned int hwrev, int *count);
extern int __init board_gxe5102_init(const char *pn, unsigned int hwrev);

int gs_set_partno(const char *partno)
{
	memcpy(pnstr, partno, PNSTR_LEN);
	hwrev = HW_REV(partno[8], partno[9], partno[10]);
	printk("PN: %s V%.3s\n", pnstr, (const char *)&hwrev);
	return 0;
}

struct gsboard_gpio * __init gs_get_board_gpio(int *count)
{
	if(!compare_pn_str(pnstr, HW_GXE5116_PNSTR))
	{
		switch(hwrev)
		{
		case HW_REV_V10A:
			return gxe512xV10A_get_board_gpio(pnstr, hwrev, count);
		case HW_REV_V11A:
		case HW_REV_V14A:
		default:
			return gxe5124V11A_get_board_gpio(pnstr, hwrev, count);
		}
	}
	else if(!compare_pn_str(pnstr, HW_GXE5108_PNSTR))
	{
		switch(hwrev)
		{
		case HW_REV_V14A:
		default:
			return gxe5108_get_board_gpio(pnstr, hwrev, count);
		}	
	}
	else if(!compare_pn_str(pnstr, HW_GXE5104_PNSTR))
	{
		switch(hwrev)
		{
		case HW_REV_V11A:
		case HW_REV_V12A:
		case HW_REV_V14A:
		default:
			return gxe512xV11A_get_board_gpio(pnstr, hwrev, count);
		}	
	}
	else if(!compare_pn_str(pnstr, HW_GXE5102_PNSTR))
	{
		switch(hwrev)
		{
		case HW_REV_V14A:
		default:
			return gxe5102_get_board_gpio(pnstr, hwrev, count);
		}	
	}
	else
	{
		*count = 0;
		printk("Unsupport board gpio\n");
		return NULL;	
	}
}

int __init board_gxe512x_init(void)
{
	if(!compare_pn_str(pnstr, HW_GXE5116_PNSTR))
	{
		switch(hwrev)
		{
		case HW_REV_V10A:
			return board_gxe512xV10A_init(pnstr, hwrev);
		case HW_REV_V11A:
		case HW_REV_V14A:
		default:
			return board_gxe5124V11A_init(pnstr, hwrev);
		}
	}
	else if(!compare_pn_str(pnstr, HW_GXE5108_PNSTR))
	{
		switch(hwrev)
		{
		case HW_REV_V14A:
		default:
			return board_gxe5108_init(pnstr, hwrev);
		}	
	}
	else if(!compare_pn_str(pnstr, HW_GXE5104_PNSTR))
	{
		switch(hwrev)
		{
		case HW_REV_V11A:
		case HW_REV_V12A:
		case HW_REV_V14A:
		default:
			return board_gxe512xV11A_init(pnstr, hwrev);
		}	
	}
	else if(!compare_pn_str(pnstr, HW_GXE5102_PNSTR))
	{
		switch(hwrev)
		{
		case HW_REV_V14A:
		default:
			return board_gxe5102_init(pnstr, hwrev);
		}	
	}
	else
	{
		printk("Unsupport board\n");	
	}
	return 0;
}
module_init(board_gxe512x_init);
