#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/string.h>
#include "gs_misc.h"

static unsigned short ihwi_model = 0;
static unsigned int ihwi_rev = IHWI_REV_V14A;

int gs_set_ihwi(unsigned short hw_model, unsigned int hw_rev)
{
	ihwi_model = hw_model;
	ihwi_rev = hw_rev;

	printk("IHWI: 0x%04x 0x%08x\n", ihwi_model, ihwi_rev);
	return 0;
}
extern void *__init ucm6202_get_board_gpio(unsigned int hwrev, int *count);
extern int __init board_ucm6202_init(unsigned int hwrev);
extern void *__init ucm6201_get_board_gpio(unsigned int hwrev, int *count);
extern int __init board_ucm6201_init(unsigned int hwrev);

struct gsboard_gpio * __init gs_get_board_gpio(int *count)
{
	switch(ihwi_model)
	{
	case IHWI_MODEL_GXE5116:
		return gxe5116_get_board_gpio(ihwi_rev, count);
	case IHWI_MODEL_GXE5108:
		return gxe5108_get_board_gpio(ihwi_rev, count);
	case IHWI_MODEL_GXE5104:
		return gxe5104_get_board_gpio(ihwi_rev, count);
	case IHWI_MODEL_GXE5102:
		return gxe5102_get_board_gpio(ihwi_rev, count);
	case IHWI_MODEL_UCM6202:
		return ucm6202_get_board_gpio(ihwi_rev, count);
	case IHWI_MODEL_UCM6201:
		return ucm6201_get_board_gpio(ihwi_rev, count);
	default:
		*count = 0;
		printk("Unsupport board(0x%04x) gpio\n", ihwi_model);
		return NULL;	
	}
}

int __init board_gs_init(void)
{
	switch(ihwi_model)
	{
	case IHWI_MODEL_GXE5116:
		return board_gxe5116_init(ihwi_rev);
	case IHWI_MODEL_GXE5108:
		return board_gxe5108_init(ihwi_rev);
	case IHWI_MODEL_GXE5104:
		return board_gxe5104_init(ihwi_rev);
	case IHWI_MODEL_GXE5102:
		return board_gxe5102_init(ihwi_rev);
	case IHWI_MODEL_UCM6202:
		return board_ucm6202_init(ihwi_rev);
	case IHWI_MODEL_UCM6201:
		return board_ucm6201_init(ihwi_rev);
	default:
		printk("Unsupport board(0x%04x)\n", ihwi_model);
	}
	return 0;
}
module_init(board_gs_init);
