/*
 * DMW96 rfkill power control via GPIO
 *
 * Copyright (C) 2011 DSP Group
 * 
 *  Initial code: Pavan Savoy <pavan.savoy@gmail.com> (wl127x_power.c)
 *  modifed by: Ziv Haziz (ziv.haziz@dspg.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <linux/module.h>
#include <linux/init.h>
#include <linux/gpio.h>
#include <linux/rfkill.h>
#include <linux/platform_device.h>
#include <linux/dmw96-rfkill.h>

//#define DEBUG
//#define V_DEBUG

#ifdef V_DEBUG
	#ifndef DEBUG 
		#define DEBUG
	#endif
	#define vdbg_prt(fmt, ...) \
		printk("dmw96 rfkill: %s(): " fmt"\n", __func__, ##__VA_ARGS__)
#else
	#define vdbg_prt(fmt, ...)
#endif

#ifdef DEBUG
	#define dbg_prt(fmt, ...) \
		printk("dmw96 rfkill: %s(): " fmt"\n", __func__, ##__VA_ARGS__)
#else
	#define dbg_prt(fmt, ...)	
#endif

static int dmw96_bt_set_block(void *data, bool blocked)
{
	struct dmw96_rfkill_platform_data *pdata = data;
	dbg_prt();

	if (pdata->btshutdown_gpio != -1) {
		gpio_set_value(pdata->btshutdown_gpio, blocked ? 0:1);
	}

	return 0;
}

static const struct rfkill_ops dmw96_bt_rfkill_ops = {
	.set_block = dmw96_bt_set_block,
};

static int dmw96_rfkill_probe(struct platform_device *pdev)
{
	int err = 0;
	struct dmw96_rfkill_platform_data *pdata = pdev->dev.platform_data;

	dbg_prt();

	/* in case we have real reset line allocate it */
	if (pdata->btshutdown_gpio != -1) {

		printk("rfkill - allocating gpio %x", pdata->btshutdown_gpio);
		err = gpio_request(pdata->btshutdown_gpio, "dmw96_btshutdown_gpio");
		if (unlikely(err))
			return err;

		gpio_set_enable(pdata->btshutdown_gpio,1);
		
		err = gpio_direction_output(pdata->btshutdown_gpio, 0);
		if (unlikely(err))
			return err;
	}


	pdata->bt_rfkill = rfkill_alloc("dmw96-bluetooth", &pdev->dev,
					RFKILL_TYPE_BLUETOOTH,
					&dmw96_bt_rfkill_ops,
					pdata);

	if (unlikely(!pdata->bt_rfkill))
		return -ENOMEM;

	/* bluetooth starts in rf off -> blocked == true */
	rfkill_init_sw_state(pdata->bt_rfkill, true );

    /* api for in kernel functions to stop and start the rf */
	rfkill_set_hw_state(pdata->bt_rfkill, false );

	err = rfkill_register(pdata->bt_rfkill);

	if (err)
		rfkill_destroy(pdata->bt_rfkill);
	
	return 0;
}

static int dmw96_rfkill_remove(struct platform_device *pdev)
{
	struct dmw96_rfkill_platform_data *pdata = pdev->dev.platform_data;

	dbg_prt();

	rfkill_unregister(pdata->bt_rfkill);
	rfkill_destroy(pdata->bt_rfkill);
	//gpio_free(pdata->btshutdown_gpio);

	return 0;
}

static struct platform_driver dmw96_rfkill_platform_driver = {
	.probe = dmw96_rfkill_probe,
	.remove = dmw96_rfkill_remove,
	.driver = {
		   .name = "dmw96_rfkill",
		   .owner = THIS_MODULE,
		   },
};

static int __init dmw96_rfkill_init(void)
{
	dbg_prt();
	return platform_driver_register(&dmw96_rfkill_platform_driver);
}

static void __exit dmw96_rfkill_exit(void)
{
	platform_driver_unregister(&dmw96_rfkill_platform_driver);
}

module_init(dmw96_rfkill_init);
module_exit(dmw96_rfkill_exit);

MODULE_ALIAS("platform:dmw96");
MODULE_DESCRIPTION("dmw96-rfkill");
MODULE_AUTHOR("DSP Group");
MODULE_LICENSE("GPL");
