/** \file
 * This is the network dependent layer to handle network related functionality.
 * This file is tightly coupled to neworking frame work of linux 2.6.xx kernel.
 * The functionality carried out in this file should be treated as an example only
 * if the underlying operating system is not Linux. 
 * 
 * \note Many of the functions other than the device specific functions
 *  changes for operating system other than Linux 2.6.xx
 * \internal 
 *-----------------------------REVISION HISTORY-----------------------------------
 * Synopsys			01/Aug/2007				Created
 */


//#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/init.h>

#include <linux/netdevice.h>
#include <linux/etherdevice.h>


#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/udp.h>

#include <linux/phy.h>
#include <linux/delay.h>

#include <linux/ccu.h>
#include <linux/proc_fs.h>

#include  "vlan_rtl8363.h"

#define SUPPORT_MAX_PHY         2

#define MDC_MDIO_CTRL0_REG          31
#define MDC_MDIO_START_REG          29
#define MDC_MDIO_CTRL1_REG          21
#define MDC_MDIO_ADDRESS_REG        23
#define MDC_MDIO_DATA_WRITE_REG     24
#define MDC_MDIO_DATA_READ_REG      25
#define MDC_MDIO_PREAMBLE_LEN       32

#define MDC_MDIO_START_OP          0xFFFF
#define MDC_MDIO_ADDR_OP           0x000E
#define MDC_MDIO_READ_OP           0x0001
#define MDC_MDIO_WRITE_OP          0x0003

#define SPI_READ_OP                 0x3
#define SPI_WRITE_OP                0x2
#define SPI_READ_OP_LEN             0x8
#define SPI_WRITE_OP_LEN            0x8

#define FALSE 0
#define TRUE 1
#define LAN_VID  101         /*Dmw96, LAN*/
#define WLAN_VID  102         /*Dmw96  Network*/
#define SVIP_VID  1001        /*Dmw96, SVIP*/

static int rtl8363_mdio_write_src(struct mii_bus *bus, int mii_id, int regnum, unsigned short value);
static int rtl8363_mdio_read_src(struct mii_bus *bus, int mii_id, int regnum);

//static int macg_mdio_write(struct mii_bus *bus, int mii_id, int regnum, unsigned short value);
//static int macg_mdio_read(struct mii_bus *bus, int mii_id, int regnum);

static int rtl8363_mdio_read (struct mii_bus *bus, int mii_id, int regnum)
{
    if(mii_id >= SUPPORT_MAX_PHY)
        return 0xffff;
    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Write address control code to register 31 */
    stmmac_mdio_write(bus, 0,  MDC_MDIO_CTRL0_REG, MDC_MDIO_ADDR_OP);

    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0,  MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Write address to register 23 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_ADDRESS_REG, 0x2000+((mii_id+1)<<5)+regnum);

    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0,  MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Write read control code to register 21 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_CTRL1_REG, MDC_MDIO_READ_OP);

    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Read data from register 25 */
   return stmmac_mdio_read(bus , 0,  MDC_MDIO_DATA_READ_REG);

}


static int rtl8363_mdio_write(struct mii_bus *bus, int mii_id, int regnum, unsigned short value)
{
    if(mii_id >= SUPPORT_MAX_PHY)
        return 0;
    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Write address control code to register 31 */
    stmmac_mdio_write(bus, 0,  MDC_MDIO_CTRL0_REG, MDC_MDIO_ADDR_OP);

    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0,  MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Write address to register 23 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_ADDRESS_REG, 0x2000+((mii_id+1)<<5)+regnum);

    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0,  MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Write read control code to register 24 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_DATA_WRITE_REG, value);

    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Read data from register 21 */
    stmmac_mdio_write(bus , 0,  MDC_MDIO_CTRL1_REG, MDC_MDIO_WRITE_OP);

    return 0;
}

static int rtl8363_mdio_read_src(struct mii_bus *bus, int mii_id, int regnum)
{
    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Write address control code to register 31 */
    stmmac_mdio_write(bus, 0,  MDC_MDIO_CTRL0_REG, MDC_MDIO_ADDR_OP);

    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0,  MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Write address to register 23 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_ADDRESS_REG, regnum);

    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0,  MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Write read control code to register 21 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_CTRL1_REG, MDC_MDIO_READ_OP);

    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Read data from register 25 */
   return stmmac_mdio_read(bus , 0,  MDC_MDIO_DATA_READ_REG);

}



static int rtl8363_mdio_write_src(struct mii_bus *bus, int mii_id, int regnum, unsigned short value)
{
    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Write address control code to register 31 */
    stmmac_mdio_write(bus, 0,  MDC_MDIO_CTRL0_REG, MDC_MDIO_ADDR_OP);

    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0,  MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Write address to register 23 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_ADDRESS_REG, regnum);

    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0,  MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Write read control code to register 24 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_DATA_WRITE_REG, value);

    /* Write Start command to register 29 */
    stmmac_mdio_write(bus, 0, MDC_MDIO_START_REG, MDC_MDIO_START_OP);

    /* Read data from register 21 */
    stmmac_mdio_write(bus , 0,  MDC_MDIO_CTRL1_REG, MDC_MDIO_WRITE_OP);

    return 0;
}

static int rtl8363_set_reg_bit(struct mii_bus *bus, int mii_id, unsigned int reg, unsigned int bit, unsigned int value)
{
    rtk_uint16 tmp;

    if(reg > 0xffff || value > 1)
        return 1;
    
    tmp = rtl8363_mdio_read_src(bus, mii_id, reg);
    tmp &= (~(1 << bit));
    tmp |= (value << bit);
    rtl8363_mdio_write_src(bus, mii_id, reg, tmp);
    return 0;
}
static int rtl8363_set_reg_bits(struct mii_bus *bus, int mii_id, unsigned int reg, unsigned int bits, unsigned int value)
{
    unsigned int regdata;
    unsigned int bitshift;
    unsigned int valueshift;
    if(bits >= (1 << 16))
	return -1;
    bitshift = 0;
    while (!(bits & (1<<bitshift)))
    {
        bitshift++;
        if(bitshift >= 16)
	     return -1;
    }
    valueshift = value <<bitshift;
    if(valueshift > 0xffff)
	return -1;
    regdata = rtl8363_mdio_read_src(bus, mii_id, reg);
    regdata = regdata & (~bits);
    regdata = regdata | (valueshift &bits);
    rtl8363_mdio_write_src(bus, mii_id, reg, regdata);
    return 0;
}


static unsigned short ChipData00[][2]= {
/*Code of Func*/
{0x1B03, 0x0876}, {0x1200, 0x7FC0}, {0x0301, 0x0026}, {0x1722, 0x0E14},
{0x205F, 0x0002}, {0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002},
{0x2077, 0x0000}, {0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000},
{0x207B, 0x0000}, {0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000},
{0x2054, 0x0000}, {0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000},
{0x205F, 0x0000}, {0x12A4, 0x110A}, {0x12A6, 0x150A}, {0x13F1, 0x0013},
{0x13F4, 0x0010}, {0x13F5, 0x0000}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x12B6, 0x0C02},
{0x12B7, 0x030F}, {0x12B8, 0x11FF}, {0x12BC, 0x0004}, {0x1362, 0x0115},
{0x1363, 0x0002}, {0x1363, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0007}, {0x221E, 0x002D}, {0x2218, 0xF030}, {0x221F, 0x0007},
{0x221E, 0x0023}, {0x2216, 0x0005}, {0x2215, 0x00B9}, {0x2219, 0x0044},
{0x2215, 0x00BA}, {0x2219, 0x0020}, {0x2215, 0x00BB}, {0x2219, 0x00C1},
{0x2215, 0x0148}, {0x2219, 0x0096}, {0x2215, 0x016E}, {0x2219, 0x0026},
{0x2216, 0x0000}, {0x2216, 0x0000}, {0x221E, 0x002D}, {0x2218, 0xF010},
{0x221F, 0x0007}, {0x221E, 0x0020}, {0x2215, 0x0D00}, {0x221F, 0x0000},
{0x221F, 0x0000}, {0x2217, 0x2160}, {0x221F, 0x0001}, {0x2210, 0xF25E},
{0x221F, 0x0007}, {0x221E, 0x0042}, {0x2215, 0x0F00}, {0x2215, 0x0F00},
{0x2216, 0x7408}, {0x2215, 0x0E00}, {0x2215, 0x0F00}, {0x2215, 0x0F01},
{0x2216, 0x4000}, {0x2215, 0x0E01}, {0x2215, 0x0F01}, {0x2215, 0x0F02},
{0x2216, 0x9400}, {0x2215, 0x0E02}, {0x2215, 0x0F02}, {0x2215, 0x0F03},
{0x2216, 0x7408}, {0x2215, 0x0E03}, {0x2215, 0x0F03}, {0x2215, 0x0F04},
{0x2216, 0x4008}, {0x2215, 0x0E04}, {0x2215, 0x0F04}, {0x2215, 0x0F05},
{0x2216, 0x9400}, {0x2215, 0x0E05}, {0x2215, 0x0F05}, {0x2215, 0x0F06},
{0x2216, 0x0803}, {0x2215, 0x0E06}, {0x2215, 0x0F06}, {0x2215, 0x0D00},
{0x2215, 0x0100}, {0x221F, 0x0001}, {0x2210, 0xF05E}, {0x221F, 0x0000},
{0x2217, 0x2100}, {0x221F, 0x0000}, {0x220D, 0x0003}, {0x220E, 0x0015},
{0x220D, 0x4003}, {0x220E, 0x0006}, {0x221F, 0x0000}, {0x2200, 0x1340},
{0x133F, 0x0010}, {0x12A0, 0x0058}, {0x12A1, 0x0058}, {0x133E, 0x000E},
{0x133F, 0x0030}, {0x221F, 0x0000}, {0x2210, 0x0166}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x221F, 0x0005}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8B6E},
{0x2206, 0x0000}, {0x220F, 0x0100}, {0x2205, 0x8000}, {0x2206, 0x0280},
{0x2206, 0x28F7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7}, {0x2206, 0xA080},
{0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153}, {0x2206, 0x0201},
{0x2206, 0x6602}, {0x2206, 0x80B9}, {0x2206, 0xE08B}, {0x2206, 0x8CE1},
{0x2206, 0x8B8D}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x8E1E},
{0x2206, 0x01A0}, {0x2206, 0x00E7}, {0x2206, 0xAEDB}, {0x2206, 0xEEE0},
{0x2206, 0x120E}, {0x2206, 0xEEE0}, {0x2206, 0x1300}, {0x2206, 0xEEE0},
{0x2206, 0x2001}, {0x2206, 0xEEE0}, {0x2206, 0x2166}, {0x2206, 0xEEE0},
{0x2206, 0xC463}, {0x2206, 0xEEE0}, {0x2206, 0xC5E8}, {0x2206, 0xEEE0},
{0x2206, 0xC699}, {0x2206, 0xEEE0}, {0x2206, 0xC7C2}, {0x2206, 0xEEE0},
{0x2206, 0xC801}, {0x2206, 0xEEE0}, {0x2206, 0xC913}, {0x2206, 0xEEE0},
{0x2206, 0xCA30}, {0x2206, 0xEEE0}, {0x2206, 0xCB3E}, {0x2206, 0xEEE0},
{0x2206, 0xDCE1}, {0x2206, 0xEEE0}, {0x2206, 0xDD00}, {0x2206, 0xEEE2},
{0x2206, 0x0001}, {0x2206, 0xEEE2}, {0x2206, 0x0100}, {0x2206, 0xEEE4},
{0x2206, 0x8860}, {0x2206, 0xEEE4}, {0x2206, 0x8902}, {0x2206, 0xEEE4},
{0x2206, 0x8C00}, {0x2206, 0xEEE4}, {0x2206, 0x8D30}, {0x2206, 0xEEEA},
{0x2206, 0x1480}, {0x2206, 0xEEEA}, {0x2206, 0x1503}, {0x2206, 0xEEEA},
{0x2206, 0xC600}, {0x2206, 0xEEEA}, {0x2206, 0xC706}, {0x2206, 0xEE85},
{0x2206, 0xEE00}, {0x2206, 0xEE85}, {0x2206, 0xEF00}, {0x2206, 0xEE8B},
{0x2206, 0x6750}, {0x2206, 0xEE8B}, {0x2206, 0x6632}, {0x2206, 0xEE8A},
{0x2206, 0xD448}, {0x2206, 0xEE8A}, {0x2206, 0xD548}, {0x2206, 0xEE8A},
{0x2206, 0xD649}, {0x2206, 0xEE8A}, {0x2206, 0xD7F8}, {0x2206, 0xEE8B},
{0x2206, 0x85E2}, {0x2206, 0xEE8B}, {0x2206, 0x8700}, {0x2206, 0xEEFF},
{0x2206, 0xF600}, {0x2206, 0xEEFF}, {0x2206, 0xF7FC}, {0x2206, 0x04F8},
{0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2023}, {0x2206, 0xF620},
{0x2206, 0xE48B}, {0x2206, 0x8E02}, {0x2206, 0x2877}, {0x2206, 0x0225},
{0x2206, 0xC702}, {0x2206, 0x26A1}, {0x2206, 0x0281}, {0x2206, 0xB302},
{0x2206, 0x8496}, {0x2206, 0x0202}, {0x2206, 0xA102}, {0x2206, 0x27F1},
{0x2206, 0x0228}, {0x2206, 0xF902}, {0x2206, 0x2AA0}, {0x2206, 0x0282},
{0x2206, 0xB8E0}, {0x2206, 0x8B8E}, {0x2206, 0xAD21}, {0x2206, 0x08F6},
{0x2206, 0x21E4}, {0x2206, 0x8B8E}, {0x2206, 0x0202}, {0x2206, 0x80E0},
{0x2206, 0x8B8E}, {0x2206, 0xAD22}, {0x2206, 0x05F6}, {0x2206, 0x22E4},
{0x2206, 0x8B8E}, {0x2206, 0xE08B}, {0x2206, 0x8EAD}, {0x2206, 0x2305},
{0x2206, 0xF623}, {0x2206, 0xE48B}, {0x2206, 0x8EE0}, {0x2206, 0x8B8E},
{0x2206, 0xAD24}, {0x2206, 0x08F6}, {0x2206, 0x24E4}, {0x2206, 0x8B8E},
{0x2206, 0x0227}, {0x2206, 0x6AE0}, {0x2206, 0x8B8E}, {0x2206, 0xAD25},
{0x2206, 0x05F6}, {0x2206, 0x25E4}, {0x2206, 0x8B8E}, {0x2206, 0xE08B},
{0x2206, 0x8EAD}, {0x2206, 0x260B}, {0x2206, 0xF626}, {0x2206, 0xE48B},
{0x2206, 0x8E02}, {0x2206, 0x830D}, {0x2206, 0x021D}, {0x2206, 0x6BE0},
{0x2206, 0x8B8E}, {0x2206, 0xAD27}, {0x2206, 0x05F6}, {0x2206, 0x27E4},
{0x2206, 0x8B8E}, {0x2206, 0x0281}, {0x2206, 0x4402}, {0x2206, 0x045C},
{0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B83}, {0x2206, 0xAD23},
{0x2206, 0x30E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x2359},
{0x2206, 0x02E0}, {0x2206, 0x85EF}, {0x2206, 0xE585}, {0x2206, 0xEFAC},
{0x2206, 0x2907}, {0x2206, 0x1F01}, {0x2206, 0x9E51}, {0x2206, 0xAD29},
{0x2206, 0x20E0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x06E1},
{0x2206, 0x8B84}, {0x2206, 0xAD28}, {0x2206, 0x42E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x06E1}, {0x2206, 0x8B84}, {0x2206, 0xAD29},
{0x2206, 0x36BF}, {0x2206, 0x34BF}, {0x2206, 0x022C}, {0x2206, 0x31AE},
{0x2206, 0x2EE0}, {0x2206, 0x8B83}, {0x2206, 0xAD21}, {0x2206, 0x10E0},
{0x2206, 0x8B84}, {0x2206, 0xF620}, {0x2206, 0xE48B}, {0x2206, 0x84EE},
{0x2206, 0x8ADA}, {0x2206, 0x00EE}, {0x2206, 0x8ADB}, {0x2206, 0x00E0},
{0x2206, 0x8B85}, {0x2206, 0xAD21}, {0x2206, 0x0CE0}, {0x2206, 0x8B84},
{0x2206, 0xF621}, {0x2206, 0xE48B}, {0x2206, 0x84EE}, {0x2206, 0x8B72},
{0x2206, 0xFFBF}, {0x2206, 0x34C2}, {0x2206, 0x022C}, {0x2206, 0x31FC},
{0x2206, 0x04F8}, {0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B85},
{0x2206, 0xAD21}, {0x2206, 0x42E0}, {0x2206, 0xE022}, {0x2206, 0xE1E0},
{0x2206, 0x2358}, {0x2206, 0xC059}, {0x2206, 0x021E}, {0x2206, 0x01E1},
{0x2206, 0x8B72}, {0x2206, 0x1F10}, {0x2206, 0x9E2F}, {0x2206, 0xE48B},
{0x2206, 0x72AD}, {0x2206, 0x2123}, {0x2206, 0xE18B}, {0x2206, 0x84F7},
{0x2206, 0x29E5}, {0x2206, 0x8B84}, {0x2206, 0xAC27}, {0x2206, 0x10AC},
{0x2206, 0x2605}, {0x2206, 0x0205}, {0x2206, 0x23AE}, {0x2206, 0x1602},
{0x2206, 0x0535}, {0x2206, 0x0282}, {0x2206, 0x30AE}, {0x2206, 0x0E02},
{0x2206, 0x056A}, {0x2206, 0x0282}, {0x2206, 0x75AE}, {0x2206, 0x0602},
{0x2206, 0x04DC}, {0x2206, 0x0282}, {0x2206, 0x04EF}, {0x2206, 0x96FE},
{0x2206, 0xFC04}, {0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x87AD},
{0x2206, 0x2321}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xAD26}, {0x2206, 0x18F6}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F6}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8F9},
{0x2206, 0xE08B}, {0x2206, 0x87AD}, {0x2206, 0x233A}, {0x2206, 0xAD22},
{0x2206, 0x37E0}, {0x2206, 0xE020}, {0x2206, 0xE1E0}, {0x2206, 0x21AC},
{0x2206, 0x212E}, {0x2206, 0xE0EA}, {0x2206, 0x14E1}, {0x2206, 0xEA15},
{0x2206, 0xF627}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xE2EA}, {0x2206, 0x12E3}, {0x2206, 0xEA13}, {0x2206, 0x5A8F},
{0x2206, 0x6A20}, {0x2206, 0xE6EA}, {0x2206, 0x12E7}, {0x2206, 0xEA13},
{0x2206, 0xF726}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xF727}, {0x2206, 0xE4EA}, {0x2206, 0x14E5}, {0x2206, 0xEA15},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B87},
{0x2206, 0xAD23}, {0x2206, 0x38AD}, {0x2206, 0x2135}, {0x2206, 0xE0E0},
{0x2206, 0x20E1}, {0x2206, 0xE021}, {0x2206, 0xAC21}, {0x2206, 0x2CE0},
{0x2206, 0xEA14}, {0x2206, 0xE1EA}, {0x2206, 0x15F6}, {0x2206, 0x27E4},
{0x2206, 0xEA14}, {0x2206, 0xE5EA}, {0x2206, 0x15E2}, {0x2206, 0xEA12},
{0x2206, 0xE3EA}, {0x2206, 0x135A}, {0x2206, 0x8FE6}, {0x2206, 0xEA12},
{0x2206, 0xE7EA}, {0x2206, 0x13F7}, {0x2206, 0x26E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15F7}, {0x2206, 0x27E4}, {0x2206, 0xEA14},
{0x2206, 0xE5EA}, {0x2206, 0x15FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2146},
{0x2206, 0xE0E0}, {0x2206, 0x22E1}, {0x2206, 0xE023}, {0x2206, 0x58C0},
{0x2206, 0x5902}, {0x2206, 0x1E01}, {0x2206, 0xE18B}, {0x2206, 0x651F},
{0x2206, 0x109E}, {0x2206, 0x33E4}, {0x2206, 0x8B65}, {0x2206, 0xAD21},
{0x2206, 0x22AD}, {0x2206, 0x272A}, {0x2206, 0xD400}, {0x2206, 0x01BF},
{0x2206, 0x34F2}, {0x2206, 0x022C}, {0x2206, 0xA2BF}, {0x2206, 0x34F5},
{0x2206, 0x022C}, {0x2206, 0xE0E0}, {0x2206, 0x8B67}, {0x2206, 0x1B10},
{0x2206, 0xAA14}, {0x2206, 0xE18B}, {0x2206, 0x660D}, {0x2206, 0x1459},
{0x2206, 0x0FAE}, {0x2206, 0x05E1}, {0x2206, 0x8B66}, {0x2206, 0x590F},
{0x2206, 0xBF85}, {0x2206, 0x6102}, {0x2206, 0x2CA2}, {0x2206, 0xEF96},
{0x2206, 0xFEFC}, {0x2206, 0x04F8}, {0x2206, 0xF9FA}, {0x2206, 0xFBEF},
{0x2206, 0x79E2}, {0x2206, 0x8AD2}, {0x2206, 0xAC19}, {0x2206, 0x2DE0},
{0x2206, 0xE036}, {0x2206, 0xE1E0}, {0x2206, 0x37EF}, {0x2206, 0x311F},
{0x2206, 0x325B}, {0x2206, 0x019E}, {0x2206, 0x1F7A}, {0x2206, 0x0159},
{0x2206, 0x019F}, {0x2206, 0x0ABF}, {0x2206, 0x348E}, {0x2206, 0x022C},
{0x2206, 0x31F6}, {0x2206, 0x06AE}, {0x2206, 0x0FF6}, {0x2206, 0x0302},
{0x2206, 0x0470}, {0x2206, 0xF703}, {0x2206, 0xF706}, {0x2206, 0xBF34},
{0x2206, 0x9302}, {0x2206, 0x2C31}, {0x2206, 0xAC1A}, {0x2206, 0x25E0},
{0x2206, 0xE022}, {0x2206, 0xE1E0}, {0x2206, 0x23EF}, {0x2206, 0x300D},
{0x2206, 0x311F}, {0x2206, 0x325B}, {0x2206, 0x029E}, {0x2206, 0x157A},
{0x2206, 0x0258}, {0x2206, 0xC4A0}, {0x2206, 0x0408}, {0x2206, 0xBF34},
{0x2206, 0x9E02}, {0x2206, 0x2C31}, {0x2206, 0xAE06}, {0x2206, 0xBF34},
{0x2206, 0x9C02}, {0x2206, 0x2C31}, {0x2206, 0xAC1B}, {0x2206, 0x4AE0},
{0x2206, 0xE012}, {0x2206, 0xE1E0}, {0x2206, 0x13EF}, {0x2206, 0x300D},
{0x2206, 0x331F}, {0x2206, 0x325B}, {0x2206, 0x1C9E}, {0x2206, 0x3AEF},
{0x2206, 0x325B}, {0x2206, 0x1C9F}, {0x2206, 0x09BF}, {0x2206, 0x3498},
{0x2206, 0x022C}, {0x2206, 0x3102}, {0x2206, 0x83C5}, {0x2206, 0x5A03},
{0x2206, 0x0D03}, {0x2206, 0x581C}, {0x2206, 0x1E20}, {0x2206, 0x0207},
{0x2206, 0xA0A0}, {0x2206, 0x000E}, {0x2206, 0x0284}, {0x2206, 0x17AD},
{0x2206, 0x1817}, {0x2206, 0xBF34}, {0x2206, 0x9A02}, {0x2206, 0x2C31},
{0x2206, 0xAE0F}, {0x2206, 0xBF34}, {0x2206, 0xC802}, {0x2206, 0x2C31},
{0x2206, 0xBF34}, {0x2206, 0xC502}, {0x2206, 0x2C31}, {0x2206, 0x0284},
{0x2206, 0x52E6}, {0x2206, 0x8AD2}, {0x2206, 0xEF97}, {0x2206, 0xFFFE},
{0x2206, 0xFDFC}, {0x2206, 0x04F8}, {0x2206, 0xBF34}, {0x2206, 0xDA02},
{0x2206, 0x2CE0}, {0x2206, 0xE58A}, {0x2206, 0xD3BF}, {0x2206, 0x34D4},
{0x2206, 0x022C}, {0x2206, 0xE00C}, {0x2206, 0x1159}, {0x2206, 0x02E0},
{0x2206, 0x8AD3}, {0x2206, 0x1E01}, {0x2206, 0xE48A}, {0x2206, 0xD3D1},
{0x2206, 0x00BF}, {0x2206, 0x34DA}, {0x2206, 0x022C}, {0x2206, 0xA2D1},
{0x2206, 0x01BF}, {0x2206, 0x34D4}, {0x2206, 0x022C}, {0x2206, 0xA2BF},
{0x2206, 0x34CB}, {0x2206, 0x022C}, {0x2206, 0xE0E5}, {0x2206, 0x8ACE},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CE0}, {0x2206, 0xE58A},
{0x2206, 0xCFBF}, {0x2206, 0x8564}, {0x2206, 0x022C}, {0x2206, 0xE0E5},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6A02}, {0x2206, 0x2CE0},
{0x2206, 0xE58A}, {0x2206, 0xD1FC}, {0x2206, 0x04F8}, {0x2206, 0xE18A},
{0x2206, 0xD1BF}, {0x2206, 0x856A}, {0x2206, 0x022C}, {0x2206, 0xA2E1},
{0x2206, 0x8AD0}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xE18A}, {0x2206, 0xCFBF}, {0x2206, 0x8567}, {0x2206, 0x022C},
{0x2206, 0xA2E1}, {0x2206, 0x8ACE}, {0x2206, 0xBF34}, {0x2206, 0xCB02},
{0x2206, 0x2CA2}, {0x2206, 0xE18A}, {0x2206, 0xD3BF}, {0x2206, 0x34DA},
{0x2206, 0x022C}, {0x2206, 0xA2E1}, {0x2206, 0x8AD3}, {0x2206, 0x0D11},
{0x2206, 0xBF34}, {0x2206, 0xD402}, {0x2206, 0x2CA2}, {0x2206, 0xFC04},
{0x2206, 0xF9A0}, {0x2206, 0x0405}, {0x2206, 0xE38A}, {0x2206, 0xD4AE},
{0x2206, 0x13A0}, {0x2206, 0x0805}, {0x2206, 0xE38A}, {0x2206, 0xD5AE},
{0x2206, 0x0BA0}, {0x2206, 0x0C05}, {0x2206, 0xE38A}, {0x2206, 0xD6AE},
{0x2206, 0x03E3}, {0x2206, 0x8AD7}, {0x2206, 0xEF13}, {0x2206, 0xBF34},
{0x2206, 0xCB02}, {0x2206, 0x2CA2}, {0x2206, 0xEF13}, {0x2206, 0x0D11},
{0x2206, 0xBF85}, {0x2206, 0x6702}, {0x2206, 0x2CA2}, {0x2206, 0xEF13},
{0x2206, 0x0D14}, {0x2206, 0xBF85}, {0x2206, 0x6402}, {0x2206, 0x2CA2},
{0x2206, 0xEF13}, {0x2206, 0x0D17}, {0x2206, 0xBF85}, {0x2206, 0x6A02},
{0x2206, 0x2CA2}, {0x2206, 0xFD04}, {0x2206, 0xF8E0}, {0x2206, 0x8B85},
{0x2206, 0xAD27}, {0x2206, 0x2DE0}, {0x2206, 0xE036}, {0x2206, 0xE1E0},
{0x2206, 0x37E1}, {0x2206, 0x8B73}, {0x2206, 0x1F10}, {0x2206, 0x9E20},
{0x2206, 0xE48B}, {0x2206, 0x73AC}, {0x2206, 0x200B}, {0x2206, 0xAC21},
{0x2206, 0x0DAC}, {0x2206, 0x250F}, {0x2206, 0xAC27}, {0x2206, 0x0EAE},
{0x2206, 0x0F02}, {0x2206, 0x84CC}, {0x2206, 0xAE0A}, {0x2206, 0x0284},
{0x2206, 0xD1AE}, {0x2206, 0x05AE}, {0x2206, 0x0302}, {0x2206, 0x84D8},
{0x2206, 0xFC04}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0x0402},
{0x2206, 0x84E5}, {0x2206, 0x0285}, {0x2206, 0x2804}, {0x2206, 0x0285},
{0x2206, 0x4904}, {0x2206, 0xEE8B}, {0x2206, 0x6800}, {0x2206, 0xEE8B},
{0x2206, 0x6902}, {0x2206, 0x04F8}, {0x2206, 0xF9E0}, {0x2206, 0x8B85},
{0x2206, 0xAD26}, {0x2206, 0x38D0}, {0x2206, 0x0B02}, {0x2206, 0x2B4D},
{0x2206, 0x5882}, {0x2206, 0x7882}, {0x2206, 0x9F2D}, {0x2206, 0xE08B},
{0x2206, 0x68E1}, {0x2206, 0x8B69}, {0x2206, 0x1F10}, {0x2206, 0x9EC8},
{0x2206, 0x10E4}, {0x2206, 0x8B68}, {0x2206, 0xE0E0}, {0x2206, 0x00E1},
{0x2206, 0xE001}, {0x2206, 0xF727}, {0x2206, 0xE4E0}, {0x2206, 0x00E5},
{0x2206, 0xE001}, {0x2206, 0xE2E0}, {0x2206, 0x20E3}, {0x2206, 0xE021},
{0x2206, 0xAD30}, {0x2206, 0xF7F6}, {0x2206, 0x27E4}, {0x2206, 0xE000},
{0x2206, 0xE5E0}, {0x2206, 0x01FD}, {0x2206, 0xFC04}, {0x2206, 0xF8FA},
{0x2206, 0xEF69}, {0x2206, 0xE08B}, {0x2206, 0x86AD}, {0x2206, 0x2212},
{0x2206, 0xE0E0}, {0x2206, 0x14E1}, {0x2206, 0xE015}, {0x2206, 0xAD26},
{0x2206, 0x9CE1}, {0x2206, 0x85E0}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x04F8},
{0x2206, 0xFAEF}, {0x2206, 0x69E0}, {0x2206, 0x8B86}, {0x2206, 0xAD22},
{0x2206, 0x09E1}, {0x2206, 0x85E1}, {0x2206, 0xBF85}, {0x2206, 0x6D02},
{0x2206, 0x2CA2}, {0x2206, 0xEF96}, {0x2206, 0xFEFC}, {0x2206, 0x0464},
{0x2206, 0xE48C}, {0x2206, 0xFDE4}, {0x2206, 0x80CA}, {0x2206, 0xE480},
{0x2206, 0x66E0}, {0x2206, 0x8E70}, {0x2206, 0xE076}, {0x2205, 0xE142},
{0x2206, 0x0701}, {0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000},
{0x221F, 0x0000}, {0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010},
{0x13EB, 0x11BB}, {0x2017, 0xA11F}, {0x2077, 0xA11F}, {0x2097, 0xA11F}
 };
/*End of ChipData00[][2]*/

static unsigned short ChipData01[][2]= {
/*Code of Func*/
{0x1303, 0x0778}, {0x1304, 0x7777}, {0x13E2, 0x01FE}, {0x1310, 0x1075},
{0x1305, 0x0003}, {0x1B03, 0x0876}, {0x1200, 0x7FC0}, {0x1305, 0xC003},
{0x121E, 0x03CA}, {0x1233, 0x0352}, {0x1234, 0x0064}, {0x1237, 0x0096},
{0x1238, 0x0078}, {0x1239, 0x0084}, {0x123A, 0x0030}, {0x205F, 0x0002},
{0x2059, 0x1A00}, {0x205F, 0x0000}, {0x207F, 0x0002}, {0x2077, 0x0000},
{0x2078, 0x0000}, {0x2079, 0x0000}, {0x207A, 0x0000}, {0x207B, 0x0000},
{0x207F, 0x0000}, {0x205F, 0x0002}, {0x2053, 0x0000}, {0x2054, 0x0000},
{0x2055, 0x0000}, {0x2056, 0x0000}, {0x2057, 0x0000}, {0x205F, 0x0000},
{0x133F, 0x0030}, {0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B86},
{0x2206, 0x800E}, {0x221F, 0x0000}, {0x133F, 0x0010}, {0x12A3, 0x2200},
{0x6107, 0xE58B}, {0x6103, 0xA970}, {0x0018, 0x0F00}, {0x0038, 0x0F00},
{0x0058, 0x0F00}, {0x0078, 0x0F00}, {0x0098, 0x0F00}, {0x133F, 0x0030},
{0x133E, 0x000E}, {0x221F, 0x0005}, {0x2205, 0x8B6E}, {0x2206, 0x0000},
{0x220F, 0x0100}, {0x2205, 0xFFF6}, {0x2206, 0x0080}, {0x2205, 0x8000},
{0x2206, 0x0280}, {0x2206, 0x2BF7}, {0x2206, 0x00E0}, {0x2206, 0xFFF7},
{0x2206, 0xA080}, {0x2206, 0x02AE}, {0x2206, 0xF602}, {0x2206, 0x0153},
{0x2206, 0x0201}, {0x2206, 0x6602}, {0x2206, 0x8044}, {0x2206, 0x0201},
{0x2206, 0x7CE0}, {0x2206, 0x8B8C}, {0x2206, 0xE18B}, {0x2206, 0x8D1E},
{0x2206, 0x01E1}, {0x2206, 0x8B8E}, {0x2206, 0x1E01}, {0x2206, 0xA000},
{0x2206, 0xE4AE}, {0x2206, 0xD8EE}, {0x2206, 0x85C0}, {0x2206, 0x00EE},
{0x2206, 0x85C1}, {0x2206, 0x00EE}, {0x2206, 0x8AFC}, {0x2206, 0x07EE},
{0x2206, 0x8AFD}, {0x2206, 0x73EE}, {0x2206, 0xFFF6}, {0x2206, 0x00EE},
{0x2206, 0xFFF7}, {0x2206, 0xFC04}, {0x2206, 0xF8E0}, {0x2206, 0x8B8E},
{0x2206, 0xAD20}, {0x2206, 0x0302}, {0x2206, 0x8050}, {0x2206, 0xFC04},
{0x2206, 0xF8F9}, {0x2206, 0xE08B}, {0x2206, 0x85AD}, {0x2206, 0x2548},
{0x2206, 0xE08A}, {0x2206, 0xE4E1}, {0x2206, 0x8AE5}, {0x2206, 0x7C00},
{0x2206, 0x009E}, {0x2206, 0x35EE}, {0x2206, 0x8AE4}, {0x2206, 0x00EE},
{0x2206, 0x8AE5}, {0x2206, 0x00E0}, {0x2206, 0x8AFC}, {0x2206, 0xE18A},
{0x2206, 0xFDE2}, {0x2206, 0x85C0}, {0x2206, 0xE385}, {0x2206, 0xC102},
{0x2206, 0x2DAC}, {0x2206, 0xAD20}, {0x2206, 0x12EE}, {0x2206, 0x8AE4},
{0x2206, 0x03EE}, {0x2206, 0x8AE5}, {0x2206, 0xB7EE}, {0x2206, 0x85C0},
{0x2206, 0x00EE}, {0x2206, 0x85C1}, {0x2206, 0x00AE}, {0x2206, 0x1115},
{0x2206, 0xE685}, {0x2206, 0xC0E7}, {0x2206, 0x85C1}, {0x2206, 0xAE08},
{0x2206, 0xEE85}, {0x2206, 0xC000}, {0x2206, 0xEE85}, {0x2206, 0xC100},
{0x2206, 0xFDFC}, {0x2206, 0x0400}, {0x2205, 0xE142}, {0x2206, 0x0701},
{0x2205, 0xE140}, {0x2206, 0x0405}, {0x220F, 0x0000}, {0x221F, 0x0000},
{0x133E, 0x000E}, {0x133F, 0x0010}, {0x13EB, 0x11BB}, {0x207F, 0x0002},
{0x2073, 0x1D22}, {0x207F, 0x0000}, {0x133F, 0x0030}, {0x133E, 0x000E},
{0x2200, 0x1340}, {0x133E, 0x000E}, {0x133F, 0x0010}, {0x2000, 0x1940},
{0x2060, 0x1940}, {0x2080, 0x1940}, {0x2017, 0xA100}, {0x2077, 0xA100},
{0x2097, 0xA100}, };
/*End of ChipData01[][2]*/

#define    RTL_REG_MAGIC_ID    0x13c2
#define    RTL_REG_CHIP_VER    0x1301
#define    RTL_REG_DIGITAL_INTERFACE_SELECT    0x1305
#define    RTL8367B_ORG_COL_OFFSET    15
#define    RTL8367B_ORG_COL_MASK    0x8000
#define    RTL8367B_ORG_CRS_OFFSET    14
#define    RTL8367B_ORG_CRS_MASK    0x4000
#define    RTL8367B_SKIP_MII_1_RXER_OFFSET    13
#define    RTL8367B_SKIP_MII_1_RXER_MASK    0x2000
#define    RTL8367B_SKIP_MII_0_RXER_OFFSET    12
#define    RTL8367B_SKIP_MII_0_RXER_MASK    0x1000
#define    RTL8367B_SELECT_GMII_1_OFFSET    4
#define    RTL8367B_SELECT_GMII_1_MASK    0xF0
#define    RTL8367B_SELECT_GMII_0_OFFSET    0
#define    RTL8367B_SELECT_GMII_0_MASK    0xF

enum EXTMODE
{
    EXT_DISABLE = 0,
    EXT_RGMII,
    EXT_MII_MAC,
    EXT_MII_PHY,
    EXT_TMII_MAC,
    EXT_TMII_PHY,
    EXT_GMII,
    EXT_RMII_MAC,
    EXT_RMII_PHY,
    EXT_END
};

#define	RTL8367B_REG_LED_CONFIGURATION	0x1b03
#define	RTL8367B_LEDGROUPNO		3
#define	RTL8367B_LED0_CFG_MASK		0xF
#define	RTL8367B_LED1_CFG_MASK		0xF0
#define	RTL8367B_LED2_CFG_MASK		0xF00
#define	RTL8367B_LED_CONFIG_SEL_OFFSET	14

#define    RTL8367B_REG_DIGITAL_INTERFACE1_FORCE    0x1311
#define    RTL8367B_GMII_1_FORCE_OFFSET    12
#define    RTL8367B_GMII_1_FORCE_MASK    0x1000
#define    RTL8367B_RGMII_1_FORCE_OFFSET    0
#define    RTL8367B_RGMII_1_FORCE_MASK    0xFFF

#define    RTL8367B_REG_EXT0_RGMXF    0x1306
#define    RTL8367B_EXT0_RGTX_INV_OFFSET    6
#define    RTL8367B_EXT0_RGTX_INV_MASK    0x40
#define    RTL8367B_EXT0_RGRX_INV_OFFSET    5
#define    RTL8367B_EXT0_RGRX_INV_MASK    0x20
#define    RTL8367B_EXT0_RGMXF_OFFSET    0
#define    RTL8367B_EXT0_RGMXF_MASK    0x1F

#define    RTL8367B_REG_EXT1_RGMXF    0x1307
#define    RTL8367B_EXT1_RGTX_INV_OFFSET    6
#define    RTL8367B_EXT1_RGTX_INV_MASK    0x40
#define    RTL8367B_EXT1_RGRX_INV_OFFSET    5
#define    RTL8367B_EXT1_RGRX_INV_MASK    0x20
#define    RTL8367B_EXT1_RGMXF_OFFSET    0
#define    RTL8367B_EXT1_RGMXF_MASK    0x1F

#define    RTL8367B_REG_EXT2_RGMXF    0x13c5

enum RTL8367B_LEDCONF{

    LEDCONF_LEDOFF=0,
    LEDCONF_DUPCOL,
    LEDCONF_LINK_ACT,
    LEDCONF_SPD1000,
    LEDCONF_SPD100,
    LEDCONF_SPD10,
    LEDCONF_SPD1000ACT,
    LEDCONF_SPD100ACT,
    LEDCONF_SPD10ACT,
    LEDCONF_SPD10010ACT,
    LEDCONF_LOOPDETECT,
    LEDCONF_EEE,
    LEDCONF_LINKRX,
    LEDCONF_LINKTX,
    LEDCONF_MASTER,
    LEDCONF_ACT,
    LEDCONF_END
};

int rtk_set_bit(struct mii_bus *bus, u32 reg, u32 bit, u32 val)
{
	u16 data = 0;

	data = rtl8363_mdio_read_src(bus, 0, reg);
        if(val)
                data = data | (1 << bit);
        else
                data = data & (~(1 << bit));

	rtl8363_mdio_write_src(bus, 0, reg, data);
	return 0;
}

int rtk_set_bits(struct mii_bus *bus, u32 reg, u32 bits, u32 val)
{
	int rval;
	u16 data = 0;
	u16 shift;
        u16 value;

        if(bits >= (1 << 16) )
                return -1;

        shift = 0;
        while(!(bits & (1 << shift)))
        {
                shift++;
                if(shift >= 16)
                        return -1;
        }

        value = val << shift;
        if(value > 0xffff)
                return -1;

        data = rtl8363_mdio_read_src(bus, 0, reg);

        data = data & (~bits);
        data = data | (value & bits);
	rval = rtl8363_mdio_write_src(bus, 0, reg, data);

	return 0;
}

int rtk_set_led(struct mii_bus *bus, u32 ledno, enum RTL8367B_LEDCONF config)
{
	int rval;
	const u16 bits[RTL8367B_LEDGROUPNO] = {RTL8367B_LED0_CFG_MASK, RTL8367B_LED1_CFG_MASK, RTL8367B_LED2_CFG_MASK};

	rval = rtk_set_bit(bus, RTL8367B_REG_LED_CONFIGURATION, RTL8367B_LED_CONFIG_SEL_OFFSET, 0);

    	return rtk_set_bits(bus, RTL8367B_REG_LED_CONFIGURATION, bits[ledno], config);
}

int rtk_port_rgmii_delay_set(struct mii_bus *bus, int port, u32 txdelay, u32 rxdelay)
{
    int rval;
    u32 regaddr, regdata;

    if ((txdelay > 1) || (rxdelay > 7))
        return -1;

    if (port >= 2)
        return -1;

    if(port == 0)
        regaddr = RTL8367B_REG_EXT0_RGMXF;
    else if(port == 1)
        regaddr = RTL8367B_REG_EXT1_RGMXF;
    else
        return -1;

    regdata = rtl8363_mdio_read_src(bus, 0, regaddr);
    regdata = (regdata & 0xFFF0) | ((txdelay << 3) & 0x0008) | (rxdelay & 0x0007);

    rval = rtl8363_mdio_write_src(bus, 0, regaddr, regdata);

    return 0;
}

/**********************************Vlan*****************/
#include "vlan_rtl8363.h"

ret_t rtl8367b_getAsicRegBit(struct mii_bus *bus, rtk_uint32 reg, rtk_uint32 bit, rtk_uint32 *pValue)
{
    rtk_uint16 tmp;

    if(reg > RTL8367B_REGDATAMAX )
	    return RT_ERR_INPUT;

	tmp = rtl8363_mdio_read_src(bus, 0, reg);
	tmp = tmp >> bit;
	tmp &= 1;
	*pValue = tmp;

	return RT_ERR_OK;
}

ret_t rtl8367b_getAsicRegBits(struct mii_bus *bus, rtk_uint32 reg, rtk_uint32 bits, rtk_uint32 *pValue)
{
    rtk_uint32 regData;
    rtk_uint32 bitsShift;

    if(reg > RTL8367B_REGDATAMAX )
	    return RT_ERR_INPUT;

    if(bits >= (1UL << RTL8367B_REGBITLENGTH) )
        return RT_ERR_INPUT;

    bitsShift = 0;
    while(!(bits & (1UL << bitsShift)))
    {
        bitsShift++;
        if(bitsShift >= RTL8367B_REGBITLENGTH)
            return RT_ERR_INPUT;
    }

    regData = rtl8363_mdio_read_src(bus, 0, reg);
    *pValue = (regData & bits) >> bitsShift;

	return RT_ERR_OK;
}

void _rtl8367b_VlanMCStUser2Smi(rtl8367b_vlanconfiguser *pVlanCg, rtl8367b_vlanconfigsmi *pSmiVlanCfg)
{
    pSmiVlanCfg->mbr        = pVlanCg->mbr;
    pSmiVlanCfg->fid_msti   = pVlanCg->fid_msti;
    pSmiVlanCfg->evid       = pVlanCg->evid;
    pSmiVlanCfg->meteridx   = pVlanCg->meteridx;
    pSmiVlanCfg->envlanpol  = pVlanCg->envlanpol;
    pSmiVlanCfg->vbpri      = pVlanCg->vbpri;
    pSmiVlanCfg->vbpen      = pVlanCg->vbpen;
}

void _rtl8367b_Vlan4kStUser2Smi(rtl8367b_user_vlan4kentry *pUserVlan4kEntry, rtl8367b_vlan4kentrysmi *pSmiVlan4kEntry)
{
    pSmiVlan4kEntry->mbr        = pUserVlan4kEntry->mbr;
    pSmiVlan4kEntry->untag      = pUserVlan4kEntry->untag;
    pSmiVlan4kEntry->fid_msti   = pUserVlan4kEntry->fid_msti;
    pSmiVlan4kEntry->vbpen      = pUserVlan4kEntry->vbpen;
    pSmiVlan4kEntry->vbpri      = pUserVlan4kEntry->vbpri;
    pSmiVlan4kEntry->envlanpol  = pUserVlan4kEntry->envlanpol;
    pSmiVlan4kEntry->meteridx   = pUserVlan4kEntry->meteridx;
    pSmiVlan4kEntry->ivl_svl    = pUserVlan4kEntry->ivl_svl;

}

void _rtl8367b_VlanMCStSmi2User(rtl8367b_vlanconfigsmi *pSmiVlanCfg, rtl8367b_vlanconfiguser *pVlanCg)
{
    pVlanCg->mbr            = pSmiVlanCfg->mbr;
    pVlanCg->fid_msti       = pSmiVlanCfg->fid_msti;
    pVlanCg->evid           = pSmiVlanCfg->evid;
    pVlanCg->meteridx       = pSmiVlanCfg->meteridx;
    pVlanCg->envlanpol      = pSmiVlanCfg->envlanpol;
    pVlanCg->vbpri          = pSmiVlanCfg->vbpri;
    pVlanCg->vbpen          = pSmiVlanCfg->vbpen;
}

void _rtl8367b_Vlan4kStSmi2User(rtl8367b_vlan4kentrysmi *pSmiVlan4kEntry, rtl8367b_user_vlan4kentry *pUserVlan4kEntry)
{
    pUserVlan4kEntry->mbr       = pSmiVlan4kEntry->mbr;
    pUserVlan4kEntry->untag     = pSmiVlan4kEntry->untag;
    pUserVlan4kEntry->fid_msti  = pSmiVlan4kEntry->fid_msti;
    pUserVlan4kEntry->vbpen     = pSmiVlan4kEntry->vbpen;
    pUserVlan4kEntry->vbpri     = pSmiVlan4kEntry->vbpri;
    pUserVlan4kEntry->envlanpol = pSmiVlan4kEntry->envlanpol;
    pUserVlan4kEntry->meteridx  = pSmiVlan4kEntry->meteridx;
    pUserVlan4kEntry->ivl_svl   = pSmiVlan4kEntry->ivl_svl;
}

rt_error_code_t rtl8367b_setAsicVlanMemberConfig(struct mii_bus *bus, rtk_uint32 index, rtl8367b_vlanconfiguser *pVlanCg)
{
	ret_t  retVal;
	rtk_uint32 regAddr;
	rtk_uint32 regData;
	rtk_uint16 *tableAddr;
    rtk_uint32 page_idx;
    rtl8367b_vlanconfigsmi  smi_vlancfg;

    /* Error Checking  */
	if(index > RTL8367B_CVIDXMAX)
        return RT_ERR_VLAN_ENTRY_NOT_FOUND;

    if(pVlanCg->evid > RTL8367B_EVIDMAX)
        return RT_ERR_INPUT;


    if(pVlanCg->mbr > RTL8367B_PORTMASK)
        return RT_ERR_PORT_MASK;

    if(pVlanCg->fid_msti > RTL8367B_FIDMAX)
        return RT_ERR_L2_FID;

    if(pVlanCg->meteridx > RTL8367B_METERMAX)
        return RT_ERR_FILTER_METER_ID;

    if(pVlanCg->vbpri > RTL8367B_PRIMAX)
        return RT_ERR_QOS_INT_PRIORITY;

    memset(&smi_vlancfg, 0x00, sizeof(rtl8367b_vlanconfigsmi));
    _rtl8367b_VlanMCStUser2Smi(pVlanCg, &smi_vlancfg);
    tableAddr = (rtk_uint16*)&smi_vlancfg;

    for(page_idx = 0; page_idx < 4; page_idx++)  /* 4 pages per VLAN Member Config */
    {
        regAddr = RTL8367B_VLAN_MEMBER_CONFIGURATION_BASE + (index * 4) + page_idx;
    	regData = *tableAddr;

    	//retVal = rtl8367b_setAsicReg(regAddr, regData);
    	if(regAddr > RTL8367B_REGDATAMAX || regData > RTL8367B_REGDATAMAX )
            return RT_ERR_INPUT;
    	retVal = rtl8363_mdio_write_src(bus, 0, regAddr, regData);
        
    	if(retVal != RT_ERR_OK)
            return retVal;

        tableAddr++;
    }

	return RT_ERR_OK;
}

rt_error_code_t rtl8367b_setAsicVlan4kEntry(struct mii_bus *bus, rtl8367b_user_vlan4kentry *pVlan4kEntry )
{
    rtl8367b_vlan4kentrysmi vlan_4k_entry;
	rtk_uint32					page_idx;
	rtk_uint16					*tableAddr;
	ret_t 					retVal;
	rtk_uint32 					regData;

    if(pVlan4kEntry->vid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    if(pVlan4kEntry->mbr > RTL8367B_PORTMASK)
        return RT_ERR_PORT_MASK;

    if(pVlan4kEntry->untag > RTL8367B_PORTMASK)
        return RT_ERR_PORT_MASK;

    if(pVlan4kEntry->fid_msti > RTL8367B_FIDMAX)
        return RT_ERR_L2_FID;

    if(pVlan4kEntry->meteridx > RTL8367B_METERMAX)
        return RT_ERR_FILTER_METER_ID;

    if(pVlan4kEntry->vbpri > RTL8367B_PRIMAX)
        return RT_ERR_QOS_INT_PRIORITY;

    memset(&vlan_4k_entry, 0x00, sizeof(rtl8367b_vlan4kentrysmi));
    _rtl8367b_Vlan4kStUser2Smi(pVlan4kEntry, &vlan_4k_entry);

	/* Prepare Data */
	tableAddr = (rtk_uint16 *)&vlan_4k_entry;
	for(page_idx = 0; page_idx < (sizeof(rtl8367b_vlan4kentrysmi) / 2); page_idx++)
	{
		regData = *tableAddr;
        
		//retVal = rtl8367b_setAsicReg(RTL8367B_TABLE_ACCESS_WRDATA_BASE + page_idx, regData);
        if( regData > RTL8367B_REGDATAMAX )
            return RT_ERR_INPUT;
    	retVal = rtl8363_mdio_write_src(bus, 0, RTL8367B_TABLE_ACCESS_WRDATA_BASE + page_idx, regData);

        
		if(retVal != RT_ERR_OK)
			return retVal;

		tableAddr++;
	}

	/* Write Address (VLAN_ID) */
	regData = pVlan4kEntry->vid;
	//retVal = rtl8367b_setAsicReg(RTL8367B_TABLE_ACCESS_ADDR_REG, regData);
    if( regData > RTL8367B_REGDATAMAX )
        return RT_ERR_INPUT;
    retVal = rtl8363_mdio_write_src(bus, 0, RTL8367B_TABLE_ACCESS_ADDR_REG, regData);
    
	if(retVal != RT_ERR_OK)
		return retVal;

	/* Write Command */
	//retVal = rtl8367b_setAsicRegBits(RTL8367B_TABLE_ACCESS_CTRL_REG, RTL8367B_TABLE_TYPE_MASK | RTL8367B_COMMAND_TYPE_MASK,RTL8367B_TABLE_ACCESS_REG_DATA(TB_OP_WRITE,TB_TARGET_CVLAN));
    retVal = rtl8363_set_reg_bits(bus, 0,
        RTL8367B_TABLE_ACCESS_CTRL_REG,
        RTL8367B_TABLE_TYPE_MASK | RTL8367B_COMMAND_TYPE_MASK,
        RTL8367B_TABLE_ACCESS_REG_DATA(TB_OP_WRITE,TB_TARGET_CVLAN));
    
	if(retVal != RT_ERR_OK)
		return retVal;
#if 0
#if defined(CONFIG_RTL8367B_ASICDRV_TEST)
    memcpy(&Rtl8370sVirtualVlanTable[pVlan4kEntry->vid], &vlan_4k_entry, sizeof(rtl8367b_vlan4kentrysmi));
#endif

#if !defined(DISABLE_VLAN_SHADOW)
    memcpy(&user_4kvlan[pVlan4kEntry->vid], pVlan4kEntry, sizeof(rtl8367b_user_vlan4kentry));
#endif
#endif
    return RT_ERR_OK;
}

rt_error_code_t rtl8367b_setAsicVlanPortBasedVID(struct mii_bus *bus, rtk_uint32 port, rtk_uint32 index, rtk_uint32 pri) 
{
    rtk_uint32 regAddr, bit_mask;
    ret_t  retVal;

    if(port > RTL8367B_PORTIDMAX)
        return RT_ERR_PORT_ID;

    if(index > RTL8367B_CVIDXMAX)
        return RT_ERR_VLAN_ENTRY_NOT_FOUND;

    if(pri > RTL8367B_PRIMAX)
        return RT_ERR_QOS_INT_PRIORITY;

    regAddr = RTL8367B_VLAN_PVID_CTRL_REG(port);
    bit_mask = RTL8367B_PORT_VIDX_MASK(port);
    //retVal = rtl8367b_setAsicRegBits(regAddr, bit_mask, index);
    retVal = rtl8363_set_reg_bits(bus, 0,regAddr, bit_mask, index);
    if(retVal != RT_ERR_OK)
        return retVal;

    regAddr = RTL8367B_VLAN_PORTBASED_PRIORITY_REG(port);
    bit_mask = RTL8367B_VLAN_PORTBASED_PRIORITY_MASK(port);
    //retVal = rtl8367b_setAsicRegBits(regAddr, bit_mask, pri);
    retVal = rtl8363_set_reg_bits(bus, 0, regAddr, bit_mask, pri);
    if(retVal != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

rt_error_code_t rtl8367b_getAsicVlanMemberConfig(struct mii_bus *bus, rtk_uint32 index, rtl8367b_vlanconfiguser *pVlanCg)
{
 //   ret_t  retVal;
    rtk_uint32 page_idx;
    rtk_uint32 regAddr;
    rtk_uint32 regData;
    rtk_uint16 *tableAddr;
    rtl8367b_vlanconfigsmi  smi_vlancfg;

    if(index > RTL8367B_CVIDXMAX)
        return RT_ERR_VLAN_ENTRY_NOT_FOUND;

    memset(&smi_vlancfg, 0x00, sizeof(rtl8367b_vlanconfigsmi));
    tableAddr  = (rtk_uint16*)&smi_vlancfg;

    for(page_idx = 0; page_idx < 4; page_idx++)  /* 4 pages per VLAN Member Config */
    {    
        regAddr = RTL8367B_VLAN_MEMBER_CONFIGURATION_BASE + (index * 4) + page_idx;

        //retVal = rtl8367b_getAsicReg(regAddr, &regData);
       // if(retVal != RT_ERR_OK)
        //    return retVal;
        
        regData = rtl8363_mdio_read_src(bus, 0, regAddr);

        *tableAddr = (rtk_uint16)regData;
        tableAddr++;
    }    

    _rtl8367b_VlanMCStSmi2User(&smi_vlancfg, pVlanCg);
    return RT_ERR_OK;
}

rt_error_code_t rtl8367b_setAsicVlanEgressTagMode(struct mii_bus *bus, rtk_uint32 port, rtl8367b_egtagmode tagMode)
{
    if(port > RTL8367B_PORTIDMAX)
        return RT_ERR_PORT_ID;

    if(tagMode >= EG_TAG_MODE_END)
        return RT_ERR_INPUT;

    //return rtl8367b_setAsicRegBits(RTL8367B_PORT_MISC_CFG_REG(port), RTL8367B_VLAN_EGRESS_MDOE_MASK, tagMode);
    return rtl8363_set_reg_bits(bus, 0, RTL8367B_PORT_MISC_CFG_REG(port), RTL8367B_VLAN_EGRESS_MDOE_MASK, tagMode);
}

ret_t rtl8367b_setAsicVlanFilter(struct mii_bus *bus, rtk_uint32 enabled)
{
    //return rtl8367b_setAsicRegBit(RTL8367B_REG_VLAN_CTRL, RTL8367B_VLAN_CTRL_OFFSET, enabled);
    return rtl8363_set_reg_bit(bus, 0, RTL8367B_REG_VLAN_CTRL, RTL8367B_VLAN_CTRL_OFFSET, enabled);
}

ret_t rtl8367b_getAsic1xGuestVidx(struct mii_bus *bus, rtk_uint32 *pIndex)
{
    return rtl8367b_getAsicRegBits(bus, RTL8367B_DOT1X_CFG_REG, RTL8367B_DOT1X_GVIDX_MASK, pIndex);
}

rt_error_code_t rtk_vlan_set(struct mii_bus *bus, rtk_vlan_t vid, rtk_portmask_t mbrmsk, rtk_portmask_t untagmsk, rtk_fid_t fid)
{
    rtk_api_ret_t retVal;
    rtl8367b_user_vlan4kentry vlan4K;

    /* vid must be 0~4095 */
    if (vid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    if (mbrmsk.bits[0] > RTK_MAX_PORT_MASK)
        return RT_ERR_VLAN_PORT_MBR_EXIST;

    if (untagmsk.bits[0] > RTK_MAX_PORT_MASK)
        return RT_ERR_VLAN_PORT_MBR_EXIST;

    /* fid must be 0~15 */
    if ( (fid != RTK_IVL_MODE_FID) && (fid > RTL8367B_FIDMAX) )
        return RT_ERR_L2_FID;

    /* update 4K table */
    memset(&vlan4K, 0, sizeof(rtl8367b_user_vlan4kentry));
    vlan4K.vid = vid;
    vlan4K.mbr = mbrmsk.bits[0];
    vlan4K.untag = untagmsk.bits[0];

    if(fid == RTK_IVL_MODE_FID)
    {
        vlan4K.ivl_svl  = 1;  
        vlan4K.fid_msti = 0;
    }
    else  
        vlan4K.fid_msti = fid;

    if ((retVal = rtl8367b_setAsicVlan4kEntry(bus, &vlan4K)) != RT_ERR_OK)
            return retVal;

    return RT_ERR_OK;
}

rt_error_code_t rtl8367b_getAsicVlan4kEntry(struct mii_bus *bus, rtl8367b_user_vlan4kentry *pVlan4kEntry )
{
	rtl8367b_vlan4kentrysmi vlan_4k_entry;
	rtk_uint32					page_idx;
	rtk_uint16					*tableAddr;
	ret_t 					    retVal;
	rtk_uint32 					regData;

    if(pVlan4kEntry->vid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

	/* Write Address (VLAN_ID) */
	regData = pVlan4kEntry->vid;
    
	//retVal = rtl8367b_setAsicReg(RTL8367B_TABLE_ACCESS_ADDR_REG, regData);
	if(regData > RTL8367B_REGDATAMAX )
            return RT_ERR_INPUT;
    	retVal = rtl8363_mdio_write_src(bus, 0, RTL8367B_TABLE_ACCESS_ADDR_REG, regData);
        
	if(retVal != RT_ERR_OK)
		return retVal;

	/* Read Command */
	//retVal = rtl8367b_setAsicRegBits(RTL8367B_TABLE_ACCESS_CTRL_REG, RTL8367B_TABLE_TYPE_MASK | RTL8367B_COMMAND_TYPE_MASK, RTL8367B_TABLE_ACCESS_REG_DATA(TB_OP_READ,TB_TARGET_CVLAN));
    retVal = rtl8363_set_reg_bits(bus, 0,
        RTL8367B_TABLE_ACCESS_CTRL_REG, RTL8367B_TABLE_TYPE_MASK | RTL8367B_COMMAND_TYPE_MASK,
        RTL8367B_TABLE_ACCESS_REG_DATA(TB_OP_READ,TB_TARGET_CVLAN));
    if(retVal != RT_ERR_OK)
		return retVal;

	/* Check ASIC Command */
	retVal = rtl8367b_getAsicRegBit(bus, RTL8367B_TABLE_ACCESS_STATUS_REG, RTL8367B_TABLE_LUT_ADDR_BUSY_FLAG_OFFSET,&regData);
	if(retVal != RT_ERR_OK)
        return RT_ERR_BUSYWAIT_TIMEOUT;

	/* Read VLAN data from register */
	tableAddr = (rtk_uint16 *)&vlan_4k_entry;
	for(page_idx = 0; page_idx < (sizeof(rtl8367b_vlan4kentrysmi) / 2); page_idx++)
	{
		//retVal = rtl8367b_getAsicReg(RTL8367B_TABLE_ACCESS_RDDATA_BASE + page_idx, &regData);
		//if(retVal != RT_ERR_OK)
		//	return retVal;
		regData = rtl8363_mdio_read_src(bus, 0, RTL8367B_TABLE_ACCESS_RDDATA_BASE + page_idx);

		*tableAddr = regData;
		tableAddr++;
	}

	_rtl8367b_Vlan4kStSmi2User(&vlan_4k_entry, pVlan4kEntry);

    return RT_ERR_OK;
}

rt_error_code_t rtl8367b_getAsicVlanPortBasedVID(struct mii_bus *bus, rtk_uint32 port, rtk_uint32 *pIndex, rtk_uint32 *pPri)
{
    rtk_uint32 regAddr,bit_mask;
    ret_t  retVal;

    if(port > RTL8367B_PORTIDMAX)
        return RT_ERR_PORT_ID;

    regAddr = RTL8367B_VLAN_PVID_CTRL_REG(port);
    bit_mask = RTL8367B_PORT_VIDX_MASK(port);
    retVal = rtl8367b_getAsicRegBits(bus, regAddr, bit_mask, pIndex);
    if(retVal != RT_ERR_OK)
        return retVal;

    regAddr = RTL8367B_VLAN_PORTBASED_PRIORITY_REG(port);
    bit_mask = RTL8367B_VLAN_PORTBASED_PRIORITY_MASK(port);
    retVal = rtl8367b_getAsicRegBits(bus, regAddr, bit_mask, pPri);
    if(retVal != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

rt_error_code_t rtl8367b_getAsic1xProcConfig(struct mii_bus *bus, rtk_uint32 port, rtk_uint32* pProc)
{
    if(port >= RTL8367B_PORTNO)
        return RT_ERR_PORT_ID;

    return rtl8367b_getAsicRegBits(bus, RTL8367B_DOT1X_UNAUTH_ACT_BASE, RTL8367B_DOT1X_UNAUTH_ACT_MASK(port),pProc);
}

rt_error_code_t rtl8367b_getAsicVlanPortAndProtocolBased(struct mii_bus *bus, rtk_uint32 port, rtk_uint32 index, rtl8367b_protocolvlancfg *pPpbCfg)
{
    rtk_uint32  reg_addr, bit_mask, bit_value;
    ret_t   retVal;

    /* Error Checking */
    if(port > RTL8367B_PORTIDMAX)
        return RT_ERR_PORT_ID;

    if(index > RTL8367B_PROTOVLAN_GIDX_MAX)
        return RT_ERR_VLAN_PROTO_AND_PORT;

    if(pPpbCfg == NULL)
        return RT_ERR_INPUT;

    /* Valid bit */
    reg_addr  = RTL8367B_VLAN_PPB_VALID_REG(index);
    bit_mask  = 0x0001 << port;
    retVal    = rtl8367b_getAsicRegBits(bus, reg_addr, bit_mask, &bit_value);
    if(retVal != RT_ERR_OK)
        return retVal;

    pPpbCfg->valid = bit_value;

    /* CVLAN index */
    reg_addr = RTL8367B_VLAN_PPB_CTRL_REG(index,port);
    bit_mask = RTL8367B_VLAN_PPB_CTRL_MASK(port);
    retVal = rtl8367b_getAsicRegBits(bus, reg_addr, bit_mask, &bit_value);
    if(retVal != RT_ERR_OK)
        return retVal;

    pPpbCfg->vlan_idx = bit_value;


    /* priority */
    reg_addr = RTL8367B_VLAN_PPB_PRIORITY_ITEM_REG(port,index);
    bit_mask = RTL8367B_VLAN_PPB_PRIORITY_ITEM_MASK(port);
    retVal = rtl8367b_getAsicRegBits(bus, reg_addr, bit_mask, &bit_value);
    if(retVal != RT_ERR_OK)
        return retVal;

    pPpbCfg->priority = bit_value;
    return RT_ERR_OK;
}

rt_error_code_t rtk_vlan_portPvid_set(struct mii_bus *bus, rtk_port_t port, rtk_vlan_t pvid, rtk_pri_t priority)
{
    rtk_api_ret_t retVal;
    rtk_int32 i;
    rtk_uint32 j;
    rtk_uint32 k;
    rtk_uint32 index,empty_idx;
    rtk_uint32 gvidx, proc;
    rtk_uint32 bUsed, pri;
    rtl8367b_user_vlan4kentry vlan4K;
    rtl8367b_vlanconfiguser vlanMC;
    rtl8367b_protocolvlancfg ppb_vlan_cfg;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    /* vid must be 0~4095 */
    if (pvid > RTL8367B_VIDMAX)
        return RT_ERR_VLAN_VID;

    /* priority must be 0~7 */
    if (priority > RTL8367B_PRIMAX)
        return RT_ERR_VLAN_PRIORITY;


      empty_idx = 0xFFFF;

    for (i = RTL8367B_CVIDXMAX; i >= 0; i--)
    {
        if ((retVal = rtl8367b_getAsicVlanMemberConfig(bus, i, &vlanMC)) != RT_ERR_OK)
            return retVal;

        if (pvid == vlanMC.evid)
        {
            if ((retVal = rtl8367b_setAsicVlanPortBasedVID(bus, port, i, priority)) != RT_ERR_OK)
                return retVal;

            return RT_ERR_OK;
        }
        else if (vlanMC.evid == 0 && vlanMC.mbr == 0)
        {
            empty_idx = i;
        }
    }


    /*
        vid doesn't exist in 32 member configuration. Find an empty entry in
        32 member configuration, then copy entry from 4K. If 32 member configuration
        are all full, then find an entry which not used by Port-based VLAN and
        then replace it with 4K. Finally, assign the index to the port.
    */

    if (empty_idx != 0xFFFF)
    {
        vlan4K.vid = pvid;
        if ((retVal = rtl8367b_getAsicVlan4kEntry(bus, &vlan4K)) != RT_ERR_OK)
            return retVal;

        vlanMC.evid = pvid;
        vlanMC.mbr = vlan4K.mbr;
        vlanMC.fid_msti = vlan4K.fid_msti;
        vlanMC.meteridx= vlan4K.meteridx;
        vlanMC.envlanpol= vlan4K.envlanpol;
        vlanMC.vbpen = vlan4K.vbpen;
        vlanMC.vbpri = vlan4K.vbpri;

        if ((retVal = rtl8367b_setAsicVlanMemberConfig(bus, empty_idx, &vlanMC)) != RT_ERR_OK)
            return retVal;

        if ((retVal = rtl8367b_setAsicVlanPortBasedVID(bus, port,empty_idx, priority)) != RT_ERR_OK)
            return retVal;

        return RT_ERR_OK;
     }

    if ((retVal = rtl8367b_getAsic1xGuestVidx(bus, &gvidx)) != RT_ERR_OK)
        return retVal;

    /* 32 member configuration is full, found a unused entry to replace */
    for (i = 0; i <= RTL8367B_CVIDXMAX; i++)
    {
        bUsed = FALSE;

        for (j = 0; j < RTK_MAX_NUM_OF_PORT; j++)
        {
            if ((retVal = rtl8367b_getAsicVlanPortBasedVID(bus, j, &index, &pri)) != RT_ERR_OK)
                return retVal;

            if (i == index)/*index i is in use by port j*/
            {
                bUsed = TRUE;
                break;
            }

            if (i == gvidx)
            {
                if ((retVal = rtl8367b_getAsic1xProcConfig(bus, j, &proc)) != RT_ERR_OK)
                    return retVal;
                if (DOT1X_UNAUTH_GVLAN == proc )
                {
                    bUsed = TRUE;
                    break;
                }
            }

            for (k = 0; k <= RTL8367B_PROTOVLAN_GIDX_MAX; k++)
            {
                if ((retVal = rtl8367b_getAsicVlanPortAndProtocolBased(bus, port, k, &ppb_vlan_cfg)) != RT_ERR_OK)
                    return retVal;
                if (ppb_vlan_cfg.valid == TRUE && ppb_vlan_cfg.vlan_idx == i)
                {
                    bUsed = TRUE;
                    break;
                }
            }
        }

        if (FALSE == bUsed)/*found a unused index, replace it*/
        {
            vlan4K.vid = pvid;
            if ((retVal = rtl8367b_getAsicVlan4kEntry(bus, &vlan4K)) != RT_ERR_OK)
                return retVal;
            vlanMC.evid = pvid;
            vlanMC.mbr = vlan4K.mbr;
            vlanMC.fid_msti = vlan4K.fid_msti;
            vlanMC.meteridx= vlan4K.meteridx;
            vlanMC.envlanpol= vlan4K.envlanpol;
            vlanMC.vbpen = vlan4K.vbpen;
            vlanMC.vbpri = vlan4K.vbpri;
            if ((retVal = rtl8367b_setAsicVlanMemberConfig(bus, i, &vlanMC)) != RT_ERR_OK)
                return retVal;

            if ((retVal = rtl8367b_setAsicVlanPortBasedVID(bus, port, i, priority)) != RT_ERR_OK)
                return retVal;

            return RT_ERR_OK;
        }
    }

    return RT_ERR_FAILED;
}


static unsigned short rtk_vlan_init(struct mii_bus *bus)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i;
    rtl8367b_user_vlan4kentry vlan4K;
    rtl8367b_vlanconfiguser vlanMC;


    /* clean 32 VLAN member configuration */
    for (i = 0; i <= RTL8367B_CVIDXMAX; i++)
    {
        vlanMC.evid = 0;
        vlanMC.mbr = 0;
        vlanMC.fid_msti = 0;
        vlanMC.envlanpol = 0;
        vlanMC.meteridx = 0;
        vlanMC.vbpen = 0;
        vlanMC.vbpri = 0;
        if ((retVal = rtl8367b_setAsicVlanMemberConfig(bus, i, &vlanMC)) != RT_ERR_OK)
            return retVal;
    }

    /* Set a default VLAN with vid 1 to 4K table for all ports */
    memset(&vlan4K, 0, sizeof(rtl8367b_user_vlan4kentry));
    vlan4K.vid = 1;
    vlan4K.mbr = RTK_MAX_PORT_MASK;
    vlan4K.untag = RTK_MAX_PORT_MASK;
    vlan4K.fid_msti = 0;
    if ((retVal = rtl8367b_setAsicVlan4kEntry(bus, &vlan4K)) != RT_ERR_OK)
        return retVal;


    /* Also set the default VLAN to 32 member configuration index 0 */
    memset(&vlanMC, 0, sizeof(rtl8367b_vlanconfiguser));
    vlanMC.evid = 1;
    vlanMC.mbr = RTK_MAX_PORT_MASK;
    vlanMC.fid_msti = 0;
    if ((retVal = rtl8367b_setAsicVlanMemberConfig(bus, 0, &vlanMC)) != RT_ERR_OK)
            return retVal;

    /* Set all ports PVID to default VLAN and tag-mode to original */
    for (i = 0; i < RTK_MAX_NUM_OF_PORT; i++)
    {
        if ((retVal = rtl8367b_setAsicVlanPortBasedVID(bus, i, 0, 0)) != RT_ERR_OK)
            return retVal;
        if ((retVal = rtl8367b_setAsicVlanEgressTagMode(bus, i, EG_TAG_MODE_ORI)) != RT_ERR_OK)
            return retVal;
    }

    /* enable VLAN */
    if ((retVal = rtl8367b_setAsicVlanFilter(bus, TRUE)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

int gxe_board_vlan_set(struct mii_bus *bus, int lan_vid, int wlan_vid, int svip_vid)
{
    rtk_portmask_t mbrmsk, untagmsk;
    
    if(lan_vid){
        /*initialize VLAN*/
        rtk_vlan_init(bus);
        /** VLAN_0 : mebers: port5(DMW96, taged), port1(LAN)*/
        /** VLAN_1 : mebers: port5(DMW96, taged), port2(NETWORK)*/
        /** VLAN_2 : mebers: port5(DMW96, taged), port6(SVIP)*/
        if(lan_vid == wlan_vid){     /**for switch mode*/
            mbrmsk.bits[0] = 0x26;
        } else {                    /**for route mode*/
            mbrmsk.bits[0] = 0x22;
        }
        untagmsk.bits[0] = 0x5f;
        rtk_vlan_set(bus, lan_vid, mbrmsk, untagmsk, 0);
        
        if(wlan_vid && (lan_vid != wlan_vid)){
            mbrmsk.bits[0] = 0x24;
            untagmsk.bits[0] = 0x5f;
            rtk_vlan_set(bus, wlan_vid, mbrmsk, untagmsk, 0);
        }
        if(svip_vid){
            mbrmsk.bits[0] = 0x60;
            untagmsk.bits[0] = 0x5f;
            rtk_vlan_set(bus, svip_vid, mbrmsk, untagmsk, 0);
        }
        /*set PVID for port 1,2,5,6*/
        rtk_vlan_portPvid_set(bus, 1, lan_vid, 0);
        if(wlan_vid)
            rtk_vlan_portPvid_set(bus, 2, wlan_vid, 0);
        rtk_vlan_portPvid_set(bus, 5, lan_vid, 0);
        if(svip_vid)
            rtk_vlan_portPvid_set(bus, 6, svip_vid, 0);
        
    }
    return 0;
}
//EXPORT_SYMBOL(gxe_board_vlan_set);

ret_t rtl8367b_setAsicPortIsolationPermittedPortmask(struct mii_bus *bus, rtk_uint32 port,
    rtk_uint32 permitPortmask)
{
    ret_t  retVal;

    if(port >= RTL8367B_PORTNO)
        return RT_ERR_PORT_ID;

    if( permitPortmask > RTL8367B_PORTMASK)
        return RT_ERR_PORT_MASK;

    //return rtl8367b_setAsicReg(RTL8367B_PORT_ISOLATION_PORT_MASK_REG(port), permitPortmask);
    retVal = rtl8363_mdio_write_src(bus, 0, RTL8367B_PORT_ISOLATION_PORT_MASK_REG(port), permitPortmask);
    return retVal; 
}

int rtk_port_isolation_set(struct mii_bus *bus, unsigned int port, unsigned int portmask)
{
    int retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ( portmask > RTK_MAX_PORT_MASK)
        return RT_ERR_PORT_MASK;

    if ((retVal = rtl8367b_setAsicPortIsolationPermittedPortmask(bus, port, portmask)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

ret_t rtl8367b_getAsicPortIsolationPermittedPortmask(struct mii_bus *bus, rtk_uint32 port,
    rtk_uint32 *pPermitPortmask)
{
    if(port >= RTL8367B_PORTNO)
        return RT_ERR_PORT_ID;
    
   // return rtl8367b_getAsicReg(RTL8367B_PORT_ISOLATION_PORT_MASK_REG(port), pPermitPortmask);
    *pPermitPortmask = rtl8363_mdio_read_src(bus, 0, RTL8367B_PORT_ISOLATION_PORT_MASK_REG(port));
    return RT_ERR_OK;
}

int rtk_port_isolation_get(struct mii_bus *bus, unsigned int port, unsigned int *pPortmask)
{
    int retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_PORT_ID;

    if ((retVal = rtl8367b_getAsicPortIsolationPermittedPortmask(bus, port, (rtk_uint32 *)pPortmask) != RT_ERR_OK))
        return retVal;

    return RT_ERR_OK;
}

ret_t rtl8367b_setAsicCputagEnable(struct mii_bus *bus, rtk_uint32 enabled)
{
    if(enabled > 1)
        return RT_ERR_ENABLE;
    
    //return rtl8367b_setAsicRegBit(RTL8367B_REG_CPU_CTRL, RTL8367B_CPU_EN_OFFSET, enabled);
     return rtl8363_set_reg_bit(bus, 0, RTL8367B_REG_CPU_CTRL, RTL8367B_CPU_EN_OFFSET, enabled);
}

ret_t rtl8367b_setAsicCputagPortmask(struct mii_bus *bus, rtk_uint32 portmask)
{
    rtk_api_ret_t retVal;

    if(portmask > RTL8367B_PORTMASK)
        return RT_ERR_PORT_MASK;

    //return rtl8367b_setAsicReg(RTL8367B_CPU_PORT_MASK_REG, portmask);
    retVal = rtl8363_mdio_write_src(bus, 0, RTL8367B_CPU_PORT_MASK_REG, portmask);

    return retVal; 
}

int rtk_cpu_enable_set(struct mii_bus *bus, int enable)
{
    int retVal;

    if (enable >= RTK_ENABLE_END)
        return RT_ERR_ENABLE;

    if ((retVal = rtl8367b_setAsicCputagEnable(bus, enable)) != RT_ERR_OK)
        return retVal;

    if (DISABLED == enable)
    {
        if ((retVal = rtl8367b_setAsicCputagPortmask(bus, 0)) != RT_ERR_OK)
            return retVal;
    }

    return RT_ERR_OK;
}

ret_t rtl8367b_setAsicCputagTrapPort(struct mii_bus *bus, rtk_uint32 port)
{
    rtk_api_ret_t retVal;

    if(port >= RTL8367B_PORTNO)
        return RT_ERR_PORT_ID;

    //return rtl8367b_setAsicRegBits(RTL8367B_REG_CPU_CTRL, RTL8367B_CPU_TRAP_PORT_MASK, port);    
    retVal = rtl8363_set_reg_bits(bus, 0,RTL8367B_REG_CPU_CTRL, RTL8367B_CPU_TRAP_PORT_MASK, port);
    if(retVal != RT_ERR_OK)
        return retVal;
    
    return RT_ERR_OK;
}

ret_t rtl8367b_setAsicCputagInsertMode(struct mii_bus *bus, rtk_uint32 mode)
{
    rtk_api_ret_t retVal;

    if(mode >= CPUTAG_INSERT_END)
        return RT_ERR_NOT_ALLOWED;

    //return rtl8367b_setAsicRegBits(RTL8367B_REG_CPU_CTRL, RTL8367B_CPU_INSERTMODE_MASK, mode);
    retVal = rtl8363_set_reg_bits(bus, 0,RTL8367B_REG_CPU_CTRL, RTL8367B_CPU_INSERTMODE_MASK, mode);
    if(retVal != RT_ERR_OK)
        return retVal;
    
    return RT_ERR_OK;
}

rtk_api_ret_t rtk_cpu_tagPort_set(struct mii_bus *bus, rtk_port_t port, rtk_cpu_insert_t mode) 
{
    rtk_api_ret_t retVal;

    if (port > RTK_PORT_ID_MAX)
        return RT_ERR_INPUT;

    if (mode >= CPU_INSERT_END)
        return RT_ERR_INPUT;

    if ((retVal = rtl8367b_setAsicCputagPortmask(bus, 1<<port)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicCputagTrapPort(bus, port)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_setAsicCputagInsertMode(bus, mode)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}

ret_t rtl8367b_getAsicCputagPortmask(struct mii_bus *bus, rtk_uint32 *pPortmask)
{
    //return rtl8367b_getAsicReg(RTL8367B_CPU_PORT_MASK_REG, pPortmask);
    *pPortmask = rtl8363_mdio_read_src(bus, 0, RTL8367B_CPU_PORT_MASK_REG);
     return RT_ERR_OK;
}

ret_t rtl8367b_getAsicCputagTrapPort(struct mii_bus *bus, rtk_uint32 *pPort)
{
    return rtl8367b_getAsicRegBits(bus, RTL8367B_REG_CPU_CTRL, RTL8367B_CPU_TRAP_PORT_MASK, pPort);
}

ret_t rtl8367b_getAsicCputagInsertMode(struct mii_bus *bus, rtk_uint32 *pMode)
{
    return rtl8367b_getAsicRegBits(bus, RTL8367B_REG_CPU_CTRL, RTL8367B_CPU_INSERTMODE_MASK, pMode);
}

rtk_api_ret_t rtk_cpu_tagPort_get(struct mii_bus *bus, rtk_port_t *pPort, rtk_cpu_insert_t *pMode)
{
    rtk_api_ret_t retVal;
    rtk_uint32 i, pmsk, port; 

    if ((retVal = rtl8367b_getAsicCputagPortmask(bus, &pmsk)) != RT_ERR_OK)
        return retVal;

    if ((retVal = rtl8367b_getAsicCputagTrapPort(bus, &port)) != RT_ERR_OK)
        return retVal;

    for (i = 0; i< RTK_MAX_NUM_OF_PORT; i++)
    {
        if ((pmsk&(1<<i))!=0)
        {     
            if (i==port)
                *pPort = port; 
            else  
                return RT_ERR_FAILED;
        }     
    }

    if ((retVal = rtl8367b_getAsicCputagInsertMode(bus, pMode)) != RT_ERR_OK)
        return retVal;

    return RT_ERR_OK;
}
/**
smode: 0  ----disable
             1  ---- CPU_INSERT_TO_ALL = 0, 
             2  ---- CPU_INSERT_TO_TRAPPING = 1,
             3  ---- CPU_INSERT_TO_NONE = 2
*/
int gxe_board_cpuport_set(struct mii_bus *bus, int smode)
{
    int ret;
    int enable = 0;
    
    if(smode>0)
        enable = 1;
    
    ret = rtk_cpu_enable_set(bus, enable);
    if(ret) {
        return ret;
    }
    
    if(!enable)
        return 0;
    /*set port 5 as cpu-port for gxeboard*/
    if(smode<1 || smode>CPU_INSERT_END)
        return -1;
    
    ret = rtk_cpu_tagPort_set(bus, 5, smode-1);
    
    return ret;
}

/**return smode*/
int gxe_board_cpuport_get(struct mii_bus *bus)
{
    unsigned int port;
    unsigned int mode;
    int ret;
    
    ret = rtk_cpu_tagPort_get(bus, &port, &mode);
    if(ret) {
        printk("get CPU Tag Port get error!!\n");
        return -1;
    }
    if(port != 5 ) {
        printk("CPU Tag Port not set or invalid cpu port for gxe!!\n");
        return -1;
    }
    
    return mode+1;
}


/***************************************************************/

static int init_rtl8363(struct mii_bus *bus)
{
	int i=0, len=0;
	unsigned short (*init_para)[2];
	unsigned int data;
    
	rtl8363_mdio_write_src(bus, 0, RTL_REG_MAGIC_ID, 0x0249);
	data = rtl8363_mdio_read_src(bus, 0, RTL_REG_CHIP_VER);
	if(data & 0xf000)
	{
		init_para = ChipData01;
		len = (sizeof(ChipData01))/(sizeof(unsigned short) * 2);
	}
	else
	{
		init_para = ChipData00;
		len = (sizeof(ChipData00))/(sizeof(unsigned short) * 2);
	}
	for(i = 0; i < len; i++)
	{
		rtl8363_mdio_write_src(bus, 0, init_para[i][0], init_para[i][1] );
	}

	/*set ETH LED link active mode*/
	rtk_set_led(bus, 1, LEDCONF_LINK_ACT);
	rtk_set_led(bus, 2, LEDCONF_LINK_ACT);

	/*set ext port 2 as RGMII for SVIP ygzhang@201206181509*/
        data = rtl8363_mdio_read_src(bus, 0, RTL_REG_DIGITAL_INTERFACE_SELECT);
        data &= ~(RTL8367B_SELECT_GMII_1_MASK);
        data |= EXT_RGMII<<RTL8367B_SELECT_GMII_1_OFFSET;
        rtl8363_mdio_write_src(bus, 0, RTL_REG_DIGITAL_INTERFACE_SELECT, data);

	/*force link*/
	data = rtl8363_mdio_read_src(bus, 0, RTL8367B_REG_DIGITAL_INTERFACE1_FORCE);
	printk("force: %04x\n", data);
	//data &= ~(RTL8367B_RGMII_1_FORCE_MASK);
        //data |= 0xfff<<RTL8367B_RGMII_1_FORCE_OFFSET;
	data = 0x1076;
        rtl8363_mdio_write_src(bus, 0, RTL8367B_REG_DIGITAL_INTERFACE1_FORCE, data);

	/*set tx rx delay*/
	rtk_port_rgmii_delay_set(bus, 1, 1, 0);
#ifdef CONFIG_GXE_STMMAC_VETH
#if CONFIG_RTL8363_CPUPORT
    if(gxe_board_cpuport_set(bus, 1))
        printk("CPU PORT Set Error!!\n");
    if(rtk_port_isolation_set(bus, 1, 0x20))
        printk("PORT1(LAN) isolation Error(portmask 0x20)!!\n");
    if(rtk_port_isolation_set(bus, 2, 0x20))
        printk("PORT2(WAN) isolation Error(portmask 0x20)!!\n");
    if(rtk_port_isolation_set(bus, 6, 0x20))
        printk("PORT6(SVIP) isolation Error(portmask 0x20)!!\n");
#else
    gxe_board_vlan_set(bus, LAN_VID, WLAN_VID, SVIP_VID);
#endif
#endif    
    return 0;
}

static int rtl8363_mdio_read2 (struct mii_bus *bus, int mii_id, int regnum)
{
	int val = 0;
#ifndef CONFIG_GXE_STMMAC_VETH
    unsigned int i;

    if(mii_id) return 0xFFFF;
  
    for(i=0; i<SUPPORT_MAX_PHY; i++)
    {
         val |= rtl8363_mdio_read(bus, i, regnum);
    }
    return val;
#else
	if(mii_id<SUPPORT_MAX_PHY && mii_id >=0) {
        val |= rtl8363_mdio_read(bus, mii_id, regnum);
        return val;
    } else {
        return 0xFFFF;
    }
#endif
}

static int rtl8363_mdio_write2(struct mii_bus *bus, int mii_id, int regnum, unsigned short value)
{
	int rval = 0;
#ifndef CONFIG_GXE_STMMAC_VETH
    unsigned int i;
    for(i=0; i<SUPPORT_MAX_PHY; i++)
    {
        rval |= rtl8363_mdio_write(bus, i, regnum, value);
    }
    return rval;
#else
    if(mii_id<SUPPORT_MAX_PHY && mii_id >=0 )
        rval |= rtl8363_mdio_write(bus, mii_id, regnum, value);
    return rval;
#endif
}

