#!/bin/sh

export PATH=$PATH:/opt/codesourcery/bin/

#CORES=1
CORES=$((2*$(cat /proc/cpuinfo | grep -c processor)))

SKIP_CFG_UPDATE=1
if [ ! -f .config ]; then
	cp Config_gxe5124 .config
	SKIP_CFG_UPDATE=0
fi

make -j${CORES} uImage CROSS_COMPILE=arm-none-linux-gnueabi-

if [ ${SKIP_CFG_UPDATE} ]; then
	cp .config Config_gxe5124
fi

cp -v arch/arm/boot/uImage core.gxe5124.dev

./copy_kernel.sh
