/*
 *  linux/arch/arm/mach-dmw/ramsem.c
 *
 *  Copyright (C) 2011 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/module.h>
#include <asm/system.h>
#include <mach/ramsem.h>

struct ram_sem {
	volatile u32 enter_app;
	volatile u32 enter_css;
	volatile u32 number_app;
	volatile u32 number_css;
};

void ram_sem_init(struct ram_sem *sem)
{
	sem->enter_app = 0;
	sem->enter_css = 0;
	sem->number_app = 0;
	sem->number_css = 0;
	mb();
}
EXPORT_SYMBOL(ram_sem_init);

void ram_sem_lock(struct ram_sem *sem)
{
	unsigned long tmp;

	sem->enter_app = 1;
	mb();
	sem->number_app = 1 + sem->number_css;
	mb();
	sem->enter_app = 0;
	mb();

	while (sem->enter_css)
		; /* nothing */

	do {
		rmb();
		tmp = sem->number_css;
	} while ((tmp != 0) && (tmp < sem->number_app));
}
EXPORT_SYMBOL(ram_sem_lock);

void ram_sem_unlock(struct ram_sem *sem)
{
	sem->number_app = 0;
	mb();
}
EXPORT_SYMBOL(ram_sem_unlock);

