/*
 *  linux/arch/arm/mach-dmw/pm.h
 *
 *  Copyright (C) 2011 DSP Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __MACH_PM_H
#define __MACH_PM_H

#define SLEEP_DDR_MODE_1	0x04
#define SLEEP_DDR_MODE_2	0x03
#define SLEEP_DDR_MODE_3	0x02
#define SLEEP_DDR_MODE_4	0x01
#define SLEEP_DDR_MODE(_mode)	((_mode) & 0x0f)

#define SLEEP_CHECK_BM		0x0100	/* Don't enter if a bus master is active */
#define SLEEP_DDR_PLL_OFF	0x0200	/* Switch off PLL3 (implies manual entry) */
#define SLEEP_CPU_SLOW		0x0400	/* Run CPU from 12MHz */

#define SLEEP_QUIRK_DIS_INP	0x10000	/* Disable input buffer in self refresh */

#ifndef __ASSEMBLER__

struct dmw_pm_pdata {
	unsigned overdrive_gpio;
};

extern int clk_active_bm_cnt; /* Number of active bus masters */
extern int clk_active_io_cnt; /* Number of active IO devices */
void dmw_clk_print_active(void);

extern void
dmw_sleep_selfrefresh(int flags, void *denali_base, u32 cmu_base);

#ifdef CONFIG_PM
void dmw_dram_request(void);
void dmw_dram_release(void);
int dmw_dram_reqlevel(void);
#else
static inline void dmw_dram_request(void) { }
static inline void dmw_dram_release(void) { }
static inline int dmw_dram_reqlevel(void) {  return 0; }
#endif

#endif

#endif
