/*
 *  arch/arm/mach-dmw/include/mach/powerdomain.h
 *
 *  Copyright (C) 2011 DSP Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __MACH_POWERDOMAIN_H
#define __MACH_POWERDOMAIN_H

#include <mach/platform.h>

#ifdef CONFIG_DMW_PWRDOM
void dmw_pwrdom_enable(int domain);
void dmw_pwrdom_disable(int domain);
#else
#define dmw_pwrdom_enable(domain)  do { } while (0)
#define dmw_pwrdom_disable(domain) do { } while (0)
#endif

struct dmw_pwrdom_pdata {
	int domain;
	char *name;
};

#endif
