#ifndef __GXP22XX_H_
#define __GXP22XX_H_

/*
 gxp22xx nand flash memory map@20120217

0x00000000 *************
                  *u-boot         * 2M
0x00200000 *************
                  *u-boot env   * 1M
0x00300000 *************
                  *factory         * 2M
0x00500000 ************* 
                  *kernel          * 4M
0x00900000 ************* 
                 *recovery        * 4M
0x00d00000 ************* 
                  *seghdr0        * 512K
0x00d80000 ************* 
                  *nvram          * 512K
0x00e00000 ************* 
                  *seghdr1        * 512K
0x00e80000 ************* 
                  *system         * 268M-512K
0x11a00000 *************
                  *seghdr2        * 512K
0x11a80000 ************* 
                  *cache           * 80M-512K
0x16a00000 ************* 
                  *seghdr3        * 512K
0x16a80000 ************* 
                  *userdata       * 150M-512K
0x20000000 ************* 
*/

#define MTD_SIZE_TOTAL		0x20000000/* 512M */
#define MTD_SIZE_UBOOT		SZ_2M
#define MTD_SIZE_KERNEL	SZ_4M
#define MTD_SIZE_RECOVERY	SZ_4M
#define MTD_SIZE_NVRAM		SZ_512K
#define MTD_SIZE_SEGHDR	SZ_512K
#define MTD_SIZE_SYSTEM	(0x10c00000-SZ_512K)/* 268M-512K */
#define MTD_SIZE_CACHE		(0x05000000-SZ_512K)/* 80M-512K */

#define MTD_OFFSET_UBOOT	0x0
#define MTD_OFFSET_KENEL	0x00500000
#define MTD_OFFSET_RECOVERY	(MTD_OFFSET_KENEL+MTD_SIZE_KERNEL)
#define MTD_OFFSET_SEGHDR0	(MTD_OFFSET_RECOVERY+MTD_SIZE_RECOVERY)
#define MTD_OFFSET_NVRAM		(MTD_OFFSET_SEGHDR0+MTD_SIZE_SEGHDR)
#define MTD_OFFSET_SEGHDR1	(MTD_OFFSET_NVRAM+MTD_SIZE_NVRAM)
#define MTD_OFFSET_SYSTEM		(MTD_OFFSET_SEGHDR1+MTD_SIZE_SEGHDR)
#define MTD_OFFSET_SEGHDR2	(MTD_OFFSET_SYSTEM+MTD_SIZE_SYSTEM)
#define MTD_OFFSET_CACHE		(MTD_OFFSET_SEGHDR2+MTD_SIZE_SEGHDR)
#define MTD_OFFSET_SEGHDR3	(MTD_OFFSET_CACHE+MTD_SIZE_CACHE)
#define MTD_OFFSET_USERDATA	(MTD_OFFSET_SEGHDR3+MTD_SIZE_SEGHDR)
#define MTD_SIZE_USERDATA		(MTD_SIZE_TOTAL-MTD_OFFSET_USERDATA)

struct gxp22xx_nand_pdata
{
	struct mtd_partition *parts;
	int nr_parts;
};

typedef struct seg_header {
	uint32_t size_used;
    uint32_t size;
    uint16_t checksum;
    uint16_t seg_mark;
    uint32_t idt_len;
	uint32_t signature;
    uint32_t version;
    uint32_t date;
    uint16_t id;
    uint16_t hw_id;
}seg_header_t;

#define SEG_UBOOT_STR		"u-boot"
#define SEG_KERNEL_STR		"kernel"
#define SEG_SYSTEM_STR		"system"
#define SEG_RECOVERY_STR	"recovery"

#define MTD_SEGHDR_COUNT		4
typedef struct
{
	const  char *name;
	unsigned long start[MTD_SEGHDR_COUNT];
}prov_t;

#define GS_STORAGE_EMMC	0x20120329
#define GS_STORAGE_FLASH	0x20111214
int gs_get_storage(void);

#endif
