/*
 * arch/arm/mach-dmw/include/mach/gpio.h
 *
 * DW GPIO wrappers for arch-neutral GPIO calls
 *
 * (c) 2011, DSP Group Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef __ASM_ARCH_DMW_GPIO_H
#define __ASM_ARCH_DMW_GPIO_H

#include <linux/types.h>
#include <linux/errno.h>
#include <mach/hardware.h>
#include <mach/irqs.h>

/* Request a GPIO for usage, will BUG() if this GPIO is already in use */
int gpio_request(unsigned gpio, char *label);
/* Free a GPIO, even not taken GPIOs may be freed */
void gpio_free(unsigned gpio);

/* Set the output direction and the correct default value */
int gpio_direction_input(unsigned gpio);
int gpio_direction_output(unsigned gpio, int value);

/* Query the value of a GPIO */
int gpio_get_value(unsigned gpio);
/* Set the value of the GPIO */
void gpio_set_value(unsigned gpio, int value);

/* Some inline functions to map the cansleep ones */
static inline int gpio_cansleep(unsigned gpio)
{ 
	return 0;
}

static inline int gpio_get_value_cansleep(unsigned gpio)
{
	return gpio_get_value(gpio);
}

static inline void gpio_set_value_cansleep(unsigned gpio, int value)
{
	gpio_set_value(gpio, value);
}

static inline int gpio_is_valid(int number)
{
        return 1;
}

/* Internal representation of the GPIO */
struct gpio_usage {
	u32 usage;
	u32 __iomem *regs;
	char* labels[32];
	/* The real hardware registers */
	u32 data, data_set, data_clr;
	u32 direction, direction_out, direction_in;
	u32 enable, enable_set, enable_clr;
	u32 pull_ctrl, pull_en, pull_dis, pull_type, pull_up, pull_down;
	u32 keep, keep_en, keep_dis;
	u32 od, od_set, od_clr;
	u32 pins;
};

/* The needed defines */
#define GPIO_PORTA(x) (((DMW_GPIO_AGP_DATA >> 2) << 8) + ((x)&0xFF))
#define GPIO_PORTB(x) (((DMW_GPIO_BGP_DATA >> 2) << 8) + ((x)&0xFF))
#define GPIO_PORTC(x) (((DMW_GPIO_CGP_DATA >> 2) << 8) + ((x)&0xFF))
#define GPIO_PORTD(x) (((DMW_GPIO_DGP_DATA >> 2) << 8) + ((x)&0xFF))
#define GPIO_PORTE(x) (((DMW_GPIO_EGP_DATA >> 2) << 8) + ((x)&0xFF))
#define GPIO_PORTF(x) (((DMW_GPIO_FGP_DATA >> 2) << 8) + ((x)&0xFF))
#define GPIO_PORTG(x) (((DMW_GPIO_GGP_DATA >> 2) << 8) + ((x)&0xFF))

/* Extended API */
void gpio_set_enable(unsigned gpio, int value);
int  gpio_get_enable(unsigned gpio);
void gpio_set_pull_enable(unsigned gpio, int value);
int  gpio_get_pull_enable(unsigned gpio);
void gpio_set_pull_selection(unsigned gpio, int value);
int  gpio_get_pull_selection(unsigned gpio);
void gpio_set_opendrain(unsigned gpio, int value);
int  gpio_get_opendrain(unsigned gpio);
void gpio_set_keeper(unsigned gpio, int value);
int  gpio_get_keeper(unsigned gpio);
void gpio_dump(void);
int  gpio_get_direction(unsigned gpio);
int  gpio_to_irq(unsigned int gpio);

#endif /* __ASM_ARCH_DMW_GPIO_H */
