/*
 *  css.h
 *
 *  Copyright (C) 2011 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __CSS_H
#define __CSS_H

#include <mach/ramsem.h>

#define CSS_MAGIC			0xDADADADA
#define CSS_IMG_VERSION			0x00010000

/* css resource indices */
#define CSS_AHBRAM				0
#define CSS_ITCM				1
#define CSS_DTCM				2

struct boot_config {
	unsigned long dram_addr;
	unsigned long dram_size;
	struct ram_sem *cmu_sem;
};

struct css_img_hdr {
	unsigned long magic;
	unsigned long parts;
	unsigned long dc_addr;
	unsigned long boot_config;
	unsigned long elf_md5_addr;
	unsigned long img_version;
	char info[52];
} __attribute__((__packed__));

struct css_part_hdr {
	unsigned long size;
	unsigned long rsize;
	unsigned long dest_addr;
	unsigned char md5[16];
} __attribute__((__packed__));

typedef void (*css_reset_fp_t)(int enable);

struct css_pdata {
	css_reset_fp_t reset_arm;
	css_reset_fp_t reset_css;
	css_reset_fp_t reset_etm;
};

#endif
