#ifndef __ASM_MACH_CLKDEV_H
#define __ASM_MACH_CLKDEV_H

#include <linux/types.h>
#include <linux/list.h>

#define FLAG_ENABLE		0x0001 /* Statically enable at startup */
#define FLAG_DONT_DISABLE	0x0002 /* Don't disable at startup */
#define FLAG_BM			0x0010 /* Device is a bus master. Prevents DRAM self refresh */
#define FLAG_IO			0x0020 /* IO device. Prevents PLL1 power down. */

#define FLAG_REPARENTING	0x0100 /* Clock's parent is about to be changed */

struct clk {
	const char		*name;
	int			flags;
	unsigned long		rate;

	union {
		struct {
			u8	bit;	/* Clock enable bit */
			u8	reg;	/* Divider register */
			u8	shift;	/* Divider field offset */
			u8	size;	/* divider field size */
		} gate;

		struct {
			u32	round_rate;
			u16	round_setting;
			u8	reg;
			u8	waitflag;
		} pll;
	} priv;

	struct clk		*parent;
	struct list_head	childs;
	struct list_head	child_node;

	int			refcnt;
	int			getcnt;

	struct clk *		(*get_parent)(struct clk *clk);
	int			(*set_parent)(struct clk *clk, struct clk *parent);
	int			(*get_on_off)(struct clk *clk);
	int			(*set_on_off)(struct clk *clk, int on);
	unsigned long		(*get_rate)(struct clk *clk);
	int			(*set_rate)(struct clk *clk, unsigned long rate);
	long			(*round_rate)(struct clk *clk, unsigned long rate);
};

#define __clk_get(clk) ({ clk->getcnt++; 1; })
#define __clk_put(clk) do { clk->getcnt--; } while (0)

#endif
