/*
 *  linux/arch/arm/mach-dw/gpio-setup.c
 *
 *  Copyright (C) 2010, DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/gpio.h>
#include <mach/hardware.h>

#include "gpio-setup.h"

__init void dmw_gpio_setup(struct gpio_setup_t *setup, unsigned int size)
{
	if (!setup)
		return;

	for ( ; size-- ; setup++ ) {
		int gpio;

		switch (setup->port) {
		case 0: gpio = GPIO_PORTA(setup->idx); break;
		case 1: gpio = GPIO_PORTB(setup->idx); break;
		case 2: gpio = GPIO_PORTC(setup->idx); break;
		case 3: gpio = GPIO_PORTD(setup->idx); break;
		case 4: gpio = GPIO_PORTE(setup->idx); break;
		case 5: gpio = GPIO_PORTF(setup->idx); break;
		case 6: gpio = GPIO_PORTG(setup->idx); break;
		default: return;
		}

		if (setup->pull != GPIO_PULL_DISABLE)
			gpio_set_pull_selection(gpio, setup->pull);

		gpio_set_pull_enable(gpio, setup->pull != GPIO_PULL_DISABLE);

		if (setup->state != GPIO_DISABLE) {
			if (setup->state == GPIO_IN)
				gpio_direction_input(gpio);
			else {
				gpio_direction_output(gpio, setup->state == GPIO_OUT_HIGH);
				if (setup->pull != GPIO_PULL_DISABLE)
					printk(KERN_WARNING "%cGPIO%d: pull-%s and "
						"output enabled simultaneously!\n",
						'A' + setup->port, setup->idx,
						setup->pull ? "up" : "down");
			}

			gpio_set_enable(gpio, 1);
		} else {
			gpio_set_enable(gpio, 0);
		}
	}
}
