#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/platform_device.h>

#include "coma.h"
#include "coma-debug.h"
#include "coma-dua.h"
#include "coma-eeprom.h"
#include "coma-iwu.h"
#include "coma-tdm.h"
#include "coma-datahandler.h"
#include "coma-voice.h"
#include "coma-mmi.h"
#include "coma-mch.h"
#include "coma-dsr.h"
#include "coma-config.h"
#include "coma-ss7.h"

#define DRIVER_NAME	"coma"

static int coma_probe(struct platform_device *pdev)
{
	int ret;
	struct coma_config *dc = (struct coma_config *)pdev->dev.platform_data;
	if (dc == NULL) {
		dev_err(&pdev->dev, "no DC configuration set\n");
		ret = -ENODEV;
		goto out_err;
	}

	ret = coma_setup(pdev, dc->fifo_l2c, dc->fifo_c2l);

#ifdef CONFIG_CSS_DEBUG
	debug_service_init();
#endif

#ifdef CONFIG_CSS_DUA
	dua_service_init();
#endif

#ifdef CONFIG_CSS_IWU
	iwu_service_init();
#endif

#ifdef CONFIG_CSS_EEPROM
	eeprom_service_init();
#endif

#ifdef CONFIG_CSS_TDM
	tdm_service_init();
#endif

#ifdef CONFIG_CSS_DATAHANDLER
	datahandler_init();
#endif

#ifdef CONFIG_CSS_VOICE
	voice_init();
#endif

#ifdef CONFIG_CSS_CONFIG
	config_service_init();
#endif

#ifdef CONFIG_CSS_SS7
	ss7_service_init();
#endif

#ifdef CONFIG_CSS_MCH
	mch_service_init();
#endif

#ifdef CONFIG_CSS_DSR
	dsr_service_init();
#endif

#ifdef CONFIG_CSS_MMI
	mmi_service_init();
#endif

      out_err:
	return ret;
}

static int coma_remove(struct platform_device *pdev)
{
#ifdef CONFIG_CSS_DEBUG
	debug_service_exit();
#endif

#ifdef CONFIG_CSS_DUA
	dua_service_exit();
#endif

#ifdef CONFIG_CSS_IWU
	iwu_service_exit();
#endif

#ifdef CONFIG_CSS_EEPROM
	eeprom_service_exit();
#endif

#ifdef CONFIG_CSS_DATAHANDLER
	datahandler_exit();
#endif

#ifdef CONFIG_CSS_VOICE
	voice_exit();
#endif

#ifdef CONFIG_CSS_CONFIG
	config_service_exit();
#endif

#ifdef CONFIG_CSS_SS7
	ss7_service_exit();
#endif

#ifdef CONFIG_CSS_MCH
	mch_service_exit();
#endif

#ifdef CONFIG_CSS_DSR
	dsr_service_exit();
#endif

#ifdef CONFIG_CSS_MMI
	mmi_service_exit();
#endif

#ifdef CONFIG_CSS_TDM
	tdm_service_exit();
#endif

	coma_release(pdev);
	return 0;
}

static struct platform_driver coma_driver = {
	.driver = {
		   .name = DRIVER_NAME,
		   .owner = THIS_MODULE,
		   },
	.probe = coma_probe,
	.remove = coma_remove,
};

static int __init coma_drv_init(void)
{
	return platform_driver_register(&coma_driver);
}

module_init(coma_drv_init);

static void __exit coma_drv_exit(void)
{
	platform_driver_unregister(&coma_driver);
}

module_exit(coma_drv_exit);
