/*
 * arch/arm/mach-dmw/css/cmsg-voice.h - cordless messages / voice (RTP)
 *
 * Cordless messages are used to exchange commands and data between Linux and
 * cordless over cfifos. They consist of a type specifier, an optional parameter
 * block and optional additional payload.
 *
 * Copyright (C) 2009 DSP Group Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

 /* == HISTORY =================================================================
 *
 * Name         Date        Ver   Action
 * --------------------------------------------------------------------
 *  tcmc_awe  28-Jan-2010        initial 
 *  rhulagur    23-Feb-2010  1    Merging to 823

 */

#ifndef CMSG_VOICE_H
#define CMSG_VOICE_H

#include "cmsg.h"
#define MAX_NUM_OF_CODEC 6
#define MAX_DYNAMIC_CODEC_LEN 15

enum cmsg_voice_types {
	CMSG_VOICE_REQUEST_GET_CHAN = 0,
	CMSG_VOICE_REPLY_GET_CHAN,
	CMSG_VOICE_REQUEST_SET_CHAN_FIFOS,
	CMSG_VOICE_REPLY_SET_CHAN_FIFOS,
	CMSG_VOICE_REQUEST_START_CHAN,
	CMSG_VOICE_REPLY_START_CHAN,
	CMSG_VOICE_REQUEST_STOP_CHAN,
	CMSG_VOICE_REPLY_STOP_CHAN,
	CMSG_VOICE_REQUEST_FREE_CHAN,
	CMSG_VOICE_REPLY_FREE_CHAN,
	CMSG_VOICE_REQUEST_SEND_DTMF,
	CMSG_VOICE_REPLY_SEND_DTMF,
	CMSG_VOICE_RECEIVE_DTMF,
	CMSG_VOICE_REQUEST_START_RTCP,
	CMSG_VOICE_REPLY_START_RTCP,
	CMSG_VOICE_REQUEST_STOP_RTCP,
	CMSG_VOICE_REPLY_STOP_RTCP,
	CMSG_VOICE_REQUEST_REPORT_RTCP,
	CMSG_VOICE_REPLY_REPORT_RTCP,
	CMSG_VOICE_REQUEST_UPDATE_CHAN,
	CMSG_VOICE_REPLY_UPDATE_CHAN,
	CMSG_VOICE_DATA,
};

struct rtp_cng_opts {
	char level_rx;
	int  mode_rx;
	char level_tx;
	int  mode_tx;
	int  max_sid_update;
	int  vad_detect_level;
	int  vad_hangover;
};

struct rtp_jib_config {
	int max_len; /* in 10ms units */
	int min_len; /* in 10ms units */
	enum rtp_jib_type type;
};

struct rx_codec_lst
{  
   char CodecStr[MAX_DYNAMIC_CODEC_LEN];
   char rx_pt;
};

union cmsg_voice_params {
	/* CMSG_REQUEST_GET_CHAN */
	struct  request_get_chan {
		int id;
	} request_get_chan;

	/* CMSG_REPLY_GET_CHAN */
	struct  reply_get_chan {
		int result;
	} reply_get_chan;

	/* CMSG_REQUEST_SET_CHAN_FIFOS */
	struct  request_set_chan_fifos {
		int id;
		struct cfifo *enc;
		struct cfifo *dec;
	} request_set_chan_fifos;

	/* CMSG_REPLY_SET_CHAN_FIFOS */
	struct  reply_set_chan_fifos {
		int result;
	} reply_set_chan_fifos;

	/* CMSG_REQUEST_START_CHAN */
	struct  request_start_chan {
		int id;
		char rx_codec_event;
		char tx_codec;
		char tx_codec_event;
		int duration;
		unsigned int current_time;
		int opts;
		char CodecStr[MAX_DYNAMIC_CODEC_LEN];
		int Timestamp;
		int ssrc;
		VOICE_MODE_UPDATE audio_mode;
		struct rtp_cng_opts cng;
		struct rtp_jib_config jb;
		struct rx_codec_lst rx_list[MAX_NUM_OF_CODEC];
        	uint32_t dtmf2833numEndPackets;
		VOICE_MEDIA_LOOP_LEVEL media_loop_level;
		struct t38_voice_config t38_cfg;			
	} request_start_chan;

	/* CMSG_REPLY_START_CHAN */
	struct  reply_start_chan {
		int result;
	} reply_start_chan;

	/* CMSG_REQUEST_STOP_CHAN */
	struct  request_stop_chan {
		int id;
	} request_stop_chan;

	/* CMSG_REPLY_STOP_CHAN */
	struct  reply_stop_chan {
		int result;
	} reply_stop_chan;

	/* CMSG_REQUEST_FREE_CHAN */
	struct  request_free_chan {
		int id;
	} request_free_chan;

	/* CMSG_REPLY_FREE_CHAN */
	struct  reply_free_chan {
		int result;
	} reply_free_chan;

	/* CMSG_REQUEST_SEND_DTMF */
	struct request_send_dtmf {
		int id;
		int status;
		int event;
		int volume;
		int duration;
		int EvtDuration;
		int MaxEvtDuration;
	} request_send_dtmf;

	/* CMSG_REPLY_SEND_DTMF */
	struct reply_send_dtmf {
		int result;
	} reply_send_dtmf;

	/* CMSG_RECEIVE_DTMF */
	struct receive_dtmf {
		int id;
		int status;
		int event;
		int volume;
		int duration;
	} receive_dtmf;
	
	/* CMSG_REQUEST_START_RTCP */
	struct request_start_rtcp {
		int id;
		char sdesItem[MAX_SDES_ITEMS][MAX_SDES_VAL_LEN];
		int rtcp_interval;
		int opts;
	} request_start_rtcp;

	/* CMSG_REPLY_START_RTCP */
	struct reply_start_rtcp {
		int result;
	} reply_start_rtcp;

	/* CMSG_REQUEST_STOP_RTCP */
	struct request_stop_rtcp {
		int id;
	} request_stop_rtcp;

	/* CMSG_REPLY_STOP_RTCP */
	struct reply_stop_rtcp {
		int result;
	} reply_stop_rtcp;

	/* CMSG_REQUEST_REPORT_RTCP */
	struct request_report_rtcp {
		int id;
	} request_report_rtcp;

	/* CMSG_REPLY_REPORT_RTCP */
	struct reply_report_rtcp {
		int result;
	} reply_report_rtcp;

	/* CMSG_REQUEST_UPDATE_CHAN */
	struct  request_update_chan {
		int id;
		char rx_codec_event;
		char tx_codec;
		char tx_codec_event;
		int duration;
		unsigned int current_time;
		int opts;
		char CodecStr[MAX_DYNAMIC_CODEC_LEN];
		int Timestamp;
		int ssrc;
		struct rtp_cng_opts cng;
		struct rtp_jib_config jb;
		struct rx_codec_lst rx_list[MAX_NUM_OF_CODEC];
		VOICE_MODE_UPDATE audio_mode;		
		uint32_t dtmf2833numEndPackets;
	} request_update_chan;

	/* CMSG_REPLY_UPDATE_CHAN */
	struct  reply_update_chan {
		int result;
	} reply_update_chan;
	
};

#endif /* CMSG_VOICE_H */
