/*
 *  linux/arch/arm/mach-dmw/board-gsmain.c
 *
 *  Copyright (C) 2011 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/interrupt.h>
#include <linux/cpufreq.h>
#include <linux/delay.h>
#include <linux/dma-mapping.h>
#include <linux/dwf_platform.h>
#include <linux/i2c-pnx.h>
#include <linux/i2c.h>
#include <linux/init.h>
#include <linux/mfd/core.h>
#include <linux/mmc/dw_mmc.h>
#include <linux/mmc/host.h>
#include <linux/platform_device.h>
#include <linux/regulator/machine.h>
#include <linux/spi/spi.h>
#include <linux/spi/spi_dmw96.h>
#include <linux/usb/dwc_otg.h>
#include <linux/stmmac.h>
#include <mach/cpufreq.h>
#include <mach/gpio.h>
#include <mach/irqs.h>
#include <mach/keypad.h>
#include <mach/reset.h>

#include <sound/si3050.h>
#include <sound/dmw-tdm.h>
#include <sound/dmw-boards.h>

#include <linux/leds.h>
#if defined(CONFIG_USB_ANDROID) || defined(CONFIG_USB_ANDROID_MODULE)
#include <linux/usb/android_composite.h>
#endif
#include <linux/mtd/mtd.h>
#include <linux/mtd/partitions.h>
#include <mach/gxp22xx.h>

#include "devices.h"
#include "gpio-setup.h"
#include "pm.h"

//#ifdef DEBUG_GPIOS

#define OVERDRIVE_GPIO (GPIO_PORTG(9))

static __initdata struct gpio_setup_t gpio_setup_default[] = {
	GPIO_SETUP(A, 0,  GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD0 */
	GPIO_SETUP(A, 1,  GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD1 */
	GPIO_SETUP(A, 2,  GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD2 */
	GPIO_SETUP(A, 3,  GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD3 */
	GPIO_SETUP(A, 4,  GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD4 */
	GPIO_SETUP(A, 5,  GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD5 */
	GPIO_SETUP(A, 6,  GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD6 */
	GPIO_SETUP(A, 7,  GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD7 */
	GPIO_SETUP(A, 8,  GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD8 */
	GPIO_SETUP(A, 9,  GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD9 */
	GPIO_SETUP(A, 10, GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD10*/
	GPIO_SETUP(A, 11, GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD11 */
	GPIO_SETUP(A, 12, GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD12 */
	GPIO_SETUP(A, 13, GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD13 */
	GPIO_SETUP(A, 14, GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD14 */
	GPIO_SETUP(A, 15, GPIO_DISABLE,  GPIO_PULL_UP      ), /* NFL - NFLD15 */
	GPIO_SETUP(A, 16, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* NFL - NFLWR */
	GPIO_SETUP(A, 17, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* NFL - NFLRD */
	GPIO_SETUP(A, 20, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* NFL - NFLALE */
	GPIO_SETUP(A, 21, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* NFL - NFLCS0 */

	GPIO_SETUP(B, 0,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* UART1 - TX */
	GPIO_SETUP(B, 1,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* UART1 - RX */
	GPIO_SETUP(B, 4,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* UART2 - TX */
	GPIO_SETUP(B, 5,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* UART2 - RX */
	GPIO_SETUP(B, 8,  GPIO_DISABLE,  GPIO_PULL_UP      ), /* UART3 - TX */
	GPIO_SETUP(B, 9,  GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* UART3 - RX */

	GPIO_SETUP(B, 12, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM1 - SCLK */
	GPIO_SETUP(B, 13, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM1 - Fsync */
	GPIO_SETUP(B, 14, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* TDM1 - TX */
	GPIO_SETUP(B, 15, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM1 - RX */
	GPIO_SETUP(B, 16, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM2 - SCLK */
	GPIO_SETUP(B, 17, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM2 - Fsync */
	GPIO_SETUP(B, 18, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* TDM2 - TX */
	GPIO_SETUP(B, 19, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM2 - RX */
	GPIO_SETUP(B, 20, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM3 - SCLK */
	GPIO_SETUP(B, 21, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM3 - Fsync */
	GPIO_SETUP(B, 22, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* TDM3 - TX */
	GPIO_SETUP(B, 23, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* TDM3 - RX */

	GPIO_SETUP(B, 28, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* SPI1 - DO */
	GPIO_SETUP(B, 29, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* SPI1 - DI */
	GPIO_SETUP(B, 30, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* SPI1 - CS1 */
	GPIO_SETUP(B, 31, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* SPI1 - CK */
	GPIO_SETUP(G, 21, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* SPI1 - CS2 */

	GPIO_SETUP(B, 24, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* SPI2 - DO */
	GPIO_SETUP(B, 25, GPIO_DISABLE,  GPIO_PULL_DOWN    ), /* SPI2 - DI */
	GPIO_SETUP(B, 26, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* SPI2 - CS1 */
	GPIO_SETUP(B, 27, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* SPI2 - CK */
	GPIO_SETUP(G, 22, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* SPI2 - CS2 */

	GPIO_SETUP(C, 28, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* IIC1 - clock */
	GPIO_SETUP(C, 29, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* IIC1 - data */
	GPIO_SETUP(C, 30, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* IIC2 - clock */
	GPIO_SETUP(C, 31, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* IIC2 - data */

	GPIO_SETUP(D, 18, GPIO_DISABLE,  GPIO_PULL_UP      ), /* SDMMC - data0 */
	GPIO_SETUP(D, 19, GPIO_DISABLE,  GPIO_PULL_UP      ), /* SDMMC - data1 */
	GPIO_SETUP(D, 20, GPIO_DISABLE,  GPIO_PULL_UP      ), /* SDMMC - data2 */
	GPIO_SETUP(D, 21, GPIO_DISABLE,  GPIO_PULL_UP      ), /* SDMMC - data3 */
	GPIO_SETUP(D, 22, GPIO_DISABLE,  GPIO_PULL_UP      ), /* SDMMC - clock */
	GPIO_SETUP(D, 23, GPIO_DISABLE,  GPIO_PULL_UP      ), /* SDMMC - command */

	GPIO_SETUP(F, 0,  GPIO_IN, GPIO_PULL_DISABLE ), /* /MR */
	//GPIO_SETUP(F, 1,  GPIO_OUT_LOW,  GPIO_PULL_DISABLE ), /* WDI */

	GPIO_SETUP(F, 8,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* KPD - col 0 */
	GPIO_SETUP(F, 9,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* KPD - col 1 */
	GPIO_SETUP(F, 10, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* KPD - col 2 */
	GPIO_SETUP(F, 11, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* KPD - col 3 */
	GPIO_SETUP(F, 12, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* KPD - col 4 */

	GPIO_SETUP(F, 20, GPIO_OUT_HIGH, GPIO_PULL_DISABLE ), /* PHY - reset */
	GPIO_SETUP(E, 0,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - TXD0 */
	GPIO_SETUP(E, 1,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - TXD1 */
	GPIO_SETUP(E, 2,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - TXEN */
	GPIO_SETUP(E, 3,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - RXD0 */
	GPIO_SETUP(E, 4,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - RXD1 */
	GPIO_SETUP(E, 5,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - CRS_DV */
	GPIO_SETUP(E, 6,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - RXER */
	GPIO_SETUP(E, 7,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - REFCK */
	GPIO_SETUP(E, 8,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - MDIO */
	GPIO_SETUP(E, 9,  GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - MDC */
	GPIO_SETUP(E, 10, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - TXER */
	GPIO_SETUP(E, 11, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - TXD2 */
	GPIO_SETUP(E, 12, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - TXD3 */
	GPIO_SETUP(E, 13, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - RXD2 */
	GPIO_SETUP(E, 14, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - RXD3 */
	GPIO_SETUP(E, 15, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - RXCLK */
	GPIO_SETUP(E, 16, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - RXCRS */
	GPIO_SETUP(E, 17, GPIO_DISABLE,  GPIO_PULL_DISABLE ), /* MII - COL */
	
	GPIO_SETUP(F, 26, GPIO_IN,  GPIO_PULL_DISABLE ), /* /SVIPB_INT@V1.0A /SD_CD@V1.1A */
	GPIO_SETUP(G, 10, GPIO_OUT_LOW, GPIO_PULL_DISABLE ), /* /USB1_EN@V1.0A */
	GPIO_SETUP(F, 7,  GPIO_OUT_LOW, GPIO_PULL_DISABLE ), /* /USB1_EN@V1.1A */
};

/* Feature specific gpio settings */

static __initdata struct gpio_setup_t gpio_setup_emmc[] = {
	GPIO_SETUP(A, 19, GPIO_DISABLE,  GPIO_PULL_UP), /* EMMC - RST */
	GPIO_SETUP(E, 31, GPIO_DISABLE,  GPIO_PULL_UP), /* EMMC - CMD*/
};

static __initdata struct gpio_setup_t gpio_setup_nand[] = {
	GPIO_SETUP(A, 19, GPIO_DISABLE,  GPIO_PULL_DISABLE), /* NFL - NFLCLE */
	GPIO_SETUP(E, 31, GPIO_DISABLE,  GPIO_PULL_DISABLE), /* NFL - NFLREADY2 */
};

static struct dmw96_spi_info dmw96_spi1_info = {
	.bus_num    = 0,
	.set_cs     = NULL,
};

static struct resource dmw96_spi1_resources[] = {
	{
		.start  = DMW_SPI1_BASE,
		.end    = DMW_SPI1_BASE + 0x200 - 1,
		.flags  = IORESOURCE_MEM,
	},
	{
		.start  = DMW_IID_SPI1,
		.end    = DMW_IID_SPI1,
		.flags  = IORESOURCE_IRQ,
	},
	{
		.start  = 14, /* SPI1 RX */
		.end    = 14,
		.flags  = IORESOURCE_DMA,
	},
	{
		.start  = 15, /* SPI1 TX */
		.end    = 15,
		.flags  = IORESOURCE_DMA,
	},
};

static struct platform_device spi1_device = {
	.name = "dmw96-spi",
	.id = 0,
	.num_resources = ARRAY_SIZE(dmw96_spi1_resources),
	.resource = dmw96_spi1_resources,
	.dev = {
		.platform_data = &dmw96_spi1_info
	},
};

static struct i2c_pnx_data i2c0_data = {
	.name	= "pnx-i2c0",
	.base	= DMW_I2C1_BASE,
	.irq	= DMW_IID_I2C1,
	.scl	= GPIO_PORTC(28),
	.sda	= GPIO_PORTC(29),
};

static struct i2c_pnx_data i2c1_data = {
	.name	= "pnx-i2c1",
	.base	= DMW_I2C2_BASE,
	.irq	= DMW_IID_I2C2,
	.scl	= GPIO_PORTC(30),
	.sda	= GPIO_PORTC(31),
};

static struct platform_device i2c0_pnx_device = {
	.name	= "pnx-i2c",
	.id	= 0,
	.dev	= {
		.platform_data = &i2c0_data,
	},
};

static struct platform_device i2c1_pnx_device = {
	.name	= "pnx-i2c",
	.id	= 1,
	.dev	= {
		.platform_data = &i2c1_data,
	},
};

static struct i2c_board_info __initdata i2c0_devices[] = {

};

static struct i2c_board_info __initdata i2c1_devices[] = {
	{
		I2C_BOARD_INFO("pcf8563", 0x51),
		.platform_data = NULL,
	},
};

static struct resource dmw_uart0_resource[] = {
	{
		.start	= DMW_UART1_BASE,
		.end	= DMW_UART1_BASE + SZ_4K - 1,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start	= DMW_IID_UART1,
		.end	= DMW_IID_UART1,
		.flags	= IORESOURCE_IRQ,
	}
};

static struct platform_device uart0_device = {
	.name		= "dw-uart",
	.id		= 0,
	.num_resources	= ARRAY_SIZE(dmw_uart0_resource),
	.resource	= dmw_uart0_resource,
};

static struct resource dmw_uart1_resource[] = {
	{
		.start	= DMW_UART2_BASE,
		.end	= DMW_UART2_BASE + SZ_4K - 1,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start	= DMW_IID_UART2,
		.end	= DMW_IID_UART2,
		.flags	= IORESOURCE_IRQ,
	}
};

static struct platform_device uart1_device = {
	.name		= "dw-uart",
	.id		= 1,
	.num_resources	= ARRAY_SIZE(dmw_uart1_resource),
	.resource	= dmw_uart1_resource,
};

static struct plat_stmmacenet_data stmmaceth_plat_data = {
	.bus_id		= 0,
	.pbl		= 32, /* DMA burst length */
	.has_gmac	= 1,
	.enh_desc	= 0,
};

static struct resource stmmaceth_resources[] = {
	{
		.start	= DMW_MAC_BASE,
		.end	= DMW_MAC_BASE + SZ_4K + SZ_256 - 1,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start	= DMW_IID_8023MAC,
		.flags	= IORESOURCE_IRQ,
		.name	= "macirq",
	},
};

static struct platform_device stmmaceth_device = {
	.name		= "stmmaceth",
	.dev		= {
		.platform_data = &stmmaceth_plat_data,
		.coherent_dma_mask = DMA_BIT_MASK(32),
	},
	.num_resources	= ARRAY_SIZE(stmmaceth_resources),
	.resource	= stmmaceth_resources,
};

static struct plat_stmmacphy_data stmmacphy_plat_data[2] = {
    {
	    .bus_id		= 0,
	    .phy_addr	= 0,
	    .interface	= 0,
    }, 
    {
	    .bus_id		= 0,
	    .phy_addr	= 1,
	    .interface	= 0,
    }, 
};

static struct platform_device stmmacphy_device0 = {
    .id = 0,
    .name       = "stmmacphy",
	.dev		= {
		.platform_data = &stmmacphy_plat_data[0],
	},
};

static struct platform_device stmmacphy_device1 = {
    .id = 1,
	.name		= "stmmacphy",
    .dev		= {
	    .platform_data = &stmmacphy_plat_data[1],
    },
};

static struct mtd_partition gs_nandflash_partitions[] = {
	/* u-boot */
	{
		.name		= "u-boot",
		.offset		= MTD_OFFSET_UBOOT,
		.size		= MTD_SIZE_UBOOT,
		.mask_flags	= 0,
	},
	/* kernel */
	{
		.name		= "kernel",
		.offset		= MTD_OFFSET_KENEL,
		.size		= MTD_SIZE_KERNEL,
		.mask_flags	= 0,
	},
	/* recovery */
	{
		.name		= "recovery",
		.offset		= MTD_OFFSET_RECOVERY,
		.size		= MTD_SIZE_RECOVERY,
		.mask_flags	= 0,
	},
	/* system */
	{
		.name		= "system",
		.offset 	= MTD_OFFSET_SYSTEM,
		.size		= MTD_SIZE_SYSTEM,
		.mask_flags = 0,
	},
	/* cache */
	{
		.name		= "cache",
		.offset		= MTD_OFFSET_CACHE,
		.size		= MTD_SIZE_CACHE,
		.mask_flags	= 0,
	},
	/* userdata */
	{
		.name		= "userdata",
		.offset		= MTD_OFFSET_USERDATA,
		.size		= MTDPART_SIZ_FULL,
		.mask_flags	= 0,
	},
};

static struct gxp22xx_nand_pdata gs_nandflash_data = {
	.parts		= gs_nandflash_partitions,
	.nr_parts	= ARRAY_SIZE(gs_nandflash_partitions),
};

static struct resource dmw_nand_resources[] = {
	{
		.start	= DMW_NAND_LCD_BASE,
		.end	= DMW_NAND_LCD_BASE + SZ_4K - 1,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start  = DMW_IID_FLASH_CONTROLLER,
		.flags  = IORESOURCE_IRQ,
	},
};

static struct platform_device nand_device = {
	.name		= "dmw_nand",
	.dev		= {
		.coherent_dma_mask = ~0,
		.platform_data = &gs_nandflash_data,
	},
	.num_resources	= ARRAY_SIZE(dmw_nand_resources),
	.resource	= dmw_nand_resources,
};

static struct resource dw_mmc_resource[] = {
	{
		.start = DMW_SDMMC_BASE,
		.end   = DMW_SDMMC_BASE + SZ_4K - 1,
		.flags = IORESOURCE_MEM,
	},
	{
		.start = DMW_IID_SDMMC_CONTROLLER,
		.flags = IORESOURCE_IRQ,
	},
};

static int dw_mmc_init(u32 slot_id, irq_handler_t isr, void *dev_id)
{
	switch (slot_id) {
	case 0:
#ifndef CONFIG_GXE51XX_V10A
		enable_irq_wake(DMW_IID_EXTERNAL_REQUEST_10);
		return request_irq(DMW_IID_EXTERNAL_REQUEST_10, isr, IRQF_DISABLED |
				   IRQF_TRIGGER_RISING | IRQF_TRIGGER_FALLING,
				   "dw-mci cdetect", dev_id);
#endif
	case 1:
		return 0;
	default:
		return -ENOSYS;
	}
}

static int dw_mmc_get_ro(u32 slot_id)
{
	/* always read-write */
	return 0;
}

static int dw_mmc_get_cd(u32 slot_id)
{
	switch (slot_id) {
	case 0:
		return gpio_get_value(GPIO_PORTF(26));
	case 1:
		return 0;
	default:
		return 1;
	}
}

static struct dw_mci_board_slot dw_mmc_slots_normal[] = {
	{
		.id = 0,
		.caps = MMC_CAP_4_BIT_DATA,
		.init = dw_mmc_init,
		.get_ro = dw_mmc_get_ro,
		.get_cd = dw_mmc_get_cd,
	},
};

static struct dw_mci_board_slot dw_mmc_slots_emmc[] = {
	{
		.id = 1,
		.caps = MMC_CAP_4_BIT_DATA | MMC_CAP_8_BIT_DATA |
			MMC_CAP_NONREMOVABLE,
		.init = dw_mmc_init,
		.get_ro = dw_mmc_get_ro,
		.get_cd = dw_mmc_get_cd,
	},
	{
		.id = 0,
		.caps = MMC_CAP_4_BIT_DATA,
		.init = dw_mmc_init,
		.get_ro = dw_mmc_get_ro,
		.get_cd = dw_mmc_get_cd,
	},
};

static struct block_settings dw_mmc_blk_settings = {
	.max_segs = 64,
	.max_blk_size = 65536,
	.max_blk_count = 0xffffffff,
	.max_req_size = 0xffffffff,
	.max_seg_size = 4096,
};

static struct dw_mci_board dw_mmc_pdata = {
	.detect_delay_ms = 500,
	.bus_hz = 48000000,
	.blk_settings = &dw_mmc_blk_settings,
	.fifo_depth = 0x20,
	.quirks = DW_MCI_QUIRK_SBE_NEED_STOP | DW_MCI_QUIRK_HIGHSPEED,
};

static struct platform_device sdmmc_device = {
	.name = "dw_mmc",
	.dev.platform_data = &dw_mmc_pdata,
	.dev.coherent_dma_mask = DMA_BIT_MASK(32),
	.num_resources = ARRAY_SIZE(dw_mmc_resource),
	.resource = dw_mmc_resource,
};

static void reset_tdm0(int enable)
{
	if (enable)
		reset_set(RESET_TDM1);
	else
		reset_release(RESET_TDM1);
}

static void reset_tdm1(int enable)
{
	if (enable)
		reset_set(RESET_TDM2);
	else
		reset_release(RESET_TDM2);
}

static void reset_tdm2(int enable)
{
	if (enable)
		reset_set(RESET_TDM3);
	else
		reset_release(RESET_TDM3);
}

static struct dmw_tdm_pdata tdm0_pdata = {
	.reset = reset_tdm0,
};

static struct dmw_tdm_pdata tdm1_pdata = {
	.reset = reset_tdm1,
};

static struct dmw_tdm_pdata tdm2_pdata = {
	.reset = reset_tdm2,
};

static struct resource tdm0_resources[] = {
	{
		.start	= DMW_IID_TDM1,
		.end	= DMW_IID_TDM1,
		.flags	= IORESOURCE_IRQ,
	},
	{
		.start	= DMW_TDM1_BASE,
		.end	= DMW_TDM1_BASE + (2*SZ_4K) - 1,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start	= 8, /* capture -> TDM1 RX FIFO */
		.end	= 8,
		.flags	= IORESOURCE_DMA,
	},
	{
		.start	= 9, /* playback -> TDM1 TX FIFO */
		.end	= 9,
		.flags	= IORESOURCE_DMA,
	},
};

static struct resource tdm1_resources[] = {
	{
		.start	= DMW_IID_TDM2,
		.end	= DMW_IID_TDM2,
		.flags	= IORESOURCE_IRQ,
	},
	{
		.start	= DMW_TDM2_BASE,
		.end	= DMW_TDM2_BASE + (2*SZ_4K) - 1,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start	= 10, /* capture -> TDM2 RX FIFO */
		.end	= 10,
		.flags	= IORESOURCE_DMA,
	},
	{
		.start	= 11, /* playback -> TDM2 TX FIFO */
		.end	= 11,
		.flags	= IORESOURCE_DMA,
	},
};

static struct resource tdm2_resources[] = {
	{
		.start	= DMW_IID_TDM3,
		.end	= DMW_IID_TDM3,
		.flags	= IORESOURCE_IRQ,
	},
	{
		.start	= DMW_TDM3_BASE,
		.end	= DMW_TDM3_BASE + (2*SZ_4K) - 1,
		.flags	= IORESOURCE_MEM,
	},
	{
		.start	= 12, /* capture -> TDM3 RX FIFO */
		.end	= 12,
		.flags	= IORESOURCE_DMA,
	},
	{
		.start	= 13, /* playback -> TDM3 TX FIFO */
		.end	= 13,
		.flags	= IORESOURCE_DMA,
	},
};

static struct platform_device tdm0_device = {
	.name		= "dmw-tdm",
	.id		= 0,
	.dev		= {
		.platform_data = &tdm0_pdata,
	},
	.num_resources	= ARRAY_SIZE(tdm0_resources),
	.resource	= tdm0_resources,
};

static struct platform_device tdm1_device = {
	.name		= "dmw-tdm",
	.id		= 1,
	.dev		= {
		.platform_data = &tdm1_pdata,
	},
	.num_resources	= ARRAY_SIZE(tdm1_resources),
	.resource	= tdm1_resources,
};

static struct platform_device tdm2_device = {
	.name		= "dmw-tdm",
	.id		= 2,
	.dev		= {
		.platform_data = &tdm2_pdata,
	},
	.num_resources	= ARRAY_SIZE(tdm2_resources),
	.resource	= tdm2_resources,
};

/* kernel 2.6.39 ASoC changes: gdma snd pcm device */
static struct platform_device dmw_pcm_device = {
        .name   = "dmw-pcm-audio",
        .id     = -1,
};

#if 0
static struct gxp22xx_board_pdata dmw_gxp22xx_board_pdata = {
        .speak_sw = GPIO_PORTF(28),
        .mic_sw = GPIO_PORTF(6),
};
#endif
struct platform_device gs_mach_device = {
        .name = "gs-tdm-mach-drv",
        .id = -1,
        .dev = {
//                .platform_data = &dmw_gxp22xx_board_pdata,
        },
};



static void usb1_set_vbus_power(int enable)
{
	gpio_request(GPIO_PORTD(24), "usb1");
	gpio_direction_output(GPIO_PORTD(24), !!enable);
	gpio_set_enable(GPIO_PORTD(24), 1);
	gpio_free(GPIO_PORTD(24));
}

static struct dwc_otg_platform_data usb1_pdata = {
	.set_vbus_power		= usb1_set_vbus_power,
	.drvvbus_gpio		= GPIO_PORTD(24),
	.overcurrent_gpio	= -1,
	.vbusdetect_gpio	= GPIO_PORTF(20),
	.busy			= dmw_dram_request,
	.idle			= dmw_dram_release,
};

static struct resource usb1_resources[] = {
	{
		.start	= DMW_IID_USB1OTG_MC_NINT,
		.end	= DMW_IID_USB1OTG_MC_NINT,
		.flags	= IORESOURCE_IRQ,
	},
	{
		.start	= DMW_IID_USB1OTG_SOF_PULSE,
		.end	= DMW_IID_USB1OTG_SOF_PULSE,
		.flags	= IORESOURCE_IRQ,
	},
	{
		.start	= DMW_USB1_OTG_BASE,
		.end	= DMW_USB1_OTG_BASE + SZ_1M - 1,
		.flags	= IORESOURCE_MEM,
	},
};

static struct platform_device usb1_device = {
	.name		= "dwc_otg",
	.id		= 0,
	.dev		= {
		.coherent_dma_mask = DMA_BIT_MASK(32),
		.platform_data = &usb1_pdata,
	},
	.num_resources	= ARRAY_SIZE(usb1_resources),
	.resource	= usb1_resources,
};

#if defined(CONFIG_USB_ANDROID) || defined(CONFIG_USB_ANDROID_MODULE)
static char *android_usb_functions[] = {
#ifdef CONFIG_USB_ANDROID_ADB
	"adb",
#endif
#ifdef CONFIG_USB_ANDROID_MASS_STORAGE
	"usb_mass_storage",
#endif
#ifdef CONFIG_USB_ANDROID_ACM
	"acm",
#endif
#ifdef CONFIG_USB_ANDROID_RNDIS
	"rndis",
#endif
};

static struct android_usb_platform_data android_usb_data = {
	.vendor_id = 0x18D1,
	.product_id = 1,
	.product_name = "GXE5124",
	.manufacturer_name = "GrandStream",
	.serial_number = "GS-GXE5124",
	.num_functions = ARRAY_SIZE(android_usb_functions),
	.functions = android_usb_functions,
};

static struct platform_device android_usb = {
	.name			= "android_usb",
	.id			= -1,
	.dev			= {
		.platform_data	= &android_usb_data,
	},
};

#ifdef CONFIG_USB_ANDROID_MASS_STORAGE
static struct usb_mass_storage_platform_data android_mass_storage = {
	.nluns = 1,
};

static struct platform_device android_usb_mass_storage = {
	.name			= "usb_mass_storage",
	.id			= -1,
	.dev			= {
		.platform_data	= &android_mass_storage,
	},
};
#endif

#ifdef CONFIG_USB_ANDROID_RNDIS
static struct usb_ether_platform_data rndis_usb_data = {
	.ethaddr	= { 0x00, 0x0b, 0x82, 0x12, 0x03, 0x31 },
	.vendorID	= 0,
	.vendorDescr	= "GrandStream",
};

static struct platform_device rndis = {
	.name			= "rndis",
	.id			= -1,
	.dev			= {
		.platform_data	= &rndis_usb_data,
	},
};
#endif

#endif /* CONFIG_USB_ANDROID || CONFIG_USB_ANDROID_MODULE */

static struct platform_device *gs_platform_devs[] __initdata = {
	&i2c0_pnx_device,
	&i2c1_pnx_device,
	&stmmaceth_device,
	&stmmacphy_device0,
	&stmmacphy_device1,
	&sdmmc_device,
	&spi1_device,
	&tdm0_device,
	&tdm1_device,
	&tdm2_device,

	&dmw_pcm_device,   /* ASoC Platform (PCM) driver */
	&gs_mach_device,  /* ASoC UCM Machine driver */
	&uart0_device,
	&uart1_device,
	&usb1_device,
	//&usb2_device,
};

static int console_enabled = 0;
static int __init early_console_enabled(char *str)
{
	get_option(&str, &console_enabled);
	return 0;
}
early_param("console_enabled", early_console_enabled);

static int __init dmw_gxe5124_dev_init(void)
{
	uint32_t reg;

	if (!dmw_board_is("ucm6xxx"))
		return -ENODEV;

	/*
	 * Configure pads according to the used devices
	 */
	reg = readl(IO_ADDRESS(DMW_SYSCFG_BASE) + DMW_SYSCFG_SPCR1);
	reg |= DMW_SYSCFG_SPCR1_BB_PAD_EN;

	if (GS_STORAGE_EMMC==gs_get_storage())
		reg |= DMW_SYSCFG_SPCR1_EMMC_PAD_EN;
	else
		reg |= DMW_SYSCFG_SPCR1_FC_PAD_EN;

	if(console_enabled) reg |= DMW_SYSCFG_SPCR1_UART1_PAD_EN;
	else reg &= ~DMW_SYSCFG_SPCR1_UART1_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_UART2_PAD_EN;

	reg |= DMW_SYSCFG_SPCR1_TDM1_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_TDM2_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_TDM3_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_SPI1_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_SPI2_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_I2C_1_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_I2C_2_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_SD_PAD_EN;
	reg |= DMW_SYSCFG_SPCR1_EMACA_PAD_EN;

	writel(reg, IO_ADDRESS(DMW_SYSCFG_BASE) + DMW_SYSCFG_SPCR1);

	reg = readl(IO_ADDRESS(DMW_SYSCFG_BASE) + DMW_SYSCFG_SPCR2);
	reg |= DMW_SYSCFG_SPCR2_CIU_PAD_EN;
	reg |= DMW_SYSCFG_SPCR2_DP_CLK_PAD_EN;
	writel(reg, IO_ADDRESS(DMW_SYSCFG_BASE) + DMW_SYSCFG_SPCR2);

	/* Setup GPIOs */
	dmw_gpio_setup(gpio_setup_default, ARRAY_SIZE(gpio_setup_default));

	/*
	 * Release USB from reset.
	 */
	reset_set(RESET_USB1_PHY_POR);
	reset_set(RESET_USB1_PHY_PORT);
	reset_set(RESET_USB1_MAC_PHYIF);
	reset_set(RESET_USB1_MAC_RST);
	udelay(10); reset_release(RESET_USB1_PHY_POR);
	udelay(40); reset_release(RESET_USB1_PHY_PORT);
	udelay(10); reset_release(RESET_USB1_MAC_PHYIF);
	udelay(10); reset_release(RESET_USB1_MAC_RST);

	reset_set(RESET_USB2_PHY_POR);
	reset_set(RESET_USB2_PHY_PORT);
	reset_set(RESET_USB2_MAC_PHYIF);
	reset_set(RESET_USB2_MAC_RST);
	udelay(10); reset_release(RESET_USB2_PHY_POR);
	udelay(40); reset_release(RESET_USB2_PHY_PORT);
	udelay(10); reset_release(RESET_USB2_MAC_PHYIF);
	udelay(10); reset_release(RESET_USB2_MAC_RST);

   	/*
	 * Register SPI and I2C devices.
	 */
	/* Setup GPIOs */
//	dmw_gpio_setup(gpio_setup_fxo, ARRAY_SIZE(gpio_setup_fxo));
//	spi_register_board_info(gxe5124_spi_devs, ARRAY_SIZE(gxe5124_spi_devs));

	i2c_register_board_info(0, i2c0_devices, ARRAY_SIZE(i2c0_devices));
	i2c_register_board_info(1, i2c1_devices, ARRAY_SIZE(i2c1_devices));

#if defined(CONFIG_USB_ANDROID) || defined(CONFIG_USB_ANDROID_MODULE)
	platform_device_register(&android_usb);
#ifdef CONFIG_USB_ANDROID_MASS_STORAGE
	platform_device_register(&android_usb_mass_storage);
#endif
#ifdef CONFIG_USB_ANDROID_RNDIS
	platform_device_register(&rndis);
#endif
#endif

	if (GS_STORAGE_EMMC==gs_get_storage()) {
		dmw_gpio_setup(gpio_setup_emmc, ARRAY_SIZE(gpio_setup_emmc));
		dw_mmc_pdata.slots = dw_mmc_slots_emmc;
		dw_mmc_pdata.num_slots = ARRAY_SIZE(dw_mmc_slots_emmc);
	} else {
		dmw_gpio_setup(gpio_setup_nand, ARRAY_SIZE(gpio_setup_nand));
		dw_mmc_pdata.slots = dw_mmc_slots_normal;
		dw_mmc_pdata.num_slots = ARRAY_SIZE(dw_mmc_slots_normal);
		platform_device_register(&nand_device);
	}

	return platform_add_devices(gs_platform_devs, ARRAY_SIZE(gs_platform_devs));
}

arch_initcall(dmw_gxe5124_dev_init);
